/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class StoredProcedureGenerator {
    public SchemaManager schemaManager;
    private Hashtable storedProcedures;
    private Hashtable mappingStoredProcedures;
    private Hashtable intToTypeConverterHash;
    private Writer writer;
    private String prefix;
    private static final String DEFAULT_PREFIX = "";
    private Hashtable sequenceProcedures;
    private static final int MAX_NAME_SIZE = 30;

    public StoredProcedureGenerator(SchemaManager schemaMngr) {
        this.schemaManager = schemaMngr;
        this.sequenceProcedures = new Hashtable();
        this.storedProcedures = new Hashtable();
        this.mappingStoredProcedures = new Hashtable();
        this.buildIntToTypeConverterHash();
        this.prefix = DEFAULT_PREFIX;
        this.verify();
    }

    protected void buildIntToTypeConverterHash() {
        this.intToTypeConverterHash = new Hashtable();
        this.intToTypeConverterHash.put(new Integer(8), Double.class);
        this.intToTypeConverterHash.put(new Integer(-7), Boolean.class);
        this.intToTypeConverterHash.put(new Integer(-3), Byte[].class);
        this.intToTypeConverterHash.put(new Integer(-6), Short.class);
        this.intToTypeConverterHash.put(new Integer(5), Short.class);
        this.intToTypeConverterHash.put(new Integer(4), Integer.class);
        this.intToTypeConverterHash.put(new Integer(2), BigDecimal.class);
        this.intToTypeConverterHash.put(new Integer(6), Float.class);
        this.intToTypeConverterHash.put(new Integer(1), Character.class);
        this.intToTypeConverterHash.put(new Integer(12), String.class);
        this.intToTypeConverterHash.put(new Integer(91), Date.class);
        this.intToTypeConverterHash.put(new Integer(93), Timestamp.class);
        this.intToTypeConverterHash.put(new Integer(3), BigDecimal.class);
        this.intToTypeConverterHash.put(new Integer(-5), BigDecimal.class);
        this.intToTypeConverterHash.put(new Integer(7), Float.class);
        this.intToTypeConverterHash.put(new Integer(-1), String.class);
        this.intToTypeConverterHash.put(new Integer(92), Time.class);
        this.intToTypeConverterHash.put(new Integer(-2), Byte[].class);
        this.intToTypeConverterHash.put(new Integer(-4), Byte[].class);
    }

    protected String buildProcedureString(SQLCall call) {
        String stringToModify = call.getSQLString();
        String replacementToken = this.getSession().getPlatform().getStoredProcedureParameterPrefix();
        StringWriter stringWriter = new StringWriter();
        int startIndex = 0;
        int nextParamIndex = 0;
        int tokenIndex = stringToModify.indexOf("?");
        while (tokenIndex != -1) {
            stringWriter.write(stringToModify.substring(startIndex, tokenIndex));
            startIndex = tokenIndex + 1;
            Object parameter = call.getParameters().elementAt(nextParamIndex);
            if (parameter instanceof DatabaseField) {
                stringWriter.write(replacementToken);
                stringWriter.write(((DatabaseField)parameter).getName());
            } else if (parameter instanceof ParameterExpression) {
                stringWriter.write(replacementToken);
                stringWriter.write(((ParameterExpression)parameter).getField().getName());
            } else {
                this.getSession().getPlatform().appendParameter(call, stringWriter, parameter);
            }
            tokenIndex = stringToModify.indexOf("?", startIndex);
            ++nextParamIndex;
        }
        stringWriter.write(stringToModify.substring(startIndex));
        return stringWriter.toString();
    }

    public void generateAmendmentClass(Writer outputWriter, String packageName, String className) throws ValidationException {
        String methodComment = "/**\n * TopLink generated method. \n * <b>WARNING</b>: This code was generated by an automated tool.\n * Any changes will be lost when the code is re-generated\n */";
        try {
            FieldDefinition fieldDefinition;
            Enumeration argumentEnum;
            Vector storedProcedureDefinitionArguments;
            StoredProcedureDefinition definition;
            outputWriter.write("package ");
            outputWriter.write(packageName);
            outputWriter.write(";\n\nimport java.util.*;\nimport java.lang.reflect.*;");
            outputWriter.write("\nimport org.eclipse.persistence.queries.*;\nimport org.eclipse.persistence.sessions.*;\nimport org.eclipse.persistence.mappings.*;\n\n/**\n * ");
            outputWriter.write("This is a TopLink generated class to add stored procedure admendments to a project.  \n * Anychanges to this code will be lost when the class is regenerated \n */\npublic class ");
            outputWriter.write(className);
            outputWriter.write("{\n");
            Enumeration descriptorEnum = this.storedProcedures.keys();
            while (descriptorEnum.hasMoreElements()) {
                ClassDescriptor descriptor = (ClassDescriptor)descriptorEnum.nextElement();
                if (descriptor.isDescriptorForInterface() || descriptor.isAggregateDescriptor()) continue;
                outputWriter.write(methodComment);
                outputWriter.write("\npublic static void amend");
                outputWriter.write(Helper.getShortClassName(descriptor.getJavaClass()));
                outputWriter.write("ClassDescriptor(ClassDescriptor descriptor){\n\t");
                Vector storedProcedureVector = (Vector)this.storedProcedures.get(descriptor);
                Hashtable mappingHashtable = (Hashtable)this.mappingStoredProcedures.get(descriptor);
                definition = (StoredProcedureDefinition)storedProcedureVector.elementAt(0);
                outputWriter.write("\n\t//INSERT QUERY\n");
                outputWriter.write("\tInsertObjectQuery insertQuery = new InsertObjectQuery();\n\tStoredProcedureCall call = new StoredProcedureCall();\n");
                outputWriter.write("\tcall.setProcedureName(\"");
                outputWriter.write(definition.getName());
                outputWriter.write("\");\n\t");
                storedProcedureDefinitionArguments = definition.getArguments();
                argumentEnum = storedProcedureDefinitionArguments.elements();
                while (argumentEnum.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                    outputWriter.write("call.addNamedArgument(\"");
                    outputWriter.write(fieldDefinition.getName());
                    outputWriter.write("\", \"");
                    outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                }
                outputWriter.write("insertQuery.setCall(call);\n\tdescriptor.getQueryManager().setInsertQuery(insertQuery);\n\t");
                definition = (StoredProcedureDefinition)storedProcedureVector.elementAt(1);
                if (definition != null) {
                    outputWriter.write("\n\t//UPDATE QUERY\n");
                    outputWriter.write("\tUpdateObjectQuery updateQuery = new UpdateObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    outputWriter.write("\tcall.setProcedureName(\"");
                    outputWriter.write(definition.getName());
                    outputWriter.write("\");\n\t");
                    storedProcedureDefinitionArguments = definition.getArguments();
                    argumentEnum = storedProcedureDefinitionArguments.elements();
                    while (argumentEnum.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                        outputWriter.write("call.addNamedArgument(\"");
                        outputWriter.write(fieldDefinition.getName());
                        outputWriter.write("\", \"");
                        outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                        outputWriter.write("\");\n\t");
                    }
                    outputWriter.write("updateQuery.setCall(call);\n\tdescriptor.getQueryManager().setUpdateQuery(updateQuery);\n");
                }
                definition = (StoredProcedureDefinition)storedProcedureVector.elementAt(2);
                outputWriter.write("\n\t//DELETE QUERY\n");
                outputWriter.write("\tDeleteObjectQuery deleteQuery = new DeleteObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                outputWriter.write("\tcall.setProcedureName(\"");
                outputWriter.write(definition.getName());
                outputWriter.write("\");\n\t");
                storedProcedureDefinitionArguments = definition.getArguments();
                argumentEnum = storedProcedureDefinitionArguments.elements();
                while (argumentEnum.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                    outputWriter.write("call.addNamedArgument(\"");
                    outputWriter.write(fieldDefinition.getName());
                    outputWriter.write("\", \"");
                    outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                }
                outputWriter.write("deleteQuery.setCall(call);\n\tdescriptor.getQueryManager().setDeleteQuery(deleteQuery);\n");
                if (storedProcedureVector.size() > 3) {
                    definition = (StoredProcedureDefinition)storedProcedureVector.elementAt(3);
                    outputWriter.write("\n\t//READ OBJECT QUERY\n");
                    outputWriter.write("\tReadObjectQuery readQuery = new ReadObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    outputWriter.write("\tcall.setProcedureName(\"");
                    outputWriter.write(definition.getName());
                    outputWriter.write("\");\n\t");
                    storedProcedureDefinitionArguments = definition.getArguments();
                    argumentEnum = storedProcedureDefinitionArguments.elements();
                    while (argumentEnum.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                        outputWriter.write("call.addNamedArgument(\"");
                        outputWriter.write(fieldDefinition.getName());
                        outputWriter.write("\", \"");
                        outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                        outputWriter.write("\");\n\t");
                    }
                    outputWriter.write("readQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadObjectQuery(readQuery);\n");
                }
                if (storedProcedureVector.size() > 4) {
                    definition = (StoredProcedureDefinition)storedProcedureVector.elementAt(4);
                    outputWriter.write("\n\t//READ ALL QUERY\n");
                    outputWriter.write("\tReadAllQuery readAllQuery = new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                    outputWriter.write("\tcall.setProcedureName(\"");
                    outputWriter.write(definition.getName());
                    outputWriter.write("\");\n\t");
                    storedProcedureDefinitionArguments = definition.getArguments();
                    argumentEnum = storedProcedureDefinitionArguments.elements();
                    while (argumentEnum.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                        outputWriter.write("call.addNamedArgument(\"");
                        outputWriter.write(fieldDefinition.getName());
                        outputWriter.write("\", \"");
                        outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                        outputWriter.write("\");\n\t");
                    }
                    outputWriter.write("readAllQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadAllQuery(readAllQuery);\n");
                }
                if (mappingHashtable != null) {
                    outputWriter.write("\n\t//MAPPING QUERIES\n");
                    outputWriter.write("\tReadAllQuery mappingQuery; \n");
                    outputWriter.write("\tDeleteAllQuery deleteMappingQuery; \n");
                    Enumeration e = mappingHashtable.keys();
                    while (e.hasMoreElements()) {
                        String mappingName = (String)e.nextElement();
                        definition = (StoredProcedureDefinition)((Hashtable)mappingHashtable.get(mappingName)).get("1MREAD");
                        if (definition != null) {
                            outputWriter.write("\n\t//MAPPING READALL QUERY FOR " + mappingName + "\n");
                            outputWriter.write("\tmappingQuery= new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                            outputWriter.write("\tcall.setProcedureName(\"");
                            outputWriter.write(definition.getName());
                            outputWriter.write("\");\n\t");
                            storedProcedureDefinitionArguments = definition.getArguments();
                            argumentEnum = storedProcedureDefinitionArguments.elements();
                            while (argumentEnum.hasMoreElements()) {
                                fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                                outputWriter.write("call.addNamedArgument(\"");
                                outputWriter.write(fieldDefinition.getName());
                                outputWriter.write("\", \"");
                                outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                                outputWriter.write("\");\n\t");
                            }
                            outputWriter.write("mappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + mappingName + "\")).setCustomSelectionQuery(mappingQuery);\n");
                        }
                        if ((definition = (StoredProcedureDefinition)((Hashtable)mappingHashtable.get(mappingName)).get("1MDALL")) == null) continue;
                        outputWriter.write("\n\t//MAPPING DELETEALL QUERY FOR " + mappingName + "\n");
                        outputWriter.write("\tdeleteMappingQuery= new DeleteAllQuery();\n\tcall = new StoredProcedureCall();\n");
                        outputWriter.write("\tcall.setProcedureName(\"");
                        outputWriter.write(definition.getName());
                        outputWriter.write("\");\n\t");
                        storedProcedureDefinitionArguments = definition.getArguments();
                        argumentEnum = storedProcedureDefinitionArguments.elements();
                        while (argumentEnum.hasMoreElements()) {
                            fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                            outputWriter.write("call.addNamedArgument(\"");
                            outputWriter.write(fieldDefinition.getName());
                            outputWriter.write("\", \"");
                            outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                            outputWriter.write("\");\n\t");
                        }
                        outputWriter.write("deleteMappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + mappingName + "\")).setCustomDeleteAllQuery(deleteMappingQuery);\n");
                    }
                }
                outputWriter.write("}\n");
            }
            definition = (StoredProcedureDefinition)this.sequenceProcedures.get("SELECT");
            if (definition != null) {
                outputWriter.write("\n\tValueReadQuery seqSelectQuery = new ValueReadQuery();\n\tcall = new StoredProcedureCall();\n");
                outputWriter.write("\tcall.setProcedureName(\"");
                outputWriter.write(definition.getName());
                outputWriter.write("\");\n\t");
                storedProcedureDefinitionArguments = definition.getArguments();
                argumentEnum = storedProcedureDefinitionArguments.elements();
                while (argumentEnum.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)argumentEnum.nextElement();
                    outputWriter.write("call.addNamedArgument(\"");
                    outputWriter.write(fieldDefinition.getName());
                    outputWriter.write("\", \"");
                    outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                    outputWriter.write("seqSelectQuery.addArgument(\"" + this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                }
                outputWriter.write("seqSelectQuery.setCall(call);\n\tproject.getLogin().setSelectSequenceNumberQuery(seqSelectQuery);\n");
            }
            outputWriter.write("}\n");
            outputWriter.write(methodComment);
            outputWriter.write("\npublic static void amendDescriptors(org.eclipse.persistence.sessions.Project project) throws Exception{");
            outputWriter.write("\n\tamendSequences(project);");
            outputWriter.write("\n\tfor(Iterator enumtr = project.getDescriptors().values().iterator(); enumtr.hasNext();) {");
            outputWriter.write("\n\t\tDescriptor descriptor = (ClassDescriptor)enumtr.next();");
            outputWriter.write("\n\t\tif(!(descriptor.isAggregateDescriptor() || descriptor.isDescriptorForInterface())) {");
            outputWriter.write("\n\t\t\tMethod method = " + className + ".class.getMethod(\"amend\"+org.eclipse.persistence.internal.helper.Helper.getShortClassName(descriptor.getJavaClass())+\"ClassDescriptor\", new Class[] {ClassDescriptor.class});");
            outputWriter.write("\n\t\t\tmethod.invoke(null, new Object[] {descriptor});");
            outputWriter.write("\n\t\t}");
            outputWriter.write("\n\t}");
            outputWriter.write("\n}");
            outputWriter.write("\n}\n");
            outputWriter.flush();
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected StoredProcedureDefinition generateDeleteStoredProcedure(ClassDescriptor descriptor) {
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setDescriptor(descriptor);
        deleteQuery.setModifyRow(new DatabaseRecord());
        return this.generateObjectStoredProcedure(deleteQuery, descriptor.getPrimaryKeyFields(), "DEL_");
    }

    protected StoredProcedureDefinition generateInsertStoredProcedure(ClassDescriptor descriptor) {
        InsertObjectQuery insertQuery = new InsertObjectQuery();
        insertQuery.setDescriptor(descriptor);
        insertQuery.setModifyRow(descriptor.getObjectBuilder().buildTemplateInsertRow(this.getSession()));
        return this.generateObjectStoredProcedure(insertQuery, descriptor.getFields(), "INS_");
    }

    protected Hashtable generateMappingStoredProcedures(ClassDescriptor descriptor) {
        Vector<DatabaseMapping> mappings = descriptor.getMappings();
        Hashtable mappingSP = new Hashtable();
        Enumeration<DatabaseMapping> enumtr = mappings.elements();
        while (enumtr.hasMoreElements()) {
            Hashtable<String, StoredProcedureDefinition> mappingTable = new Hashtable<String, StoredProcedureDefinition>();
            DatabaseMapping mapping = enumtr.nextElement();
            if (!mapping.isOneToManyMapping()) continue;
            if (!this.getSession().getPlatform().isOracle()) {
                mappingTable.put("1MREAD", this.generateOneToManyMappingReadProcedure((OneToManyMapping)mapping));
            }
            if (mapping.isPrivateOwned()) {
                mappingTable.put("1MDALL", this.generateOneToManyMappingDeleteAllProcedure((OneToManyMapping)mapping));
            }
            mappingSP.put(mapping.getAttributeName(), mappingTable);
        }
        return mappingSP;
    }

    protected StoredProcedureDefinition generateObjectStoredProcedure(DatabaseQuery query, List fields, String namePrefix) {
        String className = Helper.getShortClassName(query.getDescriptor().getJavaClass());
        return this.generateStoredProcedure(query, fields, this.getPrefix() + namePrefix + className);
    }

    protected StoredProcedureDefinition generateOneToManyMappingDeleteAllProcedure(OneToManyMapping mapping) {
        ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setDescriptor(targetDescriptor);
        deleteAllQuery.setReferenceClass(targetDescriptor.getJavaClass());
        deleteAllQuery.setSelectionCriteria(mapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(mapping, deleteAllQuery, mapping.getTargetForeignKeyToSourceKeys(), "D_1M_");
    }

    protected StoredProcedureDefinition generateOneToManyMappingProcedures(OneToManyMapping mapping, DatabaseQuery query, Map fields, String namePrefix) {
        String sourceClassName = Helper.getShortClassName(mapping.getDescriptor().getJavaClass());
        return this.generateStoredProcedure(query, new ArrayList(fields.values()), this.getPrefix() + namePrefix + sourceClassName + "_" + mapping.getAttributeName());
    }

    protected StoredProcedureDefinition generateOneToManyMappingReadProcedure(OneToManyMapping mapping) {
        ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(targetDescriptor);
        readAllQuery.setReferenceClass(targetDescriptor.getJavaClass());
        readAllQuery.setSelectionCriteria(mapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(mapping, readAllQuery, mapping.getTargetForeignKeyToSourceKeys(), "R_1M_");
    }

    protected StoredProcedureDefinition generateReadAllStoredProcedure(ClassDescriptor descriptor) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(descriptor);
        readAllQuery.setReferenceClass(descriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readAllQuery, descriptor.getPrimaryKeyFields(), "RALL_");
    }

    protected StoredProcedureDefinition generateReadStoredProcedure(ClassDescriptor descriptor) {
        ReadObjectQuery readQuery = new ReadObjectQuery();
        readQuery.setDescriptor(descriptor);
        readQuery.setReferenceClass(descriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readQuery, descriptor.getPrimaryKeyFields(), "READ_");
    }

    protected void generateSequenceStoredProcedures(Project project) {
        DatabaseLogin login = (DatabaseLogin)project.getDatasourceLogin();
        if (login.shouldUseNativeSequencing()) {
            return;
        }
        if (project.usesSequencing() && !this.getSession().getPlatform().isOracle()) {
            StoredProcedureDefinition definition = new StoredProcedureDefinition();
            definition.setName(Helper.truncate(project.getName() + "SEQ_SEL", 30));
            definition.addArgument("SEQ_NAME", String.class, 100);
            definition.addArgument("PREALLOC_SIZE", BigDecimal.class, 10);
            definition.addStatement("UPDATE " + ((TableSequence)login.getDefaultSequence()).getTableName() + " SET " + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + " = " + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + " + " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "PREALLOC_SIZE WHERE " + ((TableSequence)login.getDefaultSequence()).getNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            definition.addStatement("SELECT " + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + " FROM " + ((TableSequence)login.getDefaultSequence()).getTableName() + " WHERE " + ((TableSequence)login.getDefaultSequence()).getNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            this.sequenceProcedures.put("SELECT", definition);
            this.writeDefinition(definition);
        }
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery query, List fields, String name) {
        return this.generateStoredProcedure(query, fields, new DatabaseRecord(), name);
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery query, List fields, AbstractRecord rowForPrepare, String name) {
        StoredProcedureDefinition definition = new StoredProcedureDefinition();
        Vector<String> statementVector = new Vector<String>();
        query.checkPrepare(this.getSession(), rowForPrepare, true);
        Vector callVector = ((CallQueryMechanism)query.getQueryMechanism()).getCalls();
        if (callVector.isEmpty() && ((CallQueryMechanism)query.getQueryMechanism()).getCall() != null) {
            callVector.addElement(((CallQueryMechanism)query.getQueryMechanism()).getCall());
        }
        Enumeration enumtr = callVector.elements();
        while (enumtr.hasMoreElements()) {
            SQLCall call = (SQLCall)enumtr.nextElement();
            statementVector.addElement(this.buildProcedureString(call));
        }
        definition.setStatements(statementVector);
        Hashtable fieldNames = new Hashtable();
        List primaryKeyFields = fields;
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField databaseField = (DatabaseField)primaryKeyFields.get(index);
            fieldNames.put(databaseField.getName(), this.schemaManager.getColumnInfo(null, null, databaseField.getTableName(), databaseField.getName()).firstElement());
        }
        definition.setName(Helper.truncate(name, 30));
        Enumeration fieldsEnum = fieldNames.keys();
        String prefixArgToken = this.getSession().getPlatform().isOracle() ? this.getSession().getPlatform().getStoredProcedureParameterPrefix() : DEFAULT_PREFIX;
        while (fieldsEnum.hasMoreElements()) {
            AbstractRecord dataRow = (AbstractRecord)fieldNames.get(fieldsEnum.nextElement());
            Number dataType = (Number)dataRow.get("DATA_TYPE");
            Class type = this.getFieldType(dataType);
            String typeName = (String)dataRow.get("TYPE_NAME");
            if (type != null || typeName == null || typeName.length() == 0) {
                definition.addArgument(prefixArgToken + (String)dataRow.get("COLUMN_NAME"), type, ((Number)dataRow.get("COLUMN_SIZE")).intValue());
                continue;
            }
            definition.addArgument(prefixArgToken + (String)dataRow.get("COLUMN_NAME"), typeName);
        }
        return definition;
    }

    public void generateStoredProcedures() {
        boolean wasBinding = this.getSession().getLogin().shouldBindAllParameters();
        this.getSession().getLogin().setShouldBindAllParameters(false);
        Map descriptors = this.getSession().getProject().getDescriptors();
        Iterator iterator = descriptors.keySet().iterator();
        this.generateSequenceStoredProcedures(this.getSession().getProject());
        while (iterator.hasNext()) {
            ClassDescriptor desc = (ClassDescriptor)descriptors.get(iterator.next());
            if (desc.isDescriptorForInterface() || desc.isAggregateDescriptor() || desc.isAggregateCollectionDescriptor()) continue;
            StoredProcedureDefinition definition = this.generateInsertStoredProcedure(desc);
            Vector<StoredProcedureDefinition> definitionVector = new Vector<StoredProcedureDefinition>();
            definitionVector.addElement(definition);
            this.writeDefinition(definition);
            definition = this.generateUpdateStoredProcedure(desc);
            definitionVector.addElement(definition);
            this.writeDefinition(definition);
            definition = this.generateDeleteStoredProcedure(desc);
            definitionVector.addElement(definition);
            this.writeDefinition(definition);
            if (!this.getSession().getPlatform().isOracle()) {
                definition = this.generateReadStoredProcedure(desc);
                definitionVector.addElement(definition);
                this.writeDefinition(definition);
                definition = this.generateReadAllStoredProcedure(desc);
                definitionVector.addElement(definition);
                this.writeDefinition(definition);
            }
            Hashtable mappingDefinitions = this.generateMappingStoredProcedures(desc);
            Enumeration enum2 = mappingDefinitions.elements();
            while (enum2.hasMoreElements()) {
                Hashtable table = (Hashtable)enum2.nextElement();
                definition = (StoredProcedureDefinition)table.get("1MREAD");
                if (definition != null) {
                    this.writeDefinition(definition);
                }
                if ((definition = (StoredProcedureDefinition)table.get("1MDALL")) == null) continue;
                this.writeDefinition(definition);
            }
            this.storedProcedures.put(desc, definitionVector);
            if (mappingDefinitions.isEmpty()) continue;
            this.mappingStoredProcedures.put(desc, mappingDefinitions);
        }
        this.getSession().getLogin().setShouldBindAllParameters(wasBinding);
    }

    public void generateStoredProcedures(Writer writerOrNull) {
        this.writer = writerOrNull;
        this.schemaManager.outputDDLToWriter(this.getWriter());
        this.generateStoredProcedures();
        try {
            this.getWriter().flush();
        }
        catch (IOException exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    protected StoredProcedureDefinition generateUpdateStoredProcedure(ClassDescriptor descriptor) {
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        updateQuery.setDescriptor(descriptor);
        updateQuery.setModifyRow(descriptor.getObjectBuilder().buildTemplateUpdateRow(this.getSession()));
        return this.generateObjectStoredProcedure(updateQuery, descriptor.getFields(), "UPD_");
    }

    protected String getFieldName(String argumentName) {
        if (this.getSession().getPlatform().isOracle()) {
            return argumentName.substring(this.getSession().getPlatform().getStoredProcedureParameterPrefix().length());
        }
        return argumentName;
    }

    protected Class getFieldType(Object jdbcDataType) {
        Integer key = new Integer(((Number)jdbcDataType).intValue());
        return (Class)this.intToTypeConverterHash.get(key);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public AbstractSession getSession() {
        return this.schemaManager.getSession();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected void verify() throws ValidationException {
        if (this.getSession().getProject().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingNotSupportedWithStoredProcedureGeneration();
        }
    }

    public void writeDefinition(StoredProcedureDefinition definition) {
        this.schemaManager.replaceObject(definition);
    }
}

