/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.adapters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebam.adapters.AdapterConfiguration;
import org.eclipse.ebam.adapters.AdapterFactory;
import org.eclipse.ebam.adapters.ConfigurationReader;
import org.eclipse.ebam.adapters.IAdapter;
import org.eclipse.ebam.adapters.IAdapterManager;
import org.eclipse.ebam.cache.MsgCaching;
import org.eclipse.ebam.dispatcher.IMsgDispatcher;
import org.eclipse.ebam.dispatcher.MsgDispatcher;
import org.eclipse.ebam.emf.interfaces.ICacheTransaction;
import org.eclipse.ebam.emf.interfaces.IJournalTransactions;
import org.eclipse.ebam.emf.interfaces.IMessageTransaction;
import org.eclipse.ebam.engine.interfaces.IEventProcessor;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.Journal;
import org.eclipse.ebam.transformer.MsgTransformer;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterManager
implements IAdapterManager {
    private AtomicReference<ICacheTransaction> cacheReference = new AtomicReference();
    private AtomicReference<IMessageTransaction> messageReference = new AtomicReference();
    private AtomicReference<IJournalTransactions> journalReference = new AtomicReference();
    private ICacheTransaction cacheTransaction = null;
    private IMessageTransaction messageTransaction = null;
    private IJournalTransactions journalTransactions = null;
    private Map<String, String> properties;
    private IMsgDispatcher dispatcher;
    private AdapterConfiguration configuration;
    private static Logger logger = LoggerFactory.getLogger(AdapterManager.class);
    private List<IAdapter> listAdapter;
    private ConfigurationReader configurationReader;
    private boolean useCaching = false;
    private boolean useTransformer = false;
    private boolean startManager = true;
    private ConcurrentHashMap<String, IEventProcessor> processors = new ConcurrentHashMap();

    protected void activate(ComponentContext componentContext) {
        logger.info("Activate Component Manager Adapter");
        try {
            this.configurationReader = ConfigurationReader.getInstance(componentContext.getBundleContext());
            this.messageTransaction = this.messageReference.get();
            this.journalTransactions = this.journalReference.get();
            this.cacheTransaction = this.cacheReference.get();
            this.init();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        try {
            this.stop();
            logger.debug("Deactivating component Adapter Manager");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.useCaching = false;
        this.useTransformer = false;
        this.listAdapter = new ArrayList<IAdapter>();
        this.dispatcher = new MsgDispatcher(this);
        this.dispatcher.init();
        this.configuration = AdapterConfiguration.getInstance();
        IAdapter adapter = null;
        Map<String, String> managerProperties = this.configuration.getProperties();
        if ("true".equals(managerProperties.get("caching"))) {
            this.useCaching = true;
        }
        if ("true".equals(managerProperties.get("transformer"))) {
            this.useTransformer = true;
        }
        if ("osgi".equals(this.configuration.getManagerType())) {
            this.dispatcher.setProcessors(this.processors);
        }
        List<String> adapters_name = this.configuration.getNameAdapters();
        for (String name : adapters_name) {
            logger.info(" Creating adapter :" + name);
            Map<String, String> adapterProps = this.configuration.getLogAdapters().get(name);
            String modality = adapterProps.get("modality");
            String appendString = adapterProps.get("append");
            String keyModeString = adapterProps.get("key");
            boolean append = false;
            boolean keyMode = false;
            String key = null;
            if (modality != null && modality.equals("RECOVERY")) {
                try {
                    Journal lastEntry = this.journalTransactions.getJornalForRecovery(name);
                    if (lastEntry != null) {
                        key = lastEntry.getLabel();
                        logger.info("Last entry for recovery: " + key + " journal ID:" + lastEntry.getJurnalId());
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (appendString != null && appendString.equalsIgnoreCase("TRUE")) {
                append = true;
            }
            if (keyModeString != null && keyModeString.equalsIgnoreCase("TRUE")) {
                keyMode = true;
            }
            if ((adapter = AdapterFactory.createAdapter(this, name, keyMode, key, append)) == null) continue;
            ThreadAdapter t = new ThreadAdapter(adapter);
            t.start();
            this.listAdapter.add(adapter);
        }
    }

    public void start() {
    }

    @Override
    public void sendToManager(IEbamMessage message) {
        logger.info("sendToManager: Ricevuto messaggio : " + message.getMsg());
        try {
            this.processMessage(message);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        this.startManager = false;
    }

    public void processMessage(IEbamMessage mess) {
        if (this.useCaching) {
            MsgCaching caching = new MsgCaching(this.messageTransaction, this.journalTransactions, this.cacheTransaction);
            caching.savetoCache(mess);
        }
        if (this.useTransformer) {
            MsgTransformer transformer = new MsgTransformer();
            mess = transformer.transform(mess);
        }
        this.dispatcher.sendToMsgDispatch(mess);
    }

    public void setEventProcessor(IEventProcessor eventProcessor) {
        logger.debug("setEventProcessor : pushing reference Processor: " + eventProcessor.getName());
        this.processors.put(eventProcessor.getName(), eventProcessor);
    }

    public void unsetEventProcessor(IEventProcessor eventProcessor) {
        this.processors.remove(eventProcessor.getName());
    }

    public ConcurrentHashMap<String, IEventProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(ConcurrentHashMap<String, IEventProcessor> processors) {
        this.processors = processors;
    }

    public void setCacheTransaction(ICacheTransaction cacheTransaction) {
        logger.debug("setCacheTransaction : pushing reference cacheTransaction");
        this.cacheReference.set(cacheTransaction);
    }

    public void unsetCacheTransaction(ICacheTransaction cacheTransaction) {
        this.cacheReference.compareAndSet(cacheTransaction, null);
    }

    public void setJournalTransactions(IJournalTransactions journalTransaction) {
        logger.debug("setJournalTransactions : pushing reference journalTransaction");
        this.journalReference.set(journalTransaction);
    }

    public void unsetJournalTransactions(IJournalTransactions journalTransaction) {
        this.journalReference.compareAndSet(journalTransaction, null);
    }

    public void setMessageTransaction(IMessageTransaction messageTransaction) {
        logger.debug("setMessageTransaction : pushing reference messageTransaction");
        this.messageReference.set(messageTransaction);
    }

    public void unsetMessageTransaction(IMessageTransaction messageTransaction) {
        this.messageReference.compareAndSet(messageTransaction, null);
    }

    @Override
    public ICacheTransaction getCacheTransaction() {
        return this.cacheTransaction;
    }

    @Override
    public IMessageTransaction getMessageTransaction() {
        return this.messageTransaction;
    }

    @Override
    public IJournalTransactions getJournalTransactions() {
        return this.journalTransactions;
    }

    private class ThreadAdapter
    extends Thread {
        IAdapter adapter = null;

        public ThreadAdapter(IAdapter a) {
            this.adapter = a;
        }

        public void run() {
            this.adapter.start();
        }
    }
}

