/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.adapters.utils;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class FilesContainer {
    File directory = null;
    String rootLabel = null;

    public FilesContainer(String directoryPath, String rootFileLabel) {
        this.directory = new File(directoryPath);
        int indexOfPoint = rootFileLabel.indexOf(46);
        if (indexOfPoint != -1) {
            rootFileLabel = rootFileLabel.substring(0, indexOfPoint);
        }
        this.rootLabel = rootFileLabel;
    }

    public final File[] getSortedArray() {
        File[] allFiles = this.directory.listFiles();
        Vector<File> labelFilesVector = new Vector<File>();
        if (allFiles != null) {
            int i = 0;
            while (i < allFiles.length) {
                String fileName = allFiles[i].getName();
                if (fileName.startsWith(this.rootLabel)) {
                    labelFilesVector.add(allFiles[i]);
                }
                ++i;
            }
        }
        int j = 0;
        File[] labelFiles = new File[labelFilesVector.size()];
        Iterator iterator = labelFilesVector.iterator();
        while (iterator.hasNext()) {
            File object;
            labelFiles[j] = object = (File)iterator.next();
            ++j;
        }
        Arrays.sort(labelFiles, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (((File)o1).lastModified() > ((File)o2).lastModified()) {
                    return 1;
                }
                if (((File)o1).lastModified() < ((File)o2).lastModified()) {
                    return -1;
                }
                return 0;
            }
        });
        return labelFiles;
    }

    public File getFirstFile() {
        File toReturn = null;
        File[] files = this.getSortedArray();
        if (files != null && files.length > 0) {
            toReturn = files[0];
        }
        return toReturn;
    }

    public File getLastFile() {
        File toReturn = null;
        File[] files = this.getSortedArray();
        if (files != null && files.length > 0) {
            toReturn = files[files.length - 1];
        }
        return toReturn;
    }

    public final File getNextFile(String actualFile) {
        File[] files = this.getSortedArray();
        int index = -1;
        int i = files.length - 1;
        while (i >= 0 && index == -1) {
            File file = files[i];
            if (file.getName().equals(actualFile)) {
                index = i;
            }
            --i;
        }
        if (index != -1 && index < files.length - 1) {
            return files[index + 1];
        }
        return null;
    }
}

