/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IComponentBroker;
import org.eclipse.hyades.logging.adapter.IExtractor;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.impl.BasicContext;
import org.eclipse.hyades.logging.adapter.impl.ComponentBroker;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.Situation;

public class MultithreadedContext
extends BasicContext {
    private IComponentBroker[] brokers = new IComponentBroker[4];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        CommonBaseEvent startEvent = this.getEventFactory().createCommonBaseEvent();
        startEvent.setMsg(Messages.getString("HyadesGAContext_Started_INFO_", this.getName()));
        startEvent.setSeverity((short)10);
        Situation startSituation = this.getEventFactory().createSituation();
        startSituation.setStartSituation("INTERNAL", "START COMPLETED", "SUCCESSFUL");
        startEvent.setSituation(startSituation);
        this.log(startEvent);
        IComponent[] contextComponents = this.getComponents();
        int i = 0;
        while (i < contextComponents.length) {
            int brokerIndex = -1;
            if (contextComponents[i] instanceof IExtractor) {
                brokerIndex = 0;
            } else if (contextComponents[i] instanceof IParser) {
                brokerIndex = 1;
            } else if (contextComponents[i] instanceof IFormatter) {
                brokerIndex = 2;
            } else if (contextComponents[i] instanceof IOutputter) {
                brokerIndex = 3;
            }
            if (brokerIndex != -1) {
                if (this.brokers[brokerIndex] == null) {
                    this.brokers[brokerIndex] = new ComponentBroker("Broker " + brokerIndex, this.listener);
                }
                this.brokers[brokerIndex].addEventConsumer(contextComponents[i]);
            }
            ++i;
        }
        i = this.brokers.length - 1;
        while (i > 0) {
            if (this.brokers[i] != null) {
                int j = i - 1;
                while (j >= 0) {
                    if (this.brokers[j] != null) {
                        this.brokers[j].setNextBroker(this.brokers[i]);
                    }
                    --j;
                }
            }
            --i;
        }
        i = 0;
        while (i < contextComponents.length) {
            startEvent = this.getEventFactory().createCommonBaseEvent();
            startEvent.setMsg(Messages.getString("HyadesGAComponent_Started_INFO_", contextComponents[i].getName()));
            startEvent.setSeverity((short)10);
            startSituation = this.getEventFactory().createSituation();
            startSituation.setStartSituation("INTERNAL", "START COMPLETED", "SUCCESSFUL");
            startEvent.setSituation(startSituation);
            this.log(startEvent);
            ++i;
        }
        i = 0;
        while (i < this.brokers.length) {
            if (this.brokers[i] != null) {
                this.brokers[i].start();
            }
            ++i;
        }
        try {
            ISensor sensor = (ISensor)this.getComponents()[0];
            try {
                while (!this.isHardStop()) {
                    if (this.stopping) {
                        return;
                    }
                    if (this.listener != null) {
                        try {
                            this.listener.preProcessEventItems(sensor, null);
                        }
                        catch (Throwable throwable) {}
                    }
                    Object[] msgs = sensor.getNext();
                    if (this.listener != null) {
                        try {
                            this.listener.postProcessEventItems(sensor, msgs);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (msgs == null) {
                        this.handleControledStop();
                        continue;
                    }
                    this.resetControledStop();
                    this.brokers[0].queueEvents(msgs);
                }
                return;
            }
            catch (Exception e) {
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.setMsg(e.toString());
                event.setSeverity((short)60);
                this.log(event);
                return;
            }
        }
        catch (Throwable e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)60);
            this.log(event);
        }
    }

    public void stop() {
        try {
            this.brokers[0].flushAndTerminate();
        }
        catch (InterruptedException interruptedException) {}
        super.stop();
    }
}

