/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;


/**
 * The persistent class for the data_attributes database table.
 * 
 */
@Entity
@Table(name="EBAM_DATA_ATTRIBUTES")
public class DataAttribute implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="ATTRIBUTE_ID")
	private Integer attributeId;

	@Column(name="ATTR_TYPE")
	private String attrType;

	@Column(name="DATA_TYPE")
	private String dataType;

    @Lob()
	@Column(name="EXPRESSION")
	private String expression;

	@Column(name="NAME")
	private String name;
	
	@Column(name="FATHER_ID")
	private String fatherId;
	
	@Column(name="\"LEVEL\"")
	private String level;

	//bi-directional many-to-one association to Message
    @ManyToOne
	@JoinColumn(name="MESSAGE_ID")
	private Message message;

	//bi-directional many-to-one association to MessageContent
	@OneToMany(mappedBy="dataAttribute",fetch=FetchType.LAZY)
	private Set<MessageContent> messageContents;

    public DataAttribute() {
    }

	public int getAttributeId() {
		return this.attributeId;
	}

	public void setAttributeId(int attributeId) {
		this.attributeId = attributeId;
	}

	public String getAttrType() {
		return this.attrType;
	}

	public void setAttrType(String attrType) {
		this.attrType = attrType;
	}

	public String getDataType() {
		return this.dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	public String getExpression() {
		return this.expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Message getMessage() {
		return this.message;
	}

	public void setMessage(Message message) {
		this.message = message;
	}
	
	public Set<MessageContent> getMessageContents() {
		return this.messageContents;
	}

	public void setMessageContents(Set<MessageContent> messageContents) {
		this.messageContents = messageContents;
	}

	public String getFatherId() {
		return fatherId;
	}

	public void setFatherId(String fatherId) {
		this.fatherId = fatherId;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}
	
	public QName toQName(String s){
		QName result = XPathConstants.STRING;
		if("String".equalsIgnoreCase(s))
			result = XPathConstants.STRING;
		if("Int".equalsIgnoreCase(s))
			result = XPathConstants.NUMBER;
		if("List".equalsIgnoreCase(s))
			result = XPathConstants.NODESET;
		if("Boolean".equalsIgnoreCase(s))
			result = XPathConstants.BOOLEAN;
		return result;
	}
}