/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.data.Action;

public final class ShapedAction {
    private final StructureSource _oSource;
    private final Shape _sh;
    private final Map<TriggerCondition, Action> _triggers = new HashMap<TriggerCondition, Action>();
    private Cursor cursor;
    private int zOrder = 0;

    ShapedAction(StructureSource oSource, Location[] loa, Shape clipping) {
        this._oSource = oSource;
        int[][] i2a = SwingRendererImpl.getCoordinatesAsInts(loa);
        if (clipping != null) {
            Area ar1 = new Area(clipping);
            Area ar2 = new Area(new Polygon(i2a[0], i2a[1], loa.length));
            ar2.intersect(ar1);
            this._sh = ar2;
        } else {
            this._sh = new Polygon(i2a[0], i2a[1], loa.length);
        }
    }

    ShapedAction(StructureSource oSource, Bounds boEllipse, Shape clipping) {
        this._oSource = oSource;
        if (clipping != null) {
            Area ar1 = new Area(clipping);
            Area ar2 = new Area(new Ellipse2D.Double(boEllipse.getLeft(), boEllipse.getTop(), boEllipse.getWidth(), boEllipse.getHeight()));
            ar2.intersect(ar1);
            this._sh = ar2;
        } else {
            this._sh = new Ellipse2D.Double(boEllipse.getLeft(), boEllipse.getTop(), boEllipse.getWidth(), boEllipse.getHeight());
        }
    }

    ShapedAction(StructureSource oSource, Bounds boEllipse, double dStart, double dExtent, int iArcType, Shape clipping) {
        this._oSource = oSource;
        if (clipping != null) {
            Area ar1 = new Area(clipping);
            Area ar2 = new Area(new Arc2D.Double(boEllipse.getLeft(), boEllipse.getTop(), boEllipse.getWidth(), boEllipse.getHeight(), dStart, dExtent, iArcType));
            ar2.intersect(ar1);
            this._sh = ar2;
        } else {
            this._sh = new Arc2D.Double(boEllipse.getLeft(), boEllipse.getTop(), boEllipse.getWidth(), boEllipse.getHeight(), dStart, dExtent, iArcType);
        }
    }

    public final Shape getShape() {
        return this._sh;
    }

    public final Action getActionForCondition(TriggerCondition condition) {
        return this._triggers.get(condition);
    }

    public final StructureSource getSource() {
        return this._oSource;
    }

    public void add(TriggerCondition tc, Action ac) {
        this._triggers.put(tc, ac);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public void setZOrder(int zOrder) {
        this.zOrder = zOrder;
    }
}

