/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSLong;

public class XSInt
extends XSLong {
    private static final String XS_INT = "xs:int";

    public XSInt() {
        this(BigInteger.valueOf(0L));
    }

    public XSInt(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_INT;
    }

    public String type_name() {
        return "int";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger min = BigInteger.valueOf(Integer.MIN_VALUE);
            BigInteger max = BigInteger.valueOf(Integer.MAX_VALUE);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                DynamicError.throw_type_error();
            }
            rs.add(new XSInt(bigInt));
            return rs;
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }
}

