/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.command.ElementBackRefRecord;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.StructBackRefRecord;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureContextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyCommand
extends AbstractElementCommand {
    public AbstractPropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    protected void assertExtendedElement(Module module, DesignElement element, PropertyDefn prop) {
        ExtendedItem extendedItem;
        if (element instanceof ExtendedItem && ((extendedItem = (ExtendedItem)element).isExtensionModelProperty(prop.getName()) || extendedItem.isExtensionXMLProperty(prop.getName()))) assert (((ExtendedItem)element).getExtendedElement() != null);
    }

    protected void checkItem(StructureContext context, IStructure item) throws SemanticException {
        this.checkItem(context.getElementProp(), context.getPropDefn(), item);
    }

    private void checkItems(PropertyDefn propDefn, PropertyDefn memberDefn, List<Object> items) throws SemanticException {
        if (items == null) {
            return;
        }
        ArrayList<Object> currentList = new ArrayList<Object>();
        int i = 0;
        while (i < items.size()) {
            IStructure struct = (IStructure)items.get(i);
            this.checkItem(propDefn, (StructPropertyDefn)memberDefn, struct);
            List<SemanticException> errors = StructureListValidator.getInstance().validateForAdding(this.element.getHandle(this.module), memberDefn, currentList, struct);
            if (!errors.isEmpty()) {
                throw errors.get(0);
            }
            currentList.add(struct);
            ++i;
        }
    }

    private void checkItem(PropertyDefn propDefn, PropertyDefn memberDefn, IStructure item) throws SemanticException {
        List<SemanticException> errorList;
        assert (item != null);
        PropertyDefn currentDefn = propDefn;
        if (memberDefn == null) {
            if (item.getDefn() != propDefn.getStructDefn()) {
                throw new PropertyValueException(this.element, propDefn, (Object)item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
        } else {
            if (item.getDefn() != memberDefn.getStructDefn()) {
                throw new PropertyValueException(this.element, propDefn, propDefn, item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
            currentDefn = memberDefn;
        }
        Iterator<IPropertyDefn> iter = item.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn tmpMemberDefn = (PropertyDefn)iter.next();
            if ("libReference".equals(tmpMemberDefn.getName())) continue;
            Object value = ((Structure)item).getLocalProperty(this.module, tmpMemberDefn);
            if (value instanceof ElementRefValue && tmpMemberDefn.getTypeCode() == 15) {
                ElementRefValue refValue = (ElementRefValue)value;
                if (refValue.isResolved()) {
                    refValue.unresolved(refValue.getElement().getName());
                }
                value = tmpMemberDefn.validateValue(this.module, this.element, refValue.getQualifiedReference());
                this.checkRecursiveElementReference(tmpMemberDefn, (ElementRefValue)value);
            } else if (tmpMemberDefn.isList() && tmpMemberDefn.getStructDefn() != null) {
                this.checkItems(currentDefn, tmpMemberDefn, (List)value);
            } else {
                value = tmpMemberDefn.validateValue(this.module, this.element, value);
            }
            if (item instanceof PropertyBinding && tmpMemberDefn.getName().equals("value")) {
                EncryptionUtil.setEncryptionBindingValue(this.module, (Structure)item, tmpMemberDefn, value);
                continue;
            }
            item.setProperty(tmpMemberDefn, value);
        }
        if (item instanceof Structure && !(errorList = ((Structure)item).validate(this.module, this.element)).isEmpty()) {
            throw errorList.get(0);
        }
    }

    protected void adjustReferenceClients(ReferencableStructure struct) {
        assert (struct != null);
        if (!struct.hasReferences()) {
            return;
        }
        ArrayList<BackRef> clients = new ArrayList<BackRef>(struct.getClientList());
        for (BackRef ref : clients) {
            DesignElement client = ref.getElement();
            StructBackRefRecord record = new StructBackRefRecord(this.module, struct, client, ref.getPropertyName());
            this.getActivityStack().execute(record);
        }
    }

    protected void checkRecursiveElementReference(PropertyDefn memberDefn, ElementRefValue refValue) throws SemanticException {
        DesignElement reference;
        assert (refValue != null);
        if (refValue.isResolved() && this.element instanceof IReferencableElement && ModelUtil.isRecursiveReference(reference = refValue.getElement(), (IReferencableElement)((Object)this.element))) {
            throw new SemanticError(this.element, new String[]{reference.getIdentifier()}, "Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE");
        }
    }

    protected void checkItemName(StructureContext memberContext, String newName) throws SemanticException {
        ElementPropertyDefn propDefn = memberContext.getElementProp();
        Structure structure = memberContext.getStructure();
        List<SemanticException> errors = StructureListValidator.getInstance().validateForRenaming(this.element.getHandle(this.module), propDefn, memberContext.getList(this.module), structure, memberContext.getPropDefn(), newName);
        if (!errors.isEmpty()) {
            throw (PropertyValueException)errors.get(0);
        }
    }

    protected void adjustReferenceClients(Structure referred, StructureContext memberContext) {
        IStructureDefn structDefn = referred.getDefn();
        Iterator<IPropertyDefn> memberDefns = structDefn.getPropertyIterator();
        while (memberDefns.hasNext()) {
            ReferenceValue refValue;
            StructPropertyDefn memberDefn = (StructPropertyDefn)memberDefns.next();
            if (memberDefn.getTypeCode() != 15 || (refValue = (ReferenceValue)referred.getLocalProperty(this.module, memberDefn)) == null || !refValue.isResolved()) continue;
            IReferencableElement client = (IReferencableElement)((Object)((ElementRefValue)refValue).getElement());
            ElementBackRefRecord record = new ElementBackRefRecord(this.module, client, referred, memberDefn.getName());
            this.getActivityStack().execute(record);
        }
    }

    StructureContext makeLocalCompositeValue(StructureContext context) {
        assert (context != null);
        ElementPropertyDefn propDefn = context.getElementProp();
        if (propDefn.isListType()) {
            List list = (ArrayList)this.element.getLocalProperty(this.module, propDefn);
            if (list != null) {
                return context;
            }
            ArrayList inherited = (ArrayList)this.element.getProperty(this.module, propDefn);
            if (inherited != null) {
                list = (List)ModelUtil.copyValue(propDefn, inherited);
                if (propDefn.getTypeCode() == 16) {
                    StructureContextUtil.setStructureContext(propDefn, list, this.element);
                }
            } else {
                list = new ArrayList();
            }
            PropertyRecord propRecord = new PropertyRecord(this.element, propDefn, list);
            this.getActivityStack().execute(propRecord);
            context = StructureContextUtil.getLocalStructureContext(this.module, this.element, context);
            return context;
        }
        Structure struct = (Structure)this.element.getLocalProperty(this.module, propDefn);
        if (struct != null) {
            return context;
        }
        Structure inherited = (Structure)this.element.getProperty(this.module, propDefn);
        if (inherited != null) {
            IStructure copy = inherited.copy();
            StructureContextUtil.setupStructureContext((Structure)copy);
            PropertyRecord propRecord = new PropertyRecord(this.element, propDefn, (Object)copy);
            this.getActivityStack().execute(propRecord);
            context = StructureContextUtil.getLocalStructureContext(this.module, this.element, context);
        }
        return context;
    }

    protected Object checkItem(PropertyDefn prop, Object item) throws PropertyValueException {
        assert (item != null);
        assert (prop.getTypeCode() == 20);
        Object value = item;
        if (item instanceof DesignElementHandle) {
            value = ((DesignElementHandle)item).getElement();
        }
        PropertyType type = prop.getSubType();
        assert (type != null);
        Object result = type.validateValue(this.module, this.element, prop, value);
        return result;
    }

    protected ContentElementInfo getEventTarget() {
        DesignElement tmpContainer = this.element.getContainer();
        if (tmpContainer == null) {
            return null;
        }
        String tmpPropName = this.element.getContainerInfo().getPropertyName();
        if (tmpPropName == null) {
            return null;
        }
        return ModelUtil.getContentContainer(this.element, tmpContainer.getPropertyDefn(tmpPropName));
    }
}

