/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.validators.StyleReferenceValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.interfaces.IStyledElementModel;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyledElement
extends DesignElement
implements IStyledElementModel {
    protected ElementRefValue style = null;

    public StyledElement() {
    }

    public StyledElement(String theName) {
        super(theName);
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        StyledElement element = (StyledElement)super.doClone(policy);
        element.style = this.style != null ? new ElementRefValue(null, this.style.getName()) : null;
        return element;
    }

    @Override
    public StyleElement getStyle(Module module) {
        if (this.style == null) {
            return null;
        }
        if (this.style.isResolved()) {
            return (StyleElement)this.style.getElement();
        }
        if (module == null) {
            return null;
        }
        DesignElement resolvedElement = module.resolveElement((DesignElement)this, this.style.getName(), (PropertyDefn)this.getPropertyDefn("style"), null);
        StyleElement target = null;
        if (resolvedElement != null) {
            target = (StyleElement)resolvedElement;
            this.style.resolve(target);
            target.addClient(this, "style");
        }
        return target;
    }

    public String getStyleName() {
        if (this.style == null) {
            return null;
        }
        return this.style.getName();
    }

    @Override
    public StyleElement getStyle() {
        if (this.style == null) {
            return null;
        }
        return (StyleElement)this.style.getElement();
    }

    public void setStyle(StyleElement newStyle) {
        StyleElement oldStyle = null;
        if (this.style != null) {
            oldStyle = (StyleElement)this.style.getElement();
        }
        if (oldStyle == newStyle && (this.style == null || this.style.isResolved())) {
            return;
        }
        if (oldStyle != null) {
            oldStyle.dropClient(this);
        }
        if (newStyle != null) {
            if (this.style == null) {
                this.style = new ElementRefValue(null, newStyle);
            } else {
                this.style.resolve(newStyle);
            }
            newStyle.addClient(this, "style");
        } else {
            this.style = null;
        }
    }

    public void setStyleName(String theName) {
        if (this.style == null && theName == null) {
            return;
        }
        this.setStyle(null);
        assert (this.style == null);
        this.style = new ElementRefValue(null, theName);
    }

    @Override
    public boolean hasLocalPropertyValues() {
        if (super.hasLocalPropertyValues()) {
            return true;
        }
        return this.style != null;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (propName.equals("style")) {
            return this.style;
        }
        return super.getIntrinsicProperty(propName);
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(StyleReferenceValidator.getInstance().validate(module, this));
        list.addAll(Style.validateStyleProperties(module, this));
        return list;
    }

    @Override
    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!prop.isStyleProperty()) {
            return super.getFactoryProperty(module, prop);
        }
        return this.cachedPropStrategy.getPropertyFromElement(module, this, prop);
    }

    @Override
    public void clearAllProperties() {
        super.clearAllProperties();
        this.style = null;
    }
}

