/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.validators.MasterPageRequiredValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.LayoutModule;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.util.ContentIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReportDesignImpl
extends LayoutModule
implements IReportDesignModel,
ICssStyleSheetOperation {
    private ICssStyleSheetOperation operation = null;
    private HashMap<DesignElement, String> sourceMap;
    private HashMap<String, HashMap<String, DesignElement>> namespaceMap;

    public ReportDesignImpl() {
        super((DesignSessionImpl)null);
        this.initSlots();
        this.onCreate();
    }

    public ReportDesignImpl(DesignSessionImpl session) {
        super(session);
        this.initSlots();
        this.onCreate();
    }

    @Override
    public final List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(MasterPageRequiredValidator.getInstance().validate(this, this));
        list.addAll(this.validateStructureList(module, "images"));
        list.addAll(this.validateStructureList(module, "colorPalette"));
        list.addAll(this.validateStructureList(module, "includeScripts"));
        list.addAll(this.validateStructureList(module, "libraries"));
        list.addAll(this.validateStructureList(module, "propertyBindings"));
        return list;
    }

    @Override
    public final String getElementName() {
        return "ReportDesign";
    }

    @Override
    public final DesignElementHandle getHandle(Module module) {
        return this.handle();
    }

    public abstract ReportDesignHandle handle();

    public final IncludeScript findIncludeScript(String fileName) {
        ArrayList list = (ArrayList)this.getLocalProperty(null, "includeScripts");
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            IncludeScript script = (IncludeScript)list.get(i);
            if (script.getFileName() != null && script.getFileName().equals(fileName)) {
                return script;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected final int getSlotCount() {
        return 10;
    }

    public final List<Object> collectPropValues(int slotId, String propName) {
        ArrayList<Object> rtnList = new ArrayList<Object>();
        ContentIterator contents = new ContentIterator((Module)this, new ContainerContext((DesignElement)this, slotId));
        while (contents.hasNext()) {
            DesignElement ele = contents.next();
            Object obj = ele.getLocalProperty((Module)this, propName);
            if (obj == null) continue;
            rtnList.add(obj);
        }
        return rtnList;
    }

    public final byte[] getThumbnail() {
        String data = this.getStringProperty(this, "thumbnail");
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    @Override
    public final int dropCss(CssStyleSheet css) {
        if (this.operation == null) {
            return -1;
        }
        return this.operation.dropCss(css);
    }

    @Override
    public final void addCss(CssStyleSheet css) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.addCss(css);
    }

    @Override
    public final void insertCss(CssStyleSheet css, int index) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.insertCss(css, index);
    }

    @Override
    public final List<CssStyleSheet> getCsses() {
        if (this.operation == null) {
            return Collections.emptyList();
        }
        return this.operation.getCsses();
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        Module module = (Module)super.doClone(policy);
        if (this.isCached()) {
            this.cacheValues();
        }
        return module;
    }

    @Override
    public final void cacheValues() {
        this.setIsCached(true);
        super.cacheValues();
        ContentIterator iter1 = new ContentIterator((Module)this, new ContainerContext((DesignElement)this, 6));
        while (iter1.hasNext()) {
            DesignElement tmpElement = iter1.next();
            if (!(tmpElement instanceof ReportItem)) continue;
            ((ReportItem)tmpElement).cacheValues();
        }
    }

    public final VariableElement findVariableElement(String name) {
        return (VariableElement)this.nameHelper.getNameSpace(9).getElement(name);
    }

    public void cacheFlattenElement(DesignElement originalElement, DesignElement flattenElement) {
        if (this.sourceMap == null) {
            this.sourceMap = new LinkedHashMap<DesignElement, String>();
            this.namespaceMap = new LinkedHashMap<String, HashMap<String, DesignElement>>();
        }
        String namespace = originalElement.getRoot().getNamespace();
        this.sourceMap.put(flattenElement, namespace);
        HashMap<String, DesignElement> nameMapping = this.namespaceMap.get(namespace);
        if (nameMapping == null) {
            nameMapping = new LinkedHashMap<String, DesignElement>();
            this.namespaceMap.put(namespace, nameMapping);
        }
        nameMapping.put(originalElement.getName(), flattenElement);
    }

    public DesignElement getFlattenElement(DesignElement element, String originalName) {
        DesignElement flattenElement;
        HashMap<String, DesignElement> nameMapping;
        String namespace;
        if (element != null && this.sourceMap != null && (namespace = this.sourceMap.get(element)) != null && (nameMapping = this.namespaceMap.get(namespace)) != null && (flattenElement = nameMapping.get(originalName)) != null) {
            return flattenElement;
        }
        return null;
    }
}

