/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportUtil {
    public static void downloadResource(URI location, File target, IProgressMonitor monitor) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        try {
            RepositoryTransport.getInstance().download(location, (OutputStream)out, monitor);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static void readResource(URI location, TextContentProcessor processor, IProgressMonitor monitor) throws IOException, CoreException {
        InputStream in = RepositoryTransport.getInstance().stream(location, monitor);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            processor.process(reader);
        }
        finally {
            in.close();
        }
    }

    public static boolean verifyAvailability(List<? extends URI> locations, boolean one, IProgressMonitor monitor) throws IOException, CoreException {
        if (locations.isEmpty() || locations.size() > 5) {
            throw new IllegalArgumentException();
        }
        int countFound = 0;
        for (URI uRI : locations) {
            block5: {
                try {
                    RepositoryTransport.getInstance().getLastModified(uRI, monitor);
                    if (!one) break block5;
                    return true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (one) continue;
                    return false;
                }
            }
            ++countFound;
        }
        return countFound == locations.size();
    }

    public static interface TextContentProcessor {
        public void process(Reader var1) throws IOException;
    }
}

