/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.messagewidgets;

import java.util.Iterator;
import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessageWizardPage;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessagesListComposite;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageDataAttributeTabItem;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageEngineTabItem;
import org.eclipse.ebam.emf.MessageTransactions;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.MessageEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesDetailComposite
extends Composite {
    private MessageWizardPage messageWizardPage = null;
    private MessageDetailTabItem detailTabItem = null;
    private MessageEngineTabItem messageEngineTabItem = null;
    private MessageDataAttributeTabItem messageDataAttributeTabItem = null;
    private Button buttonSave;
    private CTabFolder tabFolder = null;
    private Label statusLabel = null;
    public static String INSERTING = "INSERT A NEW MESSAGE";
    public static String MODIFYING = "MODIFY SELECTED MESSAGE";
    public static String EMPTY = "                                                       ";
    public static String INSERTING_ATT = "INSERT A NEW DATA ATTRIBUTE";
    public static String MODIFYING_ATT = "MODIFY A DATA ATTRIBUTE";
    private static Logger logger = LoggerFactory.getLogger(MessagesDetailComposite.class);

    public MessagesDetailComposite(Composite parent, int style, MessageWizardPage messageWizardPage1) {
        super(parent, style);
        this.messageWizardPage = messageWizardPage1;
    }

    public void drawComp() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setForeground(new Color((Device)this.getDisplay(), ColorConstants.statusLabelColor));
        this.statusLabel.setText(EMPTY);
        this.statusLabel.setLayoutData((Object)new GridData(64));
        this.buttonSave = new Button((Composite)this, 8);
        this.buttonSave.setToolTipText("Save message details");
        this.buttonSave.setLayoutData((Object)new GridData(128));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSave.setImage(saveImage);
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MessagesDetailComposite.this.saveButtonPush();
                    MessagesDetailComposite.this.statusLabel.setText(EMPTY);
                }
                catch (Exception e) {
                    logger.error("database connection exception " + e.getMessage(), (Throwable)e);
                    MessageDialog.openError((Shell)MessagesDetailComposite.this.getShell(), (String)"Error", (String)"Error in inserting/updating message");
                }
            }
        });
        this.buttonSave.setEnabled(false);
        try {
            this.tabFolder = new CTabFolder((Composite)this, 2048);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setEnabled(false);
            this.detailTabItem = new MessageDetailTabItem(this.tabFolder, 0, this);
            this.detailTabItem.setText("Detail");
            this.detailTabItem.drawComp(this.tabFolder);
            this.messageEngineTabItem = new MessageEngineTabItem(this.tabFolder, 0, this);
            this.messageEngineTabItem.setText("Engines");
            this.messageEngineTabItem.drawComp(this.tabFolder);
            this.messageDataAttributeTabItem = new MessageDataAttributeTabItem(this.tabFolder, 0, this);
            this.messageDataAttributeTabItem.setText("Data Attribute");
            this.messageDataAttributeTabItem.drawComp(this.tabFolder);
        }
        catch (Exception exception) {
            logger.error("could not create Messages wizard");
            return;
        }
    }

    private void saveButtonPush() throws WizardException, Exception {
        logger.debug("IN");
        Table messagesTable = this.getMessageWizardPage().getListComposite().getMessagesTable();
        int index = messagesTable.getSelectionIndex();
        Message message = null;
        if (index == -1) {
            message = new Message();
        } else {
            TableItem item = messagesTable.getItem(index);
            Integer id = (Integer)item.getData();
            String name = item.getText(0);
            try {
                message = new MessageTransactions().getMessageById(id);
            }
            catch (Exception e) {
                logger.error("error in getting message with name " + name, (Throwable)e);
                throw new WizardException(e, "error in getting message with name " + name);
            }
        }
        MessageDetailTabItem messageDetailTabItem = (MessageDetailTabItem)this.tabFolder.getItem(0);
        messageDetailTabItem.recoverSavingInformations(message);
        messageDetailTabItem.disableFields();
        MessageEngineTabItem messageEngineTabItem = (MessageEngineTabItem)this.tabFolder.getItem(1);
        messageEngineTabItem.recoverSavingInformations(message);
        messageEngineTabItem.disableFields();
        MessageDataAttributeTabItem messageDataAttributeTabItem = (MessageDataAttributeTabItem)this.tabFolder.getItem(2);
        messageDataAttributeTabItem.disableItems();
        MessageTransactions messageTransactions = new MessageTransactions();
        try {
            if (index == -1) {
                messageTransactions.createNewMessage(message);
                Integer id = message.getMessageId();
                List messageEngines = message.getMessageEngine();
                Iterator iterator = messageEngines.iterator();
                while (iterator.hasNext()) {
                    MessageEngine cfr_ignored_0 = (MessageEngine)iterator.next();
                }
                TableItem tableItem = new TableItem(messagesTable, 0);
                tableItem.setText(0, message.getName());
                tableItem.setText(1, message.getDescription() != null ? message.getDescription() : "");
                tableItem.setData((Object)id);
            } else {
                new MessageTransactions().deleteSbiDomainsByMessageId(Integer.valueOf(message.getMessageId()));
                messageTransactions.mergeMessageNoCache(message);
                TableItem item = messagesTable.getItem(index);
                item.setText(0, message.getName());
                item.setText(1, message.getDescription());
            }
        }
        catch (Exception e1) {
            logger.error("Error in inserting o updating message ", (Throwable)e1);
            throw new WizardException(e1, "Error in inserting or updating message");
        }
        messagesTable.setSelection(-1);
        this.tabFolder.setEnabled(false);
        this.buttonSave.setEnabled(false);
        logger.debug("OUT");
    }

    public Integer getListSelectedMessageId() {
        logger.debug("IN");
        MessagesListComposite listComp = this.getMessageWizardPage().getListComposite();
        int selectedIndex = listComp.getMessagesTable().getSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        TableItem item = listComp.getMessagesTable().getItem(selectedIndex);
        if (item == null) {
            return null;
        }
        Object o = item.getData();
        if (o == null) {
            return null;
        }
        Integer id = (Integer)o;
        logger.debug("OUT");
        return id;
    }

    public MessageWizardPage getMessageWizardPage() {
        return this.messageWizardPage;
    }

    public void setMessageWizardPage(MessageWizardPage messageWizardPage) {
        this.messageWizardPage = messageWizardPage;
    }

    public MessageDetailTabItem getDetailTabItem() {
        return this.detailTabItem;
    }

    public void setDetailTabItem(MessageDetailTabItem detailTabItem) {
        this.detailTabItem = detailTabItem;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public void setButtonSave(Button buttonSave) {
        this.buttonSave = buttonSave;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(Label statusLabel) {
        this.statusLabel = statusLabel;
    }
}

