/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.messagewidgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessageWizardPage;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessagesDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageDataAttributeTabItem;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageEngineTabItem;
import org.eclipse.ebam.emf.DataAttributeTransactions;
import org.eclipse.ebam.emf.MessageTransactions;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesListComposite
extends Composite {
    private MessageWizardPage messageWizardPage = null;
    private Table messagesTable = null;
    public static final int NAME = 0;
    public static final int DESCRIPTION = 1;
    private static Logger logger = LoggerFactory.getLogger(MessagesListComposite.class);

    public MessagesListComposite(Composite parent, int style, MessageWizardPage messageWizardPage1) {
        super(parent, style);
        this.messageWizardPage = messageWizardPage1;
    }

    public void drawComp() {
        logger.debug("in");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        try {
            this.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)this, 0);
            label.setText("Messages List: ");
            label.setForeground(new Color((Device)this.getDisplay(), ColorConstants.titlesColor));
            label.setLayoutData((Object)new GridData(32));
            Label empty = new Label((Composite)this, 0);
            empty.setText("");
            empty.setLayoutData((Object)new GridData(128));
            Button buttonAdd = new Button((Composite)this, 8);
            buttonAdd.setToolTipText("Add an message");
            buttonAdd.setLayoutData((Object)new GridData(32));
            Image addImage = ImageDescriptors.getAddIcon().createImage();
            buttonAdd.setImage(addImage);
            buttonAdd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessagesListComposite.this.addAddButtonPush();
                }
            });
            Button buttonErase = new Button((Composite)this, 8);
            buttonErase.setToolTipText("Erase selected message");
            buttonErase.setLayoutData((Object)new GridData(128));
            Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
            buttonErase.setImage(eraseImage);
            buttonErase.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        MessagesListComposite.this.eraseButtonPush();
                        MessagesDetailComposite messagesDetailComposite = MessagesListComposite.this.getMessageWizardPage().getDetailComposite();
                        messagesDetailComposite.getStatusLabel().setText(MessagesDetailComposite.EMPTY);
                    }
                    catch (WizardException wizardException) {
                        logger.error("database connection exception");
                        MessageDialog.openError((Shell)MessagesListComposite.this.messagesTable.getShell(), (String)"Error", (String)"Error in removing message");
                    }
                }
            });
            List<Message> messagesList = this.retrieveMessages();
            if (messagesList == null) {
                messagesList = new ArrayList<Message>();
            }
            this.messagesTable = new Table((Composite)this, 68100);
            this.messagesTable.setLinesVisible(true);
            this.messagesTable.setHeaderVisible(true);
            GridData g = new GridData(1808);
            g.horizontalSpan = 2;
            this.messagesTable.setLayoutData((Object)g);
            String[] titles = new String[]{"                 Name                 ", "                          Description                        "};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.messagesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            i = 0;
            while (i < messagesList.size()) {
                Message sbiMessage = messagesList.get(i);
                TableItem item = new TableItem(this.messagesTable, 0);
                String nameVal = "";
                if (sbiMessage.getName() != null) {
                    nameVal = sbiMessage.getName();
                }
                item.setText(0, nameVal);
                item.setText(1, sbiMessage.getDescription() != null ? sbiMessage.getDescription() : "");
                item.setData((Object)sbiMessage.getMessageId());
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.messagesTable.getColumn(i).pack();
                ++i;
            }
            this.messagesTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        MessagesListComposite.this.getMessageWizardPage().getDetailComposite().getStatusLabel().setText(MessagesDetailComposite.MODIFYING);
                        MessagesListComposite.this.getMessageWizardPage().getDetailComposite().getStatusLabel().redraw();
                        MessagesListComposite.this.addMessageSelection();
                    }
                    catch (Exception exception) {
                        logger.error("database connectionexception");
                        MessageDialog.openError((Shell)MessagesListComposite.this.messagesTable.getShell(), (String)"Error", (String)"Error in preparing page for selected Message");
                    }
                }
            });
        }
        catch (WizardException wizardException) {
            logger.error("database connection exception");
            MessageDialog.openError((Shell)this.messagesTable.getShell(), (String)"Error", (String)"database connectione exception");
        }
        catch (Exception exception) {
            logger.error("exception in building message wizard");
            MessageDialog.openError((Shell)this.messagesTable.getShell(), (String)"Error", (String)"exception in building message wizard");
        }
        this.messagesTable.redraw();
        logger.debug("OUT");
    }

    private void addMessageSelection() throws Exception {
        logger.debug("IN");
        int indexSelected = this.messagesTable.getSelectionIndex();
        TableItem tableItem = this.messagesTable.getItem(indexSelected);
        Integer id = (Integer)tableItem.getData();
        String name = tableItem.getText(0);
        Message sbiMessage = new MessageTransactions().getMessageById(id);
        if (sbiMessage == null) {
            logger.error("could not find message with name " + name);
            MessageDialog.openError((Shell)this.messagesTable.getShell(), (String)"Error", (String)("could not find message with name " + name));
        }
        logger.debug("fill detail page with selected message " + name);
        MessagesDetailComposite alDetailComposite = this.getMessageWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        MessageDetailTabItem messageDetailTabItem = (MessageDetailTabItem)tabFolder.getItem(0);
        messageDetailTabItem.fillEmptyValues();
        messageDetailTabItem.fillMessageValues(sbiMessage);
        messageDetailTabItem.enableFields(false);
        MessageEngineTabItem messageEngineTabItem = (MessageEngineTabItem)tabFolder.getItem(1);
        messageEngineTabItem.fillEmptyValues();
        messageEngineTabItem.fillMessageEngineValues(sbiMessage);
        messageEngineTabItem.enableFields();
        tabFolder.setSelection(0);
        MessageDataAttributeTabItem messageDataAttributeTabItem = (MessageDataAttributeTabItem)tabFolder.getItem(2);
        messageDataAttributeTabItem.fillEmptyValues();
        messageDataAttributeTabItem.fillDataAttribute(sbiMessage);
        messageDataAttributeTabItem.enableItems();
        this.getMessageWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        logger.debug("OUT");
    }

    private void addAddButtonPush() {
        logger.debug("IN");
        MessagesDetailComposite alDetailComposite = this.getMessageWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        this.messagesTable.setSelection(-1);
        MessageDetailTabItem messageDetailTabItem = (MessageDetailTabItem)tabFolder.getItem(0);
        messageDetailTabItem.fillEmptyValues();
        messageDetailTabItem.enableFields(true);
        MessageEngineTabItem messageEngineTabItem = (MessageEngineTabItem)tabFolder.getItem(1);
        messageEngineTabItem.fillEmptyValues();
        messageEngineTabItem.disableFields();
        MessageDataAttributeTabItem messageDataAttributeTabItem = (MessageDataAttributeTabItem)tabFolder.getItem(2);
        messageDataAttributeTabItem.fillEmptyValues();
        messageDataAttributeTabItem.disableItems();
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        this.getMessageWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        this.getMessageWizardPage().getDetailComposite().getStatusLabel().setText(MessagesDetailComposite.INSERTING);
        this.getMessageWizardPage().getDetailComposite().getStatusLabel().redraw();
    }

    private List<Message> retrieveMessages() throws WizardException {
        List messages = null;
        try {
            messages = new MessageTransactions().getMessageList();
        }
        catch (Exception e) {
            logger.error("error in retrieving messages list", (Throwable)e);
            throw new WizardException(e, "error in retrieving messages list");
        }
        return messages;
    }

    private void eraseButtonPush() throws WizardException {
        logger.debug("IN");
        int indexSelected = this.messagesTable.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = this.messagesTable.getItem(indexSelected);
            Integer id = (Integer)tableItem.getData();
            tableItem.getText(0);
            Message sbiMessage = null;
            try {
                boolean yes = MessageDialog.openConfirm((Shell)this.messagesTable.getShell(), (String)"Delete selected message?", (String)"By erasing the selected message also its engine relationships and data attribute will be deleted: wish to continue? ");
                if (!yes) {
                    return;
                }
                new MessageTransactions().deleteSbiDomainsByMessageId(id);
                new DataAttributeTransactions().deleteDataAttributesByMessageId(id);
                sbiMessage = new MessageTransactions().getMessageById(id);
                new MessageTransactions().deleteMessage(sbiMessage);
            }
            catch (Exception e) {
                logger.error("Error in erasing message", (Throwable)e);
                throw new WizardException(e, "Error in erasing message");
            }
            this.messagesTable.remove(indexSelected);
            this.messagesTable.setSelection(-1);
            MessagesDetailComposite alDetailComposite = this.getMessageWizardPage().getDetailComposite();
            CTabFolder tabFolder = alDetailComposite.getTabFolder();
            MessageDetailTabItem messageDetailTabItem = (MessageDetailTabItem)tabFolder.getItem(0);
            messageDetailTabItem.fillEmptyValues();
            messageDetailTabItem.disableFields();
            MessageEngineTabItem messageEngineTabItem = (MessageEngineTabItem)tabFolder.getItem(1);
            messageEngineTabItem.fillEmptyValues();
            messageEngineTabItem.disableFields();
            MessageDataAttributeTabItem messageDataAttributeTabItem = (MessageDataAttributeTabItem)tabFolder.getItem(2);
            messageDataAttributeTabItem.fillEmptyValues();
            messageDataAttributeTabItem.disableItems();
            tabFolder.setSelection(0);
            tabFolder.setEnabled(false);
            this.messagesTable.redraw();
        }
        this.getMessageWizardPage().getDetailComposite().getButtonSave().setEnabled(false);
        logger.debug("OUT");
    }

    public MessageWizardPage getMessageWizardPage() {
        return this.messageWizardPage;
    }

    public void setMessageWizardPage(MessageWizardPage messageWizardPage1) {
        this.messageWizardPage = messageWizardPage1;
    }

    public Table getMessagesTable() {
        return this.messagesTable;
    }

    public void setMessagesTable(Table messagesTable) {
        this.messagesTable = messagesTable;
    }
}

