/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.servicewidgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.servicewidgets.ServiceWizardPage;
import org.eclipse.ebam.designers.wizards.pages.servicewidgets.ServicesDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.servicewidgets.detailtabs.ServiceDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.emf.ServiceTransactions;
import org.eclipse.ebam.model.entities.Service;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesListComposite
extends Composite {
    private ServiceWizardPage serviceWizardPage = null;
    private Table servicesTable = null;
    public static final int NAME = 0;
    private static Logger logger = LoggerFactory.getLogger(ServicesListComposite.class);

    public ServicesListComposite(Composite parent, int style, ServiceWizardPage serviceWizardPage1) {
        super(parent, style);
        this.serviceWizardPage = serviceWizardPage1;
    }

    public void drawComp() {
        logger.debug("in");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        try {
            this.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)this, 0);
            label.setText("Services List: ");
            label.setForeground(new Color((Device)this.getDisplay(), ColorConstants.titlesColor));
            label.setLayoutData((Object)new GridData(32));
            Label empty = new Label((Composite)this, 0);
            empty.setText("");
            empty.setLayoutData((Object)new GridData(128));
            Button buttonAdd = new Button((Composite)this, 8);
            buttonAdd.setToolTipText("Add a service");
            buttonAdd.setLayoutData((Object)new GridData(32));
            Image addImage = ImageDescriptors.getAddIcon().createImage();
            buttonAdd.setImage(addImage);
            buttonAdd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ServicesListComposite.this.addAddButtonPush();
                }
            });
            Button buttonErase = new Button((Composite)this, 8);
            buttonErase.setToolTipText("Erase selected service");
            buttonErase.setLayoutData((Object)new GridData(128));
            Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
            buttonErase.setImage(eraseImage);
            buttonErase.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ServicesListComposite.this.eraseButtonPush();
                        ServicesDetailComposite servicesDetailComposite = ServicesListComposite.this.getServiceWizardPage().getDetailComposite();
                        servicesDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                    }
                    catch (WizardException e) {
                        logger.error("database connection exception");
                        MessageDialog.openError((Shell)ServicesListComposite.this.servicesTable.getShell(), (String)"Error", (String)e.getMyMessage());
                    }
                }
            });
            List<Service> servicesList = this.retrieveServices();
            if (servicesList == null) {
                servicesList = new ArrayList<Service>();
            }
            this.servicesTable = new Table((Composite)this, 68100);
            this.servicesTable.setLinesVisible(true);
            this.servicesTable.setHeaderVisible(true);
            GridData g = new GridData(1808);
            g.horizontalSpan = 2;
            this.servicesTable.setLayoutData((Object)g);
            String[] titles = new String[]{"                 Name                 "};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.servicesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            i = 0;
            while (i < servicesList.size()) {
                Service service = servicesList.get(i);
                TableItem item = new TableItem(this.servicesTable, 0);
                String nameVal = service.getName() != null ? service.getName() : "";
                item.setData((Object)service.getIdService());
                item.setText(0, nameVal);
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.servicesTable.getColumn(i).pack();
                ++i;
            }
            this.servicesTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ServicesListComposite.this.getServiceWizardPage().getDetailComposite().getStatusLabel().setText(ServicesDetailComposite.MODIFYING);
                        ServicesListComposite.this.getServiceWizardPage().getDetailComposite().getStatusLabel().redraw();
                        ServicesListComposite.this.addServiceSelection();
                    }
                    catch (Exception exception) {
                        logger.error("database connectionexception");
                        MessageDialog.openError((Shell)ServicesListComposite.this.servicesTable.getShell(), (String)"Error", (String)"Error in preparing page for selected service");
                    }
                }
            });
        }
        catch (WizardException dbc) {
            logger.error("database connection exception");
            MessageDialog.openError((Shell)this.servicesTable.getShell(), (String)"Error", (String)("database connectione exception " + dbc.getMessage()));
        }
        catch (Exception dbc) {
            logger.error("exception in building alarm wizard");
            MessageDialog.openError((Shell)this.servicesTable.getShell(), (String)"Error", (String)("Exception in building alarm wizard " + dbc.getMessage()));
        }
        this.servicesTable.redraw();
        logger.debug("OUT");
    }

    private void addServiceSelection() throws Exception {
        logger.debug("IN");
        int indexSelected = this.servicesTable.getSelectionIndex();
        TableItem tableItem = this.servicesTable.getItem(indexSelected);
        Integer id = (Integer)tableItem.getData();
        Service service = new ServiceTransactions().getServiceById(id);
        if (service == null) {
            logger.error("could not find service with id " + id + " and name " + tableItem.getText(0));
            MessageDialog.openError((Shell)this.servicesTable.getShell(), (String)"Error", (String)("could not find service with id " + id + " and name " + tableItem.getText(0)));
            return;
        }
        logger.debug("fill detail page with selected service " + service);
        ServicesDetailComposite alDetailComposite = this.getServiceWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        ServiceDetailTabItem serviceDetailTabItem = (ServiceDetailTabItem)tabFolder.getItem(0);
        serviceDetailTabItem.fillEmptyValues();
        serviceDetailTabItem.fillServiceValues(service);
        serviceDetailTabItem.enableFields(false);
        tabFolder.setEnabled(true);
        this.getServiceWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        tabFolder.setSelection(0);
        logger.debug("OUT");
    }

    private void addAddButtonPush() {
        logger.debug("IN");
        ServicesDetailComposite alDetailComposite = this.getServiceWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        this.servicesTable.setSelection(-1);
        ServiceDetailTabItem serviceDetailTabItem = (ServiceDetailTabItem)tabFolder.getItem(0);
        serviceDetailTabItem.fillEmptyValues();
        serviceDetailTabItem.enableFields(true);
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        this.getServiceWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        this.getServiceWizardPage().getDetailComposite().getStatusLabel().setText(ServicesDetailComposite.INSERTING);
        this.getServiceWizardPage().getDetailComposite().getStatusLabel().redraw();
    }

    private List<Service> retrieveServices() throws WizardException {
        List services = null;
        try {
            services = new ServiceTransactions().getServiceList();
        }
        catch (Exception e) {
            logger.error("error in retrieving service list", (Throwable)e);
            throw new WizardException(e, "Error in retrieving alarms list");
        }
        return services;
    }

    private void eraseButtonPush() throws WizardException {
        logger.debug("IN");
        int indexSelected = this.servicesTable.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = this.servicesTable.getItem(indexSelected);
            Integer id = (Integer)tableItem.getData();
            Service service = null;
            try {
                service = new ServiceTransactions().getServiceById(id);
                new ServiceTransactions().deleteService(service);
            }
            catch (Exception e) {
                logger.error("error in erasing service", (Throwable)e);
                WizardException ex = new WizardException(e, "Error in erasing service; check it is not associated to an existing message.");
                throw ex;
            }
            this.servicesTable.remove(indexSelected);
            this.servicesTable.setSelection(-1);
            ServicesDetailComposite alDetailComposite = this.getServiceWizardPage().getDetailComposite();
            CTabFolder tabFolder = alDetailComposite.getTabFolder();
            ServiceDetailTabItem serviceDetailTabItem = (ServiceDetailTabItem)tabFolder.getItem(0);
            serviceDetailTabItem.fillEmptyValues();
            serviceDetailTabItem.disableFields();
            tabFolder.setSelection(0);
            tabFolder.setEnabled(false);
            this.servicesTable.redraw();
        }
        this.getServiceWizardPage().getDetailComposite().getButtonSave().setEnabled(false);
        logger.debug("OUT");
    }

    public ServiceWizardPage getServiceWizardPage() {
        return this.serviceWizardPage;
    }

    public void setServiceWizardPage(ServiceWizardPage serviceWizardPage1) {
        this.serviceWizardPage = serviceWizardPage1;
    }

    public Table getServicesTable() {
        return this.servicesTable;
    }

    public void setAlarmsTable(Table servicesTable) {
        this.servicesTable = servicesTable;
    }
}

