/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.ui.ChangeActivityHandleOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskMigrationEvent;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TaskMigrator {
    private static boolean active;
    private final ITask oldTask;
    private boolean delete;
    private boolean openEditors;
    private TaskEditor editor;

    public TaskMigrator(ITask oldTask) {
        this.oldTask = oldTask;
        this.openEditors = true;
    }

    public boolean openEditors() {
        return this.openEditors;
    }

    public void setOpenEditors(boolean openEditors) {
        this.openEditors = openEditors;
    }

    public boolean delete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void execute(ITask newTask) {
        this.copyProperties(newTask);
        final AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(newTask.getConnectorKind());
        if (connector != null) {
            final TaskMigrationEvent event = new TaskMigrationEvent(this.oldTask, newTask);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error in task migrator: " + connector.getClass(), e));
                }

                public void run() throws Exception {
                    connector.migrateTask(event);
                }
            });
        }
        try {
            active = true;
            boolean reactivate = this.oldTask.isActive();
            if (reactivate) {
                TasksUi.getTaskActivityManager().deactivateTask(this.oldTask);
            }
            boolean editorIsActive = this.closeEditor();
            this.deleteOldTask();
            if (reactivate) {
                TasksUi.getTaskActivityManager().activateTask(newTask);
            }
            if (this.openEditors()) {
                if (editorIsActive) {
                    TasksUiUtil.openTask(newTask);
                } else {
                    TasksUiInternal.openTaskInBackground(newTask, false);
                }
            }
        }
        finally {
            active = false;
        }
    }

    public void setEditor(TaskEditor editor) {
        this.editor = editor;
    }

    public TaskEditor getEditor() {
        return this.editor;
    }

    private boolean closeEditor() {
        boolean editorIsActive = false;
        if (this.editor != null) {
            IWorkbenchPage activePage;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (activePage = window.getActivePage()) != null && activePage.getActiveEditor() == this.editor) {
                editorIsActive = true;
            }
            this.editor.close(false);
        }
        return editorIsActive;
    }

    private void deleteOldTask() {
        if (this.delete()) {
            TasksUiInternal.getTaskList().deleteTask(this.oldTask);
            ContextCore.getContextManager().deleteContext(this.oldTask.getHandleIdentifier());
            try {
                TasksUiPlugin.getTaskDataManager().deleteTaskData(this.oldTask);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
            }
        }
    }

    private void copyProperties(ITask newTask) {
        if (this.oldTask instanceof AbstractTask && newTask instanceof AbstractTask) {
            ((AbstractTask)newTask).setNotes(((AbstractTask)this.oldTask).getNotes());
            DateRange scheduledDate = ((AbstractTask)this.oldTask).getScheduledForDate();
            TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)newTask, scheduledDate);
            Date dueDate = ((AbstractTask)this.oldTask).getDueDate();
            TasksUiPlugin.getTaskActivityManager().setDueDate(newTask, dueDate);
            ((AbstractTask)newTask).setEstimatedTimeHours(((AbstractTask)this.oldTask).getEstimatedTimeHours());
        }
        ContextCorePlugin.getContextStore().saveActiveContext();
        ContextCore.getContextStore().cloneContext(this.oldTask.getHandleIdentifier(), newTask.getHandleIdentifier());
        ChangeActivityHandleOperation operation = new ChangeActivityHandleOperation(this.oldTask.getHandleIdentifier(), newTask.getHandleIdentifier());
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Failed to migrate activity to new task", e.getCause()));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static boolean isActive() {
        return active;
    }
}

