/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenEvent;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;

public final class TaskHyperlink
implements IHyperlink {
    private final IRegion region;
    private final TaskRepository repository;
    private final String taskId;
    private Object selection;

    public TaskHyperlink(IRegion region, TaskRepository repository, String taskId) {
        this.region = region;
        this.repository = repository;
        this.taskId = taskId;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTypeLabel() {
        return null;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public String getHyperlinkText() {
        return MessageFormat.format(Messages.TaskHyperlink_Open_Task_X_in_X, this.taskId, this.repository.getRepositoryLabel());
    }

    public void open() {
        if (this.repository != null) {
            TasksUiInternal.openTask(this.repository, this.taskId, new TaskOpenListener(){

                public void taskOpened(TaskOpenEvent event) {
                    if (TaskHyperlink.this.selection == null) {
                        return;
                    }
                    if (event.getEditor() instanceof TaskEditor) {
                        TaskEditor editor = (TaskEditor)event.getEditor();
                        editor.selectReveal(TaskHyperlink.this.selection);
                    }
                }
            });
        } else {
            MessageDialog.openError(null, (String)"Mylyn", (String)Messages.TaskHyperlink_Could_not_determine_repository_for_report);
        }
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setSelection(Object selection) {
        this.selection = selection;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        result = 31 * result + (this.selection == null ? 0 : this.selection.hashCode());
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskHyperlink other = (TaskHyperlink)obj;
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.repository == null ? other.repository != null : !this.repository.equals((Object)other.repository)) {
            return false;
        }
        if (this.selection == null ? other.selection != null : !this.selection.equals(other.selection)) {
            return false;
        }
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    public String toString() {
        return "TaskHyperlink [region=" + this.region + ", repository=" + this.repository + ", selection=" + this.selection + ", taskId=" + this.taskId + "]";
    }
}

