/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Time;
import java.util.Date;

public abstract class DataType {
    public static final int UNKNOWN_TYPE = -1;
    public static final int ANY_TYPE = 0;
    public static final int BOOLEAN_TYPE = 1;
    public static final int INTEGER_TYPE = 2;
    public static final int DOUBLE_TYPE = 3;
    public static final int DECIMAL_TYPE = 4;
    public static final int STRING_TYPE = 5;
    public static final int DATE_TYPE = 6;
    public static final int BLOB_TYPE = 7;
    public static final int BINARY_TYPE = 8;
    public static final int SQL_DATE_TYPE = 9;
    public static final int SQL_TIME_TYPE = 10;
    public static final int JAVA_OBJECT_TYPE = 11;
    private static final String[] names = new String[]{"Any", "Boolean", "Integer", "Float", "Decimal", "String", "DateTime", "Blob", "Binary", "Date", "Time", "Java Object"};
    public static final String ANY_TYPE_NAME = names[0];
    public static final String BOOLEAN_TYPE_NAME = names[1];
    public static final String INTEGER_TYPE_NAME = names[2];
    public static final String DOUBLE_TYPE_NAME = names[3];
    public static final String DECIMAL_TYPE_NAME = names[4];
    public static final String STRING_TYPE_NAME = names[5];
    public static final String DATE_TYPE_NAME = names[6];
    public static final String BLOB_TYPE_NAME = names[7];
    public static final String BINARY_TYPE_NAME = names[8];
    public static final String SQL_DATE_TYPE_NAME = names[9];
    public static final String SQL_TIME_TYPE_NAME = names[10];
    public static final String OBJECT_TYPE_NAME = names[11];
    private static final Class[] classes = new Class[]{AnyType.class, Boolean.class, Integer.class, Double.class, BigDecimal.class, String.class, Date.class, Blob.class, byte[].class, java.sql.Date.class, Time.class, Object.class};

    public static String getName(int typeCode) {
        if (typeCode < 0 || typeCode >= names.length) {
            return new String("Unknown");
        }
        return names[typeCode];
    }

    public static Class getClass(int typeCode) {
        if (typeCode < 0 || typeCode >= classes.length) {
            return null;
        }
        return classes[typeCode];
    }

    public static boolean isValidDataType(Class objClass) {
        int i = 0;
        while (i < classes.length) {
            if (classes[i].equals(objClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final class AnyType {
    }
}

