/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.script.internal.OnPageBreakScriptVisitor;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class OnPageBreakLayoutPageHandle
implements ILayoutPageHandler {
    protected ExecutionContext executionContext;
    protected IContentEmitter emitter;
    protected PageContent pageContent;
    protected boolean bufferAllContents;
    protected ArrayList<IContent> contents;

    public OnPageBreakLayoutPageHandle(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.emitter = new PageContentBuilder();
        this.contents = new ArrayList();
    }

    public IContentEmitter getEmitter() {
        return this.emitter;
    }

    private void initPageBuffer(PageContent pageContent) {
        MasterPageDesign pageDesign = (MasterPageDesign)pageContent.getGenerateBy();
        Report report = pageContent.getReportContent().getDesign();
        this.bufferAllContents = pageDesign.getOnPageStart() != null || pageDesign.getOnPageEnd() != null || report.getOnPageStart() != null || report.getOnPageEnd() != null;
        this.contents.clear();
        this.pageContent = pageContent;
    }

    private ReportItemDesign getGenerateDesign(IContent content) {
        Object design = content.getGenerateBy();
        if (design instanceof ReportItemDesign) {
            return (ReportItemDesign)design;
        }
        if (design instanceof ReportItemHandle) {
            IReportContent reportContent = content.getReportContent();
            Report reportDesign = reportContent.getDesign();
            return reportDesign.findDesign((ReportElementHandle)((ReportItemHandle)design));
        }
        return null;
    }

    private void addContent(IContent content) {
        if (!this.bufferAllContents) {
            ReportItemDesign design = this.getGenerateDesign(content);
            if (!(design == null || design.getOnPageBreak() == null && design.getJavaClass() == null || this.contents.contains(content))) {
                this.contents.add(content);
            }
        } else if (!this.contents.contains(content)) {
            this.contents.add(content);
        }
    }

    public void onPage(long page, Object context) {
        if (this.executionContext == null || this.pageContent == null) {
            return;
        }
        Report report = this.executionContext.getReport();
        OnPageBreakScriptVisitor onPageBreakVisitor = new OnPageBreakScriptVisitor(this.executionContext);
        Collection<PageVariable> pageVariables = this.executionContext.getPageVariables();
        for (PageVariable pageVar : pageVariables) {
            if (!"page".equals(pageVar.getScope())) continue;
            Object value = pageVar.getDefaultValue();
            pageVar.setValue(value);
        }
        onPageBreakVisitor.onPageStart(report, this.pageContent, this.contents);
        onPageBreakVisitor.onPageStart(this.pageContent, this.contents);
        for (IContent content : this.contents) {
            onPageBreakVisitor.onPageBreak(content);
        }
        onPageBreakVisitor.onPageEnd(this.pageContent, this.contents);
        onPageBreakVisitor.onPageEnd(report, this.pageContent, this.contents);
        this.contents.clear();
        this.pageContent = null;
    }

    private class PageBreakContentCollector
    implements IAreaVisitor {
        private PageBreakContentCollector() {
        }

        public void visitText(ITextArea textArea) {
        }

        public void visitAutoText(ITemplateArea templateArea) {
        }

        public void visitImage(IImageArea imageArea) {
        }

        public void visitContainer(IContainerArea container) {
            IContent content = ((ContainerArea)container).getContent();
            if (content != null) {
                OnPageBreakLayoutPageHandle.this.addContent(content);
            }
            Iterator<IArea> iter = container.getChildren();
            while (iter.hasNext()) {
                IArea child = iter.next();
                child.accept(this);
            }
        }
    }

    private class PageContentBuilder
    extends ContentEmitterAdapter {
        private PageContentBuilder() {
        }

        public void startPage(IPageContent pageContent) throws BirtException {
            OnPageBreakLayoutPageHandle.this.initPageBuffer((PageContent)pageContent);
            IArea pageArea = (IArea)pageContent.getExtension(1);
            if (pageArea != null) {
                pageArea.accept(new PageBreakContentCollector());
            }
        }

        public void startContent(IContent content) throws BirtException {
            OnPageBreakLayoutPageHandle.this.addContent(content);
        }
    }
}

