/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.presentation.Page;

public class PageRegion
extends ContentEmitterAdapter {
    IContentEmitter emitter;

    public PageRegion(Page page) {
        this.emitter = page.getEmitter();
    }

    public void open(IContent content) throws BirtException {
        if (content != null) {
            int size;
            ArrayList contents = this.getAncestors(content);
            int i = size = contents.size() - 1;
            while (i >= 0) {
                IContent parent = (IContent)contents.get(i);
                ContentEmitterUtil.startContent(parent, this.emitter);
                --i;
            }
        }
    }

    public void close(IContent content) throws BirtException {
        if (content != null) {
            ArrayList contents = this.getAncestors(content);
            int size = contents.size();
            int i = 0;
            while (i < size) {
                IContent parent = (IContent)contents.get(i);
                ContentEmitterUtil.endContent(parent, this.emitter);
                ++i;
            }
        }
    }

    private ArrayList getAncestors(IContent content) {
        ArrayList<IContent> list = new ArrayList<IContent>();
        while (content.getParent() != null) {
            list.add(content);
            content = (IContent)content.getParent();
        }
        return list;
    }

    public void end(IReportContent report) throws BirtException {
        this.emitter.end(report);
    }

    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    public void initialize(IEmitterServices service) throws BirtException {
        this.emitter.initialize(service);
    }

    public void start(IReportContent report) throws BirtException {
        this.emitter.start(report);
    }

    public void startContent(IContent content) throws BirtException {
        ContentEmitterUtil.startContent(content, this.emitter);
    }

    public void endContent(IContent content) throws BirtException {
        ContentEmitterUtil.endContent(content, this.emitter);
    }
}

