/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.jaxb.core.internal.ClassesGenerator;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.Bundle;

public class ClassesGeneratorWizardPage
extends NewTypeWizardPage {
    public static String JPT_ECLIPSELINK_UI_PLUGIN_ID = "org.eclipse.jpt.eclipselink.ui";
    public static String XML_FILTER = "*.xml";
    public static String XJB_FILTER = "*.xjb";
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.ui.configure_jaxb_class_generation_dialog";
    private final IJavaProject javaProject;
    private SettingsGroup settingsGroup;
    private String targetFolder;
    private String targetPackage;
    private Button usesMoxyCheckBox;
    private boolean usesMoxy;

    public ClassesGeneratorWizardPage(IJavaProject javaProject, String xmlSchemaName) {
        super(true, "Classes Generator");
        if (javaProject == null) {
            throw new NullPointerException();
        }
        this.javaProject = javaProject;
        this.usesMoxy = this.jptEclipseLinkBundleExists() && this.moxyIsOnClasspath();
        this.setTitle(NLS.bind((String)JptJaxbUiMessages.ClassesGeneratorWizardPage_title, (Object)xmlSchemaName));
        this.setDescription(JptJaxbUiMessages.ClassesGeneratorWizardPage_desc);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
        this.initContainerPage((IJavaElement)this.javaProject);
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_CONTEXT_ID);
        this.settingsGroup = new SettingsGroup(composite);
        if (this.jptEclipseLinkBundleExists() && !this.moxyIsOnClasspath()) {
            this.usesMoxyCheckBox = this.buildUsesMoxyCheckBox(composite);
        }
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Button buildUsesMoxyCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.verticalIndent = 10;
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_usesMoxyImplementation);
        checkBox.setSelection(this.usesMoxy());
        checkBox.addSelectionListener(this.buildUsesMoxySelectionListener());
        return checkBox;
    }

    private SelectionListener buildUsesMoxySelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                ClassesGeneratorWizardPage.this.setUsesMoxy(ClassesGeneratorWizardPage.this.usesMoxyCheckBox.getSelection());
                ClassesGeneratorWizardPage.this.validateProjectClasspath();
            }
        };
    }

    protected String getTargetFolder() {
        return this.targetFolder;
    }

    protected String getTargetPackage() {
        return this.targetPackage;
    }

    protected String getCatalog() {
        return this.settingsGroup.getCatalog();
    }

    protected String[] getBindingsFileNames() {
        return this.settingsGroup.getBindingsFileNames();
    }

    protected boolean usesMoxy() {
        return this.usesMoxy;
    }

    protected void setUsesMoxy(boolean usesMoxy) {
        this.usesMoxy = usesMoxy;
    }

    private boolean jptEclipseLinkBundleExists() {
        return this.getJptEclipseLinkBundle() != null;
    }

    private Bundle getJptEclipseLinkBundle() {
        return Platform.getBundle((String)JPT_ECLIPSELINK_UI_PLUGIN_ID);
    }

    private void validateProjectClasspath() {
        this.setMessage(null);
        if (!this.genericJaxbIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.ClassesGeneratorWizardPage_jaxbLibrariesNotAvailable);
        } else if (this.usesMoxy() && !this.moxyIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.ClassesGeneratorWizardPage_moxyLibrariesNotAvailable);
        }
    }

    private void displayWarning(String message) {
        this.setMessage(message, 2);
    }

    private boolean genericJaxbIsOnClasspath() {
        try {
            String className = ClassesGenerator.JAXB_GENERIC_GEN_CLASS;
            IType genClass = this.javaProject.findType(className);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean moxyIsOnClasspath() {
        try {
            String className = ClassesGenerator.JAXB_ECLIPSELINK_GEN_CLASS;
            IType genClass = this.javaProject.findType(className);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (!status.matches(4)) {
            this.targetPackage = packageFragment.getElementName();
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        String srcFolder = this.getPackageFragmentRootText();
        if (!status.matches(4)) {
            this.targetFolder = srcFolder.substring(srcFolder.indexOf("/") + 1);
        }
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fContainerStatus.matches(4)) {
            this.updateStatus(this.fContainerStatus);
        } else if (!this.fPackageStatus.matches(0)) {
            this.updateStatus(this.fPackageStatus);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
        this.validateProjectClasspath();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.validateProjectClasspath();
    }

    protected IPackageFragmentRoot chooseContainer() {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JptJaxbUiPlugin.log(e);
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JptJaxbUiPlugin.log(e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.javaProject);
        dialog.setInitialSelection((Object)this.getPackageFragmentRoot());
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SettingsGroup {
        private final Text catalogText;
        private final ArrayList<String> bindingsFileNames;

        private SettingsGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            ClassesGeneratorWizardPage.this.createContainerControls(composite, 4);
            ClassesGeneratorWizardPage.this.createPackageControls(composite, 4);
            Label label = new Label(composite, 258);
            GridData gridData = new GridData(4, 1, true, false, 4, 1);
            gridData.verticalIndent = 5;
            label.setLayoutData((Object)gridData);
            Label catalogLabel = new Label(composite, 0);
            catalogLabel.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_catalog);
            gridData = new GridData();
            gridData.verticalIndent = 5;
            catalogLabel.setLayoutData((Object)gridData);
            this.catalogText = this.buildCatalogText(composite);
            this.buildBrowseButton(composite);
            this.bindingsFileNames = new ArrayList();
            Label bindingsFileLabel = new Label(composite, 0);
            bindingsFileLabel.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_bindingsFiles);
            bindingsFileLabel.setLayoutData((Object)new GridData());
            this.buildBindingsFileTable(composite);
        }

        protected String getCatalog() {
            return this.catalogText.getText();
        }

        protected String[] getBindingsFileNames() {
            return (String[])ArrayTools.array(this.bindingsFileNames.iterator(), (Object[])new String[0]);
        }

        private Text buildCatalogText(Composite parent) {
            Text text = new Text(parent, 2048);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.verticalIndent = 5;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private void buildBrowseButton(Composite parent) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button browseButton = new Button(buttonComposite, 8);
            browseButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_browseButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalIndent = 5;
            gridData.grabExcessHorizontalSpace = true;
            browseButton.setLayoutData((Object)gridData);
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String filePath = SettingsGroup.this.promptFile(XML_FILTER);
                    if (!StringTools.stringIsEmpty((String)filePath)) {
                        SettingsGroup.this.catalogText.setText(SettingsGroup.this.makeRelativeToProjectPath(filePath));
                    }
                }
            });
        }

        private TableViewer buildBindingsFileTable(Composite parent) {
            TableViewer tableViewer = this.buildTableViewer(parent, this.bindingsFileNames);
            this.buildAddRemoveButtons(parent, tableViewer, this.bindingsFileNames);
            return tableViewer;
        }

        private TableViewer buildTableViewer(Composite parent, ArrayList<String> tableDataModel) {
            TableLayoutComposite tableLayout = new TableLayoutComposite(parent, 0);
            this.addColumnsData(tableLayout);
            Table table = new Table((Composite)tableLayout, 68356);
            table.setLinesVisible(false);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setResizable(true);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)3);
            tableLayout.setLayoutData((Object)gridData);
            TableViewer tableViewer = new TableViewer(table);
            tableViewer.setUseHashlookup(true);
            tableViewer.setLabelProvider(this.buildLabelProvider());
            tableViewer.setContentProvider(this.buildContentProvider());
            tableViewer.setInput(tableDataModel);
            return tableViewer;
        }

        private void buildAddRemoveButtons(Composite parent, final TableViewer tableViewer, final ArrayList<String> tableDataModel) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button addButton = new Button(buttonComposite, 8);
            addButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_addButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            addButton.setLayoutData((Object)gridData);
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String filePath = SettingsGroup.this.promptFile(XJB_FILTER);
                    if (!StringTools.stringIsEmpty((String)filePath)) {
                        SettingsGroup.this.addBindingsFile(filePath, tableDataModel);
                        tableViewer.refresh();
                    }
                }
            });
            Button removeButton = new Button(buttonComposite, 8);
            removeButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_removeButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            removeButton.setLayoutData((Object)gridData);
            removeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSelection selection = (StructuredSelection)tableViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    String bindingsFileName = (String)selection.getFirstElement();
                    SettingsGroup.this.removeBindingsFile(bindingsFileName);
                    tableViewer.refresh();
                }
            });
            addButton.setFocus();
        }

        private String makeRelativeToProjectPath(String filePath) {
            Path path = new Path(filePath);
            IPath relativePath = path.makeRelativeTo(ClassesGeneratorWizardPage.this.javaProject.getProject().getLocation());
            return relativePath.toOSString();
        }

        private void addBindingsFile(String filePath, ArrayList<String> tableDataModel) {
            String relativePath = this.makeRelativeToProjectPath(filePath);
            if (!tableDataModel.contains(relativePath)) {
                tableDataModel.add(relativePath);
            }
        }

        private void removeBindingsFile(String bindingsName) {
            this.bindingsFileNames.remove(bindingsName);
        }

        private IBaseLabelProvider buildLabelProvider() {
            return new TableLabelProvider();
        }

        private IContentProvider buildContentProvider() {
            return new TableContentProvider();
        }

        private String promptFile(String filter) {
            String projectPath = ClassesGeneratorWizardPage.this.javaProject.getProject().getLocation().toString();
            String dialogTitle = filter.equals(XJB_FILTER) ? JptJaxbUiMessages.ClassesGeneratorWizardPage_chooseABindingsFile : JptJaxbUiMessages.ClassesGeneratorWizardPage_chooseACatalog;
            FileDialog dialog = new FileDialog(ClassesGeneratorWizardPage.this.getShell());
            dialog.setText(dialogTitle);
            dialog.setFilterPath(projectPath);
            dialog.setFilterExtensions(new String[]{filter});
            String filePath = dialog.open();
            return filePath != null ? filePath : null;
        }

        private void addColumnsData(TableLayoutComposite layout) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }
    }
}

