/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataState
implements ITaskDataWorkingCopy {
    private final String connectorKind;
    private TaskData editsTaskData;
    private TaskData lastReadTaskData;
    private TaskData localTaskData;
    private boolean saved;
    private TaskData repositoryTaskData;
    private final String repositoryUrl;
    private ITask task;
    private final String taskId;
    private TaskDataManager taskDataManager;

    public TaskDataState(String connectorKind, String repositoryUrl, String taskId) {
        Assert.isNotNull((Object)connectorKind);
        Assert.isNotNull((Object)repositoryUrl);
        Assert.isNotNull((Object)taskId);
        this.connectorKind = connectorKind;
        this.repositoryUrl = repositoryUrl;
        this.taskId = taskId;
        this.saved = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskDataState other = (TaskDataState)obj;
        return this.connectorKind.equals(other.connectorKind) && this.repositoryUrl.equals(other.repositoryUrl) && this.taskId.equals(other.taskId);
    }

    @Override
    public String getConnectorKind() {
        return this.connectorKind;
    }

    @Override
    public TaskData getEditsData() {
        return this.editsTaskData;
    }

    @Override
    public TaskData getLastReadData() {
        return this.lastReadTaskData;
    }

    @Override
    public TaskData getLocalData() {
        return this.localTaskData;
    }

    @Override
    public TaskData getRepositoryData() {
        return this.repositoryTaskData;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.connectorKind.hashCode();
        result = 31 * result + this.taskId.hashCode();
        result = 31 * result + this.repositoryUrl.hashCode();
        return result;
    }

    void init(TaskDataManager taskSynchronizationManager, ITask task) {
        this.taskDataManager = taskSynchronizationManager;
        this.task = task;
    }

    @Override
    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws CoreException {
        ITaskDataWorkingCopy state = this.taskDataManager.getWorkingCopy(this.task);
        this.setRepositoryData(state.getRepositoryData());
        this.setEditsData(state.getEditsData());
        this.setLastReadData(state.getLastReadData());
        this.revert();
    }

    @Override
    public void revert() {
        this.localTaskData = new TaskData(this.repositoryTaskData.getAttributeMapper(), this.repositoryTaskData.getConnectorKind(), this.repositoryTaskData.getRepositoryUrl(), this.repositoryTaskData.getTaskId());
        this.localTaskData.setVersion(this.repositoryTaskData.getVersion());
        this.deepCopyChildren(this.repositoryTaskData.getRoot(), this.localTaskData.getRoot());
        if (this.editsTaskData != null) {
            this.deepCopyChildren(this.editsTaskData.getRoot(), this.localTaskData.getRoot());
        } else {
            this.editsTaskData = new TaskData(this.repositoryTaskData.getAttributeMapper(), this.repositoryTaskData.getConnectorKind(), this.repositoryTaskData.getRepositoryUrl(), this.repositoryTaskData.getTaskId());
            this.editsTaskData.setVersion(this.repositoryTaskData.getVersion());
        }
    }

    private void deepCopyChildren(TaskAttribute source, TaskAttribute target) {
        for (TaskAttribute child : source.getAttributes().values()) {
            target.deepAddCopy(child);
        }
    }

    @Override
    public void save(Set<TaskAttribute> edits, IProgressMonitor monitor) throws CoreException {
        if (edits != null) {
            for (TaskAttribute edit : edits) {
                this.editsTaskData.getRoot().deepAddCopy(edit);
            }
        }
        if (this.saved) {
            this.taskDataManager.putEdits(this.task, this.editsTaskData);
        } else {
            this.taskDataManager.saveWorkingCopy(this.task, this);
            this.setSaved(true);
        }
    }

    public void setEditsData(TaskData editsTaskData) {
        this.editsTaskData = editsTaskData;
    }

    public void setLastReadData(TaskData oldTaskData) {
        this.lastReadTaskData = oldTaskData;
    }

    public void setLocalTaskData(TaskData localTaskData) {
        this.localTaskData = localTaskData;
    }

    void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void setRepositoryData(TaskData newTaskData) {
        this.repositoryTaskData = newTaskData;
    }

    public void merge(TaskDataState oldState) {
        this.setEditsData(this.createCopy(oldState.getEditsData()));
        this.setLocalTaskData(this.createCopy(oldState.getLocalData()));
        this.setRepositoryData(this.createCopy(oldState.getRepositoryData()));
    }

    private TaskData createCopy(TaskData oldData) {
        if (oldData == null) {
            return null;
        }
        TaskData newData = new TaskData(oldData.getAttributeMapper(), this.getConnectorKind(), this.getRepositoryUrl(), this.getTaskId());
        newData.setVersion(oldData.getVersion());
        for (TaskAttribute child : oldData.getRoot().getAttributes().values()) {
            newData.getRoot().deepAddCopy(child);
        }
        return newData;
    }
}

