/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.console;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConsolePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor commandColorEditor;
    private ColorFieldEditor messageColorEditor;
    private ColorFieldEditor errorColorEditor;
    private BooleanFieldEditor showOnMessage;
    private BooleanFieldEditor restrictOutput;
    private BooleanFieldEditor wrap;
    private IntegerFieldEditor highWaterMark;
    private IntegerFieldEditor width;

    public ConsolePreferencesPage() {
        super(1);
        this.setPreferenceStore(CVSUIPlugin.getPlugin().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.createLabel(composite, CVSUIMessages.ConsolePreferencesPage_9);
        IPreferenceStore store = this.getPreferenceStore();
        this.wrap = new BooleanFieldEditor("pref_console_wrap", CVSUIMessages.ConsolePreferencesPage_6, composite);
        this.addField((FieldEditor)this.wrap);
        this.width = new IntegerFieldEditor("pref_console_width", CVSUIMessages.ConsolePreferencesPage_7, composite);
        this.width.setValidRange(80, 0x7FFFFFFE);
        this.addField((FieldEditor)this.width);
        this.width.setEnabled(store.getBoolean("pref_console_wrap"), composite);
        this.restrictOutput = new BooleanFieldEditor("pref_console_limit_output", CVSUIMessages.ConsolePreferencesPage_5, composite);
        this.addField((FieldEditor)this.restrictOutput);
        this.highWaterMark = new IntegerFieldEditor("pref_console_high_water_mark", CVSUIMessages.ConsolePreferencesPage_8, composite);
        this.highWaterMark.setValidRange(1000, 0x7FFFFFFE);
        this.addField((FieldEditor)this.highWaterMark);
        this.highWaterMark.setEnabled(store.getBoolean("pref_console_limit_output"), composite);
        this.showOnMessage = new BooleanFieldEditor("pref_console_show_on_message", CVSUIMessages.ConsolePreferencesPage_4, composite);
        this.addField((FieldEditor)this.showOnMessage);
        this.createLabel(composite, CVSUIMessages.ConsolePreferencePage_consoleColorSettings);
        this.commandColorEditor = this.createColorFieldEditor("pref_console_command_color", CVSUIMessages.ConsolePreferencePage_commandColor, composite);
        this.addField((FieldEditor)this.commandColorEditor);
        this.messageColorEditor = this.createColorFieldEditor("pref_console_message_color", CVSUIMessages.ConsolePreferencePage_messageColor, composite);
        this.addField((FieldEditor)this.messageColorEditor);
        this.errorColorEditor = this.createColorFieldEditor("pref_console_error_color", CVSUIMessages.ConsolePreferencePage_errorColor, composite);
        this.addField((FieldEditor)this.errorColorEditor);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.console_preference_page_context");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.highWaterMark.setEnabled(this.restrictOutput.getBooleanValue(), this.getFieldEditorParent());
        this.width.setEnabled(this.wrap.getBooleanValue(), this.getFieldEditorParent());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPreferencePage((PreferencePage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }
}

