/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterables.ListListIterable;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListIterable<E1, E2>
implements ListIterable<E2> {
    private final ListIterable<? extends E1> iterable;
    private final Transformer<E1, ? extends E2> transformer;

    public TransformationListIterable(List<E1> list) {
        this(new ListListIterable<E1>(list));
    }

    public TransformationListIterable(ListIterable<? extends E1> iterable) {
        this.iterable = iterable;
        this.transformer = this.buildDefaultTransformer();
    }

    public TransformationListIterable(List<E1> list, Transformer<E1, ? extends E2> transformer) {
        this(new ListListIterable<E1>(list), transformer);
    }

    public TransformationListIterable(ListIterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        this.iterable = iterable;
        this.transformer = transformer;
    }

    protected Transformer<E1, ? extends E2> buildDefaultTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public ListIterator<E2> iterator() {
        return new TransformationListIterator<E1, E2>(this.iterable.iterator(), this.transformer);
    }

    protected E2 transform(E1 o) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultTransformer
    implements Transformer<E1, E2> {
        protected DefaultTransformer() {
        }

        @Override
        public E2 transform(E1 o) {
            return TransformationListIterable.this.transform(o);
        }
    }
}

