/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTreeListValueModelAdapter<E>
extends ItemAspectListValueModelAdapter<E> {
    protected final String[] treeNames;
    protected final TreeChangeListener itemTreeListener;

    public ItemTreeListValueModelAdapter(ListValueModel<E> listHolder, String ... treeNames) {
        super(listHolder);
        this.treeNames = treeNames;
        this.itemTreeListener = this.buildItemTreeListener();
    }

    public ItemTreeListValueModelAdapter(CollectionValueModel<E> collectionHolder, String ... treeNames) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder), treeNames);
    }

    protected TreeChangeListener buildItemTreeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeAddEvent event) {
                ItemTreeListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void nodeRemoved(TreeRemoveEvent event) {
                ItemTreeListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void treeCleared(TreeClearEvent event) {
                ItemTreeListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void treeChanged(TreeChangeEvent event) {
                ItemTreeListValueModelAdapter.this.itemAspectChanged(event);
            }

            public String toString() {
                return "item tree listener: " + Arrays.asList(ItemTreeListValueModelAdapter.this.treeNames);
            }
        };
    }

    @Override
    protected void engageItem_(Model item) {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            item.addTreeChangeListener(treeName, this.itemTreeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageItem_(Model item) {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            item.removeTreeChangeListener(treeName, this.itemTreeListener);
            ++n2;
        }
    }
}

