/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfProtection;
import com.lowagie.text.rtf.style.RtfParagraphStyle;

public class RtfDocumentSettings {
    private RtfDocument document = null;
    private boolean outputTableRowDefinitionAfter = true;
    private boolean outputDebugLineBreaks = false;
    private boolean alwaysGenerateSoftLinebreaks = false;
    private boolean alwaysUseUnicode = true;
    private int dataCacheStyle = 2;
    private boolean writeImageScalingInformation = false;
    private boolean imagePDFConformance = true;
    private int protectionLevel = 0;
    private String protectionHash = null;
    private String writereservhash = null;
    private boolean readOnlyRecommended = false;
    private boolean imageWrittenAsBinary = true;

    public RtfDocumentSettings(RtfDocument rtfDocument) {
        this.document = rtfDocument;
    }

    public boolean isOutputDebugLineBreaks() {
        return this.outputDebugLineBreaks;
    }

    public void setOutputDebugLineBreaks(boolean bl) {
        this.outputDebugLineBreaks = bl;
    }

    public boolean isOutputTableRowDefinitionAfter() {
        return this.outputTableRowDefinitionAfter;
    }

    public void setOutputTableRowDefinitionAfter(boolean bl) {
        this.outputTableRowDefinitionAfter = bl;
    }

    public boolean isAlwaysGenerateSoftLinebreaks() {
        return this.alwaysGenerateSoftLinebreaks;
    }

    public void setAlwaysGenerateSoftLinebreaks(boolean bl) {
        this.alwaysGenerateSoftLinebreaks = bl;
    }

    public boolean isAlwaysUseUnicode() {
        return this.alwaysUseUnicode;
    }

    public void setAlwaysUseUnicode(boolean bl) {
        this.alwaysUseUnicode = bl;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.document.getDocumentHeader().registerParagraphStyle(rtfParagraphStyle);
    }

    public void setDataCacheStyle(int n) {
        switch (n) {
            case 3: {
                this.dataCacheStyle = 3;
                break;
            }
            case 1: {
                this.dataCacheStyle = 1;
                break;
            }
            default: {
                this.dataCacheStyle = 2;
            }
        }
    }

    public int getDataCacheStyle() {
        return this.dataCacheStyle;
    }

    public boolean isImagePDFConformance() {
        return this.imagePDFConformance;
    }

    public void setImagePDFConformance(boolean bl) {
        this.imagePDFConformance = bl;
    }

    public boolean isWriteImageScalingInformation() {
        return this.writeImageScalingInformation;
    }

    public void setWriteImageScalingInformation(boolean bl) {
        this.writeImageScalingInformation = bl;
    }

    public void setOptionsForMSWord2000And97() {
        this.setOutputTableRowDefinitionAfter(true);
        this.setWriteImageScalingInformation(true);
    }

    public void setOptionsForMSWordForMac() {
        this.setWriteImageScalingInformation(true);
    }

    public void setOptionsForMSWordXP() {
        this.setWriteImageScalingInformation(false);
    }

    public void setOptionsForOpenOfficeOrg() {
        this.setOutputTableRowDefinitionAfter(false);
    }

    public boolean setProtection(int n, String string) {
        boolean bl = false;
        if (this.protectionHash == null) {
            if (!this.setProtectionLevel(n)) {
                bl = false;
            } else {
                this.protectionHash = RtfProtection.generateHash(string);
                bl = true;
            }
        } else if (this.protectionHash.equals(RtfProtection.generateHash(string))) {
            if (!this.setProtectionLevel(n)) {
                bl = false;
            } else {
                this.protectionHash = RtfProtection.generateHash(string);
                bl = true;
            }
        }
        return bl;
    }

    public boolean unprotectDocument(String string) {
        boolean bl = false;
        if (this.protectionHash.equals(RtfProtection.generateHash(string))) {
            this.protectionLevel = 0;
            this.protectionHash = null;
            bl = true;
        }
        return bl;
    }

    public boolean setProtectionLevel(int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                if (this.protectionHash == null) break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.protectionLevel = n;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setPasswordHash(String string) {
        if (string != null && string.length() != 8) {
            return;
        }
        this.protectionHash = string;
    }

    private int convertProtectionLevel() {
        int n = 0;
        switch (this.protectionLevel) {
            case 0: {
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 8: {
                n = 3;
            }
        }
        return n;
    }

    public int getProtectionLevelRaw() {
        return this.protectionLevel;
    }

    public int getProtectionLevel() {
        return this.convertProtectionLevel();
    }

    public byte[] getProtectionLevelBytes() {
        return DocWriter.getISOBytes(Integer.toString(this.convertProtectionLevel()));
    }

    public boolean setNewPassword(String string, String string2) {
        boolean bl = false;
        if (this.protectionHash.equals(RtfProtection.generateHash(string))) {
            this.protectionHash = RtfProtection.generateHash(string2);
            bl = true;
        }
        return bl;
    }

    public void setReadOnlyRecommended(boolean bl) {
        this.readOnlyRecommended = bl;
    }

    public boolean getReadOnlyRecommended() {
        return this.readOnlyRecommended;
    }

    public boolean isDocumentProtected() {
        return this.protectionHash != null;
    }

    public byte[] getProtectionHashBytes() {
        return DocWriter.getISOBytes(this.protectionHash);
    }

    public void setImageWrittenAsBinary(boolean bl) {
        this.imageWrittenAsBinary = bl;
    }

    public boolean isImageWrittenAsBinary() {
        return this.imageWrittenAsBinary;
    }
}

