/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.FileArrayArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;

public class ConcatN
extends AbstractTool {
    public ConcatN() {
        this.menuoptions = 3;
        this.arguments.add(new FileArrayArgument(this, "srcfiles", "The list of PDF files"));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the concatenated PDF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Concatenate n PDF files", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Concat OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfiles") == null) {
                throw new InstantiationException("You need to choose a list of sourcefiles");
            }
            File[] fileArray = (File[])this.getValue("srcfiles");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file = (File)this.getValue("destfile");
            int n = 0;
            ArrayList arrayList = new ArrayList();
            Document document = null;
            PdfWriter pdfWriter = null;
            for (int i = 0; i < fileArray.length; ++i) {
                PdfReader pdfReader = new PdfReader(fileArray[i].getAbsolutePath());
                pdfReader.consolidateNamedDestinations();
                int n2 = pdfReader.getNumberOfPages();
                List list = SimpleBookmark.getBookmark(pdfReader);
                if (list != null) {
                    if (n != 0) {
                        SimpleBookmark.shiftPageNumbers(list, n, null);
                    }
                    arrayList.addAll(list);
                }
                n += n2;
                System.out.println("There are " + n2 + " pages in " + fileArray[i]);
                if (i == 0) {
                    document = new Document(pdfReader.getPageSizeWithRotation(1));
                    pdfWriter = new PdfCopy(document, (OutputStream)new FileOutputStream(file));
                    document.open();
                }
                int n3 = 0;
                while (n3 < n2) {
                    PdfImportedPage pdfImportedPage = ((PdfCopy)pdfWriter).getImportedPage(pdfReader, ++n3);
                    ((PdfCopy)pdfWriter).addPage(pdfImportedPage);
                    System.out.println("Processed page " + n3);
                }
            }
            if (!arrayList.isEmpty()) {
                pdfWriter.setOutlines(arrayList);
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        ConcatN concatN = new ConcatN();
        if (stringArray.length < 2) {
            System.err.println(concatN.getUsage());
        }
        concatN.setMainArguments(stringArray);
        concatN.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        ConcatN.addVersion("$Id: ConcatN.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

