/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import com.ibm.icu.text.BreakIterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportFigureUtilities;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TextFlow;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.swt.graphics.Font;

public class LabelFigure
extends ReportElementFigure {
    private static final Dimension ZERO_DIMENSION = new Dimension();
    private TextFlow label;
    private FlowPage flowPage;
    private String display;
    private Dimension recommendSize = new Dimension();
    private boolean isFixLayout;
    static final BreakIterator LINE_BREAK = BreakIterator.getLineInstance();

    public LabelFigure() {
        this(1);
    }

    public String getDisplay() {
        return this.display;
    }

    public LabelFigure(int borderSize) {
        this.setBorder((Border)new MarginBorder(borderSize));
        this.label = new TextFlow(){

            public void postValidate() {
                if ("block".equals(LabelFigure.this.display) || "inline".equals(LabelFigure.this.display)) {
                    int left;
                    List list = this.getFragments();
                    int top = left = Integer.MAX_VALUE;
                    int bottom = Integer.MIN_VALUE;
                    int i = 0;
                    while (i < list.size()) {
                        FlowBox box = (FlowBox)list.get(i);
                        left = Math.min(left, box.getX());
                        top = Math.min(top, box.getBaseline() - box.getAscent());
                        bottom = Math.max(bottom, box.getBaseline() + box.getDescent());
                        ++i;
                    }
                    int width = LabelFigure.this.getClientArea().width;
                    if (LabelFigure.this.isFixLayout) {
                        int maxWidth = LabelFigure.this.calcMaxSegment() - this.getInsets().getWidth();
                        width = Math.max(width, maxWidth);
                    }
                    this.setBounds(new Rectangle(left, top, width, Math.max(LabelFigure.this.getClientArea().height, bottom - top)));
                    if (LabelFigure.this.isFixLayout()) {
                        Figure child = (Figure)this.getParent();
                        Rectangle rect = child.getBounds();
                        child.setBounds(new Rectangle(rect.x, rect.y, width, rect.height));
                    }
                    list = this.getChildren();
                    int i2 = 0;
                    while (i2 < list.size()) {
                        ((FlowFigure)list.get(i2)).postValidate();
                        ++i2;
                    }
                } else {
                    super.postValidate();
                }
            }
        };
        this.label.setLayoutManager((LayoutManager)new ParagraphTextLayout((org.eclipse.draw2d.text.TextFlow)this.label, 1));
        this.flowPage = new FlowPage();
        this.flowPage.add((IFigure)this.label);
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.flowPage);
    }

    private Dimension getPreferredSize(int wHint, int hHint, boolean isFix, boolean forceWidth, boolean forceHeight) {
        int rx = this.recommendSize != null ? this.recommendSize.width : 0;
        int ry = this.recommendSize != null ? this.recommendSize.height : 0;
        rx = this.getRealRecommendSizeX(rx, wHint);
        Dimension dim = null;
        if (isFix) {
            int tempHint = wHint;
            int maxWidth = this.calcMaxSegment();
            if (wHint < maxWidth && !forceWidth) {
                tempHint = maxWidth;
            }
            dim = super.getPreferredSize(tempHint <= 0 ? -1 : tempHint, hHint);
        } else if ("block".equals(this.display)) {
            dim = super.getPreferredSize(rx == 0 ? wHint : rx, hHint);
        } else {
            dim = super.getPreferredSize(rx == 0 ? -1 : rx, hHint);
            if (rx == 0 && wHint > 0 && dim.width > wHint) {
                dim = super.getPreferredSize(wHint, hHint);
            }
        }
        return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getPreferredSize(wHint, hHint, false, false, false);
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return this.getMinimumSize(wHint, hHint, false, false, false);
    }

    private Dimension getMinimumSize(int wHint, int hHint, boolean isFix, boolean forceWidth, boolean forceHeight) {
        if ("none".equals(this.display)) {
            return ZERO_DIMENSION;
        }
        int rx = this.recommendSize != null ? this.recommendSize.width : 0;
        int ry = this.recommendSize != null ? this.recommendSize.height : 0;
        rx = this.getRealRecommendSizeX(rx, wHint);
        if (wHint == -1 && hHint == -1) {
            int maxWidth = this.calcMaxSegment();
            Dimension dim = super.getMinimumSize(rx == 0 ? maxWidth : rx, -1);
            dim.height = Math.max(dim.height, Math.max(this.getInsets().getHeight(), ry));
            return dim;
        }
        if (isFix) {
            int tempHint = wHint;
            int maxWidth = this.calcMaxSegment();
            if (wHint < maxWidth && !forceWidth) {
                tempHint = maxWidth;
            }
            Dimension dim = super.getMinimumSize(tempHint <= 0 ? -1 : tempHint, hHint);
            return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
        }
        Dimension dim = super.getMinimumSize(rx == 0 ? -1 : rx, hHint);
        if (dim.width < wHint) {
            return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
        }
        dim = super.getMinimumSize(wHint, hHint);
        return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
    }

    private int getRealRecommendSizeX(int rx, int wHint) {
        ReportItemConstraint constraint;
        if (rx > 0 || wHint == -1) {
            return rx;
        }
        if (this.getParent() != null && this.getParent().getLayoutManager() != null && (constraint = (ReportItemConstraint)((Object)this.getParent().getLayoutManager().getConstraint((IFigure)this))) != null && constraint.getMeasure() != 0.0 && "%".equals(constraint.getUnits())) {
            rx = (int)constraint.getMeasure() * wHint / 100;
        }
        return rx;
    }

    private int calcMaxSegment() {
        int tempMaxWidth;
        String text = this.label.getText();
        char[] chars = text.toCharArray();
        int position = 0;
        int maxWidth = 0;
        int i = 0;
        while (i < chars.length) {
            if (LabelFigure.canBreakAfter(chars[i])) {
                String st = text.substring(position, i + 1);
                tempMaxWidth = FigureUtilities.getStringExtents((String)st, (Font)this.getFont()).width;
                if (tempMaxWidth > maxWidth) {
                    maxWidth = tempMaxWidth;
                }
                position = i;
            }
            ++i;
        }
        String st = text.substring(position, chars.length);
        tempMaxWidth = FigureUtilities.getStringExtents((String)st, (Font)this.getFont()).width;
        if (tempMaxWidth > maxWidth) {
            maxWidth = tempMaxWidth;
        }
        return maxWidth + this.getInsets().getWidth();
    }

    static boolean canBreakAfter(char c) {
        boolean result;
        boolean bl = result = Character.isWhitespace(c) || c == '-';
        if (!(result || c >= 'a' && c <= 'z')) {
            LINE_BREAK.setText(String.valueOf(c) + "a");
            result = LINE_BREAK.isBoundary(1);
        }
        return result;
    }

    private static int getMinimumFontSize(Font ft) {
        if (ft != null && ft.getFontData().length > 0) {
            return ft.getFontData()[0].getHeight();
        }
        return 0;
    }

    public Rectangle getEditorArea() {
        Rectangle rect = this.getClientArea().getCopy();
        String s = this.getText();
        int count = 0;
        if (s != null && s.length() > 1) {
            int i = s.length() - 2;
            while (i >= 0) {
                if (!"\r\n".equals(s.substring(i, i + 2))) break;
                ++count;
                i -= 2;
            }
        }
        int hh = LabelFigure.getMinimumFontSize(this.getFont());
        rect.height = rect.height + (count * hh + (count == 0 ? 0 : hh / 2));
        return rect;
    }

    public void setRecommendSize(Dimension recommendSize) {
        this.recommendSize = recommendSize;
    }

    public Dimension getRecommendSize() {
        return this.recommendSize;
    }

    public void setDisplay(String display) {
        if ("none".equals(display)) {
            this.setDisplay("block");
        }
        this.display = display;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String newText) {
        if (newText == null) {
            newText = "";
        }
        this.label.setText(newText);
    }

    public void setTextOverline(String textOverline) {
        this.label.setTextOverline(textOverline);
    }

    public void setTextLineThrough(String textLineThrough) {
        this.label.setTextLineThrough(textLineThrough);
    }

    public void setTextUnderline(String textUnderline) {
        this.label.setTextUnderline(textUnderline);
    }

    public void setTextAlign(String textAlign) {
        this.label.setTextAlign(textAlign);
    }

    public String getTextAlign() {
        return this.label.getTextAlign();
    }

    public void setVerticalAlign(String verticalAlign) {
        this.label.setVerticalAlign(verticalAlign);
    }

    public void setToolTipText(String toolTip) {
        if (toolTip != null) {
            this.setToolTip((IFigure)ReportFigureUtilities.createToolTipFigure(toolTip, this.getDirection(), this.getTextAlign()));
        } else {
            this.setToolTip(null);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.label.setFont(f);
    }

    public void setSpecialPREFIX(String specialPREFIX) {
        this.label.setSpecialPREFIX(specialPREFIX);
    }

    public String getDirection() {
        return this.label.getDirection();
    }

    public void setDirection(String direction) {
        this.label.setDirection(direction);
    }

    public Dimension getFixPreferredSize(int w, int h) {
        int width = 0;
        int height = 0;
        width = this.recommendSize.width > 0 ? this.recommendSize.width : (this.recommendSize.height > 0 ? this.getPreferredSize((int)w, (int)this.recommendSize.height, (boolean)true, (boolean)false, (boolean)true).width : this.getPreferredSize((int)w, (int)h, (boolean)true, (boolean)false, (boolean)false).width);
        if (this.recommendSize.height > 0) {
            height = this.recommendSize.height;
        } else if (this.recommendSize.width > 0) {
            int maxWidth = this.calcMaxSegment();
            height = this.getPreferredSize((int)Math.max((int)maxWidth, (int)this.recommendSize.width), (int)h, (boolean)true, (boolean)true, (boolean)false).height;
        } else {
            height = this.getPreferredSize((int)w, (int)h, (boolean)true, (boolean)false, (boolean)false).height;
        }
        return new Dimension(width, height);
    }

    public Dimension getFixMinimumSize(int w, int h) {
        int width = 0;
        int height = 0;
        width = this.recommendSize.width > 0 ? this.recommendSize.width : (this.recommendSize.height > 0 ? this.getMinimumSize((int)w, (int)this.recommendSize.height, (boolean)true, (boolean)false, (boolean)true).width : this.getMinimumSize((int)w, (int)h, (boolean)true, (boolean)false, (boolean)false).width);
        if (this.recommendSize.height > 0) {
            height = this.recommendSize.height;
        } else if (this.recommendSize.width > 0) {
            int maxWidth = this.calcMaxSegment();
            height = this.getMinimumSize((int)Math.max((int)maxWidth, (int)this.recommendSize.width), (int)h, (boolean)true, (boolean)true, (boolean)false).height;
        } else {
            height = this.getMinimumSize((int)w, (int)h, (boolean)true, (boolean)false, (boolean)false).height;
        }
        return new Dimension(width, height);
    }

    public boolean isFixLayout() {
        return this.isFixLayout;
    }

    public void setFixLayout(boolean isFixLayout) {
        this.isFixLayout = isFixLayout;
    }
}

