/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.TableCellSelectionHelper;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.IDelaySelectionDragTracker;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class CellDragTracker
extends DragEditPartsTracker
implements IDelaySelectionDragTracker {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private int mode;
    private Figure marqueeRectangleFigure;
    private List selectedEditParts;
    private Request targetRequest;
    public static final Request MARQUEE_REQUEST = new Request((Object)"selection");

    public CellDragTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected void handleFinished() {
    }

    private List calculateNewSelection() {
        ArrayList newSelections = new ArrayList();
        TableUtil.calculateNewSelection(this.getMarqueeSelectionRectangle(), newSelections, this.getAllChildren());
        int size = newSelections.size();
        TableUtil.calculateNewSelection(TableUtil.getUnionBounds(newSelections), newSelections, this.getAllChildren());
        while (size != newSelections.size()) {
            size = newSelections.size();
            TableUtil.calculateNewSelection(TableUtil.getUnionBounds(newSelections), newSelections, this.getAllChildren());
        }
        return newSelections;
    }

    protected Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    protected void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private List getAllChildren() {
        return this.getSourceEditPart().getParent().getChildren();
    }

    protected String getCommandName() {
        return "selection";
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private int getSelectionMode() {
        return this.mode;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        boolean rlt = super.handleButtonDown(button);
        if (button == 1 && this.getCurrentInput().isShiftKeyDown()) {
            this.performShiftSelect();
        } else if (button == 1 && this.getCurrentInput().isControlKeyDown()) {
            this.performCtrlSelect();
        }
        return rlt;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
            return true;
        }
        boolean bool = super.handleButtonUp(button);
        this.handleFinished();
        return bool;
    }

    private void performCtrlSelect() {
    }

    protected void performShiftSelect() {
        ArrayList nlst;
        AbstractTableEditPart parent = (AbstractTableEditPart)this.getSourceEditPart().getParent();
        if (parent.getViewer() != this.getCurrentViewer()) {
            return;
        }
        List slst = this.getCurrentViewer().getSelectedEditParts();
        if (slst != null && slst.contains(this.getSourceEditPart())) {
            nlst = new ArrayList();
            nlst.add(slst.get(0));
        } else {
            nlst = new ArrayList(slst);
        }
        Rectangle constraint = TableCellSelectionHelper.getSelectionRectangle((AbstractCellEditPart)this.getSourceEditPart(), nlst);
        boolean refined = TableCellSelectionHelper.increaseSelectionRectangle(constraint, parent);
        while (refined) {
            refined = TableCellSelectionHelper.increaseSelectionRectangle(constraint, parent);
        }
        List lst = TableCellSelectionHelper.getRectangleSelection(constraint, parent);
        if (lst == null || lst.size() == 0) {
            return;
        }
        boolean first = true;
        for (GraphicalEditPart part : lst) {
            if (first) {
                this.getCurrentViewer().select((EditPart)part);
                first = false;
            } else {
                this.getCurrentViewer().appendSelection((EditPart)part);
            }
            this.getCurrentViewer().reveal((EditPart)part);
        }
    }

    protected void performSelection() {
        if (this.hasSelectionOccurred()) {
            return;
        }
        if (this.getCurrentInput().isControlKeyDown() || this.getCurrentInput().isShiftKeyDown()) {
            this.setFlag(64, true);
            EditPartViewer viewer = this.getCurrentViewer();
            List selectedObjects = viewer.getSelectedEditParts();
            boolean consist = true;
            EditPart sourceParent = this.getSourceEditPart().getParent();
            for (EditPart part : selectedObjects) {
                if (part.getParent() == sourceParent) continue;
                consist = false;
                break;
            }
            if (consist) {
                if (this.getCurrentInput().isControlKeyDown()) {
                    return;
                }
                if (this.getCurrentInput().isShiftKeyDown()) {
                    return;
                }
            }
            viewer.select(this.getSourceEditPart());
            return;
        }
        super.performSelection();
    }

    public boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        return this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e);
    }

    private void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else if (this.getSelectionMode() == 1) {
            ArrayList<EditPart> selected = new ArrayList<EditPart>(viewer.getSelectedEditParts());
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                if (editPart.getSelected() != 0) {
                    selected.remove(editPart);
                } else {
                    selected.add(editPart);
                }
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    protected void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = (EditPart)this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }

    public void setStartLocation(Point p) {
        super.setStartLocation(p);
    }

    public void setState(int state) {
        super.setState(state);
    }

    public void setLocation(Point p) {
        this.getCurrentInput().setMouseLocation(p.x, p.y);
    }

    public EditPart getSourceEditPart() {
        return super.getSourceEditPart();
    }

    private static class MarqueeRectangleFigure
    extends Figure {
        private int offset = 0;
        private boolean schedulePaint = true;
        private static final int DELAY = 110;

        private MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = MarqueeRectangleFigure.this;
                        marqueeRectangleFigure.offset = marqueeRectangleFigure.offset + 1;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

