/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public final class UIHelper {
    public static URL getURL(Bundle bundle, String sPluginRelativePath) {
        URL url = null;
        if (bundle != null && Platform.getExtensionRegistry() != null) {
            try {
                url = new URL(bundle.getEntry("/"), sPluginRelativePath);
            }
            catch (MalformedURLException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            try {
                url = new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                ExceptionHandler.handle(e);
            }
        }
        return url;
    }

    private static Image createImage(Bundle bundle, String sPluginRelativePath) {
        Image img = null;
        try {
            URL imgURL = UIHelper.getURL(bundle, sPluginRelativePath);
            if (imgURL != null) {
                try {
                    img = new Image((Device)Display.getCurrent(), imgURL.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(imgURL.toString()));
                }
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static Image getImage(Bundle bundle, String sPluginRelativePath) {
        Image image;
        ImageRegistry registry = JFaceResources.getImageRegistry();
        String imgKey = sPluginRelativePath;
        if (bundle != null) {
            imgKey = String.valueOf(bundle.getSymbolicName()) + ":" + sPluginRelativePath;
        }
        if ((image = registry.get(imgKey)) == null) {
            image = UIHelper.createImage(bundle, sPluginRelativePath);
            registry.put(imgKey, image);
        }
        return image;
    }
}

