/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String AUTO = Messages.getString((String)"LayoutConfigurationBlock.Default.Unit.Auto");
    private final OptionsConfigurationBlock.Key PREF_DEFAULT_UNIT = this.getReportKey("report.designer.ui.preferences.default.unit");
    private static final String DEFAULT_UNIT = Messages.getString((String)"LayoutConfigurationBlock.Default.Unit.Label");
    public final int LTR_DIRECTION_INDX = 0;
    public final int RTL_DIRECTION_INDX = 1;
    private PixelConverter fPixelConverter;

    public LayoutConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_DEFAULT_UNIT};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        IChoiceSet choiceSet = ChoiceSetFactory.getElementChoiceSet("ReportDesign", "units");
        int len = choiceSet.getChoices().length;
        String[] unitValues = new String[len + 1];
        String[] unitNames = new String[len + 1];
        unitNames[0] = AUTO;
        unitValues[0] = "Auto";
        int i = 0;
        while (i < len) {
            IChoice ch = choiceSet.getChoices()[i];
            unitValues[i + 1] = ch.getName();
            unitNames[i + 1] = ch.getDisplayName();
            ++i;
        }
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        this.addComboBox(pageContent, DEFAULT_UNIT, this.PREF_DEFAULT_UNIT, unitValues, unitNames, 0);
        return pageContent;
    }

    public void performDefaults() {
        super.performDefaults();
    }

    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
    }
}

