/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;

public class VersionManager {
    public static final int VERSION_2_0 = 0;
    public static final int VERSION_2_1 = 1;
    public static final int VERSION_2_2 = 2;
    public static final int VERSION_2_2_0 = 10;
    public static final int VERSION_2_2_1 = 20;
    public static final int VERSION_2_2_1_1 = 25;
    public static final int VERSION_2_2_1_2 = 30;
    public static final int VERSION_2_2_1_3 = 50;
    public static final int VERSION_2_3_1 = 70;
    public static final int VERSION_2_3_2 = 90;
    public static final int VERSION_2_3_2_1 = 95;
    public static final int VERSION_2_5_0_1 = 100;
    public static final int VERSION_2_5_1_0 = 110;
    public static final int VERSION_2_5_1_1 = 120;
    private DataEngineContext dataEngineContext;
    private static Logger logger = Logger.getLogger(VersionManager.class.getName());

    public VersionManager(DataEngineContext context) {
        this.dataEngineContext = context;
    }

    public int getVersion() {
        int version = VersionManager.getLatestVersion();
        if (!this.dataEngineContext.hasInStream(null, null, 11)) {
            version = 0;
            return version;
        }
        try {
            DataInputStream is = new DataInputStream((InputStream)this.dataEngineContext.getInputStream(null, null, 11));
            version = IOUtil.readInt((InputStream)is);
            is.close();
        }
        catch (DataException e) {
            logger.log(Level.FINE, e.getMessage(), (Throwable)((Object)e));
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        return version;
    }

    void setVersion(int version) throws DataException {
        RAOutputStream versionOs = this.dataEngineContext.getOutputStream(null, null, 11);
        DataOutputStream versionDos = new DataOutputStream((OutputStream)versionOs);
        try {
            IOUtil.writeInt((OutputStream)versionDos, (int)version);
            versionDos.close();
            versionOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    public static int getLatestVersion() {
        return 120;
    }
}

