/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.jointdataset;

import java.util.List;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IJoinCondition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JoinConditionMatchUnit;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetUtil;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

public class JoinConditionMatcher
implements IJoinConditionMatcher {
    private JoinConditionMatchUnit[] left = new JoinConditionMatchUnit[0];
    private JoinConditionMatchUnit[] right = new JoinConditionMatchUnit[0];

    public JoinConditionMatcher(IResultIterator leftRi, IResultIterator rightRi, Scriptable leftScope, Scriptable rightScope, ScriptContext cx, List joinConditions) {
        this.left = new JoinConditionMatchUnit[joinConditions.size()];
        this.right = new JoinConditionMatchUnit[joinConditions.size()];
        int i = 0;
        while (i < joinConditions.size()) {
            this.populateJoinUnit(((IJoinCondition)joinConditions.get(i)).getLeftExpression(), cx, i, this.left, leftRi, leftScope);
            this.populateJoinUnit(((IJoinCondition)joinConditions.get(i)).getRightExpression(), cx, i, this.right, rightRi, rightScope);
            ++i;
        }
    }

    private void populateJoinUnit(IScriptExpression expr, ScriptContext cx, int i, JoinConditionMatchUnit[] toArray, IResultIterator ri, Scriptable scope) {
        toArray[i] = new JoinConditionMatchUnit(expr, scope, cx);
    }

    public boolean match() throws DataException {
        int i = 0;
        while (i < this.left.length) {
            Object rightValue;
            Object leftValue = this.left[i].getColumnValue();
            if (JointDataSetUtil.compare(leftValue, rightValue = this.right[i].getColumnValue()) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compare(Object[] lObjects, Object[] rObjects) throws DataException {
        int result = 0;
        int i = 0;
        while (i < lObjects.length) {
            result = JointDataSetUtil.compare(lObjects[i], rObjects[i]);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public Object[] getCompareValue(boolean isLeft) throws DataException {
        JoinConditionMatchUnit[] array = null;
        array = isLeft ? this.left : this.right;
        Object[] result = new Object[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i].getColumnValue();
            ++i;
        }
        return result;
    }
}

