/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.olap.data.document.IObjectAllocTable;
import org.eclipse.birt.data.engine.olap.data.document.IRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;

public class BlockRandomAccessObject
implements IRandomAccessObject {
    private BufferedRandomAccessFile dataFile;
    private String name;
    private long length;
    private IObjectAllocTable documentObjectAllocatedTable;
    private long position;
    private List blockList = null;

    public BlockRandomAccessObject(BufferedRandomAccessFile dataFile, String name, int firstBlock, long length, IObjectAllocTable documentObjectAllocatedTable) throws IOException {
        this.name = name;
        this.dataFile = dataFile;
        this.length = length;
        this.documentObjectAllocatedTable = documentObjectAllocatedTable;
        this.position = 0L;
        this.blockList = new ArrayList();
        int blockNumber = firstBlock;
        do {
            this.blockList.add(new Integer(blockNumber));
        } while ((blockNumber = documentObjectAllocatedTable.getNextBlock(blockNumber)) > 0);
    }

    public void close() throws IOException {
        this.seek(0L);
        this.documentObjectAllocatedTable.setObjectLength(this.name, this.length);
    }

    public long getFilePointer() throws IOException {
        return this.position;
    }

    public long length() throws IOException {
        return this.length;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.position >= this.length) {
            return -1;
        }
        int remainSizeOfCurrentBlock = 4096 - (int)(this.position % 4096L);
        this.dataFileSeek();
        if (remainSizeOfCurrentBlock >= len || this.position + (long)remainSizeOfCurrentBlock >= this.length) {
            int readSize = (int)Math.min(this.length - this.position, (long)len);
            this.position += (long)readSize;
            return this.dataFile.read(b, off, readSize);
        }
        this.dataFile.read(b, off, remainSizeOfCurrentBlock);
        this.position += (long)remainSizeOfCurrentBlock;
        int readSize = this.read(b, off + remainSizeOfCurrentBlock, len - remainSizeOfCurrentBlock);
        if (readSize == -1) {
            return remainSizeOfCurrentBlock;
        }
        return remainSizeOfCurrentBlock + readSize;
    }

    private void dataFileSeek() throws IOException {
        int blockIndex = (int)(this.position / 4096L);
        int posInBlock = (int)(this.position % 4096L);
        int dataFilePosition = (Integer)this.blockList.get(blockIndex) * 4096 + posInBlock;
        this.dataFile.seek(dataFilePosition);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void seek(long pos) throws IOException {
        this.position = pos;
    }

    public void setLength(long newLength) throws IOException {
        assert (newLength > 0L);
        int needBlockCount = (int)((newLength - 1L) / 4096L) + 1;
        if (needBlockCount > this.blockList.size()) {
            int lastBlockNumber = (Integer)this.blockList.get(this.blockList.size() - 1);
            int moreBlockCount = needBlockCount - this.blockList.size();
            int i = 0;
            while (i < moreBlockCount) {
                lastBlockNumber = this.documentObjectAllocatedTable.allocateBlock(lastBlockNumber);
                this.blockList.add(new Integer(lastBlockNumber));
                ++i;
            }
        }
        this.length = newLength;
        this.documentObjectAllocatedTable.setObjectLength(this.name, this.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.position + (long)len > this.length) {
            this.setLength(this.position + (long)len);
        }
        int remainSizeOfCurrentBlock = 4096 - (int)(this.position % 4096L);
        this.dataFileSeek();
        if (remainSizeOfCurrentBlock >= len || this.position + (long)remainSizeOfCurrentBlock >= this.length) {
            len = (int)Math.min(this.length - this.position, (long)len);
            this.position += (long)len;
            this.dataFile.write(b, off, len);
        } else {
            this.dataFile.write(b, off, remainSizeOfCurrentBlock);
            this.position += (long)remainSizeOfCurrentBlock;
            this.write(b, off + remainSizeOfCurrentBlock, len - remainSizeOfCurrentBlock);
        }
    }

    public void flush() throws IOException {
        this.seek(0L);
        this.documentObjectAllocatedTable.setObjectLength(this.name, this.length);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int len = this.read(b);
        if (len < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }
}

