/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.DrilledAggregateResultSet;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

public class DrilledEdgeAxis
implements IEdgeAxis {
    private IAggregationResultSet mergedResultSet;
    private IRowDataAccessor dataAccessor;
    private DimensionAxis[] dimensionAxis;
    private RowDataAccessorService service;

    public DrilledEdgeAxis(IAggregationResultSet resultSet, List drillRs, BirtEdgeView view, List sortList, List drillFilters) throws IOException {
        this.mergedResultSet = this.mergeBaseResultWithDrillResult(resultSet, drillRs, drillFilters);
        this.populateDimensionAxis(resultSet, view);
        this.service = new RowDataAccessorService(this.dimensionAxis, view);
        this.dataAccessor = new RowDataAccessor(this.service, this.mergedResultSet);
        int i = 0;
        while (i < this.dimensionAxis.length) {
            this.dimensionAxis[i].setEdgeInfo(this.dataAccessor);
            ++i;
        }
    }

    private IAggregationResultSet mergeBaseResultWithDrillResult(IAggregationResultSet resultSet, List drillRs, List drills) throws IOException {
        return new DrilledAggregateResultSet(resultSet, drillRs, drills);
    }

    private void populateDimensionAxis(IAggregationResultSet rs, BirtEdgeView view) throws IOException {
        ArrayList<DimensionAxis> dimensionAxisList = new ArrayList<DimensionAxis>();
        int index = -1;
        int levelIndex = -1;
        index = 0;
        levelIndex = 0;
        int i = 0;
        while (i < view.getDimensionViews().size()) {
            BirtDimensionView dv = (BirtDimensionView)view.getDimensionViews().get(i);
            Iterator levelIter = dv.getMemberSelection().iterator();
            while (levelIter.hasNext()) {
                levelIter.next();
                DimensionAxis axis = new DimensionAxis(this, this.mergedResultSet, index, levelIndex);
                ++index;
                ++levelIndex;
                dimensionAxisList.add(axis);
            }
            ++i;
        }
        this.dimensionAxis = new DimensionAxis[dimensionAxisList.size()];
        i = 0;
        while (i < dimensionAxisList.size()) {
            this.dimensionAxis[i] = (DimensionAxis)dimensionAxisList.get(i);
            ++i;
        }
    }

    public IRowDataAccessor getRowDataAccessor() {
        return this.dataAccessor;
    }

    public DimensionAxis[] getAllDimensionAxis() {
        return this.dimensionAxis;
    }

    public DimensionAxis getDimensionAxis(int index) {
        return this.dimensionAxis[index];
    }

    public IAggregationResultSet getQueryResultSet() {
        return this.mergedResultSet;
    }

    public void populateEdgeInfo(boolean isPage) throws OLAPException {
        if (this.dataAccessor != null) {
            try {
                this.dataAccessor.initialize(isPage);
            }
            catch (IOException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
    }
}

