/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core;

import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.core.GenericJpaProjectManager;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaProjectManager;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.internal.JpaPlatformRegistry;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;

public class JptCorePlugin
extends Plugin {
    private volatile GenericJpaProjectManager jpaProjectManager;
    private volatile ServiceTracker parserTracker;
    private static volatile boolean flushPreferences = true;
    public static final String PLUGIN_ID = "org.eclipse.jpt.core";
    public static final String PLUGIN_ID_ = "org.eclipse.jpt.core.";
    public static final String FACET_ID = "jpt.jpa";
    public static final String JPA_FACET_VERSION_1_0 = "1.0";
    public static final String JPA_FACET_VERSION_2_0 = "2.0";
    private static final String JPA_PLATFORM_PREF_KEY = "org.eclipse.jpt.core.platform";
    @Deprecated
    public static final String DEFAULT_JPA_PLATFORM_PREF_KEY = "defaultJpaPlatform";
    public static final String DEFAULT_JPA_PLATFORM_1_0_PREF_KEY = "defaultJpaPlatform_1.0";
    public static final String DEFAULT_JPA_PLATFORM_2_0_PREF_KEY = "defaultJpaPlatform_2.0";
    public static final String DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.core.discoverAnnotatedClasses";
    public static final String METAMODEL_SOURCE_FOLDER_NAME = "org.eclipse.jpt.core.metamodelSourceFolderName";
    public static final QualifiedName DATA_SOURCE_CONNECTION_PROFILE_NAME = new QualifiedName("org.eclipse.jpt.core", "dataSource.connectionProfileName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_CATALOG = new QualifiedName("org.eclipse.jpt.core", "userOverrideDefaultCatalogName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_SCHEMA = new QualifiedName("org.eclipse.jpt.core", "userOverrideDefaultSchemaName");
    public static final String VALIDATOR_ID = "org.eclipse.jpt.core.jpaValidator";
    public static final IContentType JAVA_SOURCE_CONTENT_TYPE = JptCorePlugin.getContentType("org.eclipse.jdt.core.javaSource");
    public static final JpaResourceType JAVA_SOURCE_RESOURCE_TYPE = new JpaResourceType(JAVA_SOURCE_CONTENT_TYPE);
    public static final IContentType PERSISTENCE_XML_CONTENT_TYPE = JptCorePlugin.getJpaContentType("persistence");
    public static final JpaResourceType PERSISTENCE_XML_1_0_RESOURCE_TYPE = new JpaResourceType(PERSISTENCE_XML_CONTENT_TYPE, "1.0");
    public static final JpaResourceType PERSISTENCE_XML_2_0_RESOURCE_TYPE = new JpaResourceType(PERSISTENCE_XML_CONTENT_TYPE, "2.0");
    public static final IContentType MAPPING_FILE_CONTENT_TYPE = JptCorePlugin.getJpaContentType("mappingFile");
    public static final IContentType ORM_XML_CONTENT_TYPE = JptCorePlugin.getJpaContentType("orm");
    public static final JpaResourceType ORM_XML_1_0_RESOURCE_TYPE = new JpaResourceType(ORM_XML_CONTENT_TYPE, "1.0");
    public static final JpaResourceType ORM_XML_2_0_RESOURCE_TYPE = new JpaResourceType(ORM_XML_CONTENT_TYPE, "2.0");
    public static final IContentType JAR_CONTENT_TYPE = JptCorePlugin.getJpaContentType("jar");
    public static final JpaResourceType JAR_RESOURCE_TYPE = new JpaResourceType(JAR_CONTENT_TYPE);
    public static final String WEB_PROJECT_FACET_ID = "jst.web";
    public static final String WEB_PROJECT_DEPLOY_PREFIX = "WEB-INF/classes";
    public static final String DEFAULT_PERSISTENCE_XML_FILE_PATH = "META-INF/persistence.xml";
    public static final String DEFAULT_ORM_XML_FILE_PATH = "META-INF/orm.xml";
    public static final String CONTENT_PREFIX = "org.eclipse.jpt.core.content";
    public static final String CONTENT_PREFIX_ = "org.eclipse.jpt.core.content.";
    private static JptCorePlugin INSTANCE;

    private static IContentType getJpaContentType(String jpaContentType) {
        return JptCorePlugin.getContentType(CONTENT_PREFIX_ + jpaContentType);
    }

    private static IContentType getContentType(String contentType) {
        return Platform.getContentTypeManager().getContentType(contentType);
    }

    public static JptCorePlugin instance() {
        return INSTANCE;
    }

    public static JpaProjectManager getJpaProjectManager() {
        return INSTANCE.getJpaProjectManager_();
    }

    public static JpaProject getJpaProject(IProject project) {
        return JptCorePlugin.getJpaProjectManager().getJpaProject(project);
    }

    public static JpaFile getJpaFile(IFile file) {
        return JptCorePlugin.getJpaProjectManager().getJpaFile(file);
    }

    public static void rebuildJpaProject(IProject project) {
        JptCorePlugin.getJpaProjectManager().rebuildJpaProject(project);
    }

    public static boolean projectHasJpaFacet(IProject project) {
        return JptCorePlugin.projectHasFacet(project, FACET_ID);
    }

    public static boolean projectHasWebFacet(IProject project) {
        return JptCorePlugin.projectHasFacet(project, WEB_PROJECT_FACET_ID);
    }

    private static boolean projectHasFacet(IProject project, String facetId) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetId);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return false;
        }
    }

    public static String getPersistenceXmlDeploymentURI(IProject project) {
        return JptCorePlugin.getDeploymentURI(project, DEFAULT_PERSISTENCE_XML_FILE_PATH);
    }

    public static String getDefaultOrmXmlDeploymentURI(IProject project) {
        return JptCorePlugin.getDeploymentURI(project, DEFAULT_ORM_XML_FILE_PATH);
    }

    public static String getOrmXmlDeploymentURI(IProject project, String mappingFileName) {
        return JptCorePlugin.getDeploymentURI(project, mappingFileName);
    }

    public static String getDeploymentURI(IProject project, String defaultURI) {
        return JptCorePlugin.projectHasWebFacet(project) ? "WEB-INF/classes/" + defaultURI : defaultURI;
    }

    public static IPath getJarDeploymentRootPath(IProject project) {
        return new Path(JptCorePlugin.getJarDeploymentRootPathName(project));
    }

    private static String getJarDeploymentRootPathName(IProject project) {
        return JptCorePlugin.projectHasWebFacet(project) ? "/WEB-INF" : "/";
    }

    public static IFile getPlatformFile(IProject project, String defaultURI) {
        Path deploymentPath = new Path(JptCorePlugin.getDeploymentURI(project, defaultURI));
        IVirtualFile vFile = ComponentCore.createFile((IProject)project, (IPath)deploymentPath);
        return vFile.getUnderlyingFile();
    }

    public static JpaFile getJpaFile(IProject project, String defaultURI) {
        IFile xmlFile = JptCorePlugin.getPlatformFile(project, defaultURI);
        return xmlFile.exists() ? JptCorePlugin.getJpaFile(xmlFile) : null;
    }

    public static void initializeDefaultPreferences() {
        IEclipsePreferences node = JptCorePlugin.getDefaultPreferences();
        String defaultPlatformId_1_0 = JpaPlatformRegistry.instance().getDefaultJpaPlatformId(JPA_FACET_VERSION_1_0);
        if (StringTools.stringIsEmpty((String)defaultPlatformId_1_0)) {
            defaultPlatformId_1_0 = "generic";
        }
        node.put(DEFAULT_JPA_PLATFORM_1_0_PREF_KEY, defaultPlatformId_1_0);
        String defaultPlatformId_2_0 = JpaPlatformRegistry.instance().getDefaultJpaPlatformId(JPA_FACET_VERSION_2_0);
        if (StringTools.stringIsEmpty((String)defaultPlatformId_2_0)) {
            defaultPlatformId_2_0 = "generic2_0";
        }
        node.put(DEFAULT_JPA_PLATFORM_2_0_PREF_KEY, defaultPlatformId_2_0);
    }

    public static IEclipsePreferences getDefaultPreferences() {
        return JptCorePlugin.getPreferences((IScopeContext)new DefaultScope());
    }

    public static IEclipsePreferences getWorkspacePreferences() {
        return JptCorePlugin.getPreferences((IScopeContext)new InstanceScope());
    }

    public static IEclipsePreferences getProjectPreferences(IProject project) {
        return JptCorePlugin.getPreferences((IScopeContext)new ProjectScope(project));
    }

    private static IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode(PLUGIN_ID);
    }

    public static String getDefaultJpaPlatformId(String jpaFacetVersion) {
        String defaultPlatformId = JptCorePlugin.getDefaultJpaPlatformId(jpaFacetVersion, new Preferences[]{JptCorePlugin.getWorkspacePreferences(), JptCorePlugin.getDefaultPreferences()});
        if (defaultPlatformId == null) {
            defaultPlatformId = JptCorePlugin.getDefaultJpaPlatformId(jpaFacetVersion, new Preferences[]{JptCorePlugin.getDefaultPreferences()});
        }
        return defaultPlatformId;
    }

    private static String getDefaultJpaPlatformId(String jpaFacetVersion, Preferences ... nodes) {
        String defaultDefaultPlatformId = JptCorePlugin.getDefaultJpaPlatformId(jpaFacetVersion, DEFAULT_JPA_PLATFORM_PREF_KEY, null, nodes);
        String preferenceKey = null;
        if (jpaFacetVersion.equals(JPA_FACET_VERSION_1_0)) {
            if (defaultDefaultPlatformId == null) {
                defaultDefaultPlatformId = "generic";
            }
            preferenceKey = DEFAULT_JPA_PLATFORM_1_0_PREF_KEY;
        } else if (jpaFacetVersion.equals(JPA_FACET_VERSION_2_0)) {
            if (defaultDefaultPlatformId == null) {
                defaultDefaultPlatformId = "generic2_0";
            }
            preferenceKey = DEFAULT_JPA_PLATFORM_2_0_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JPA facet version: " + jpaFacetVersion);
        }
        return JptCorePlugin.getDefaultJpaPlatformId(jpaFacetVersion, preferenceKey, defaultDefaultPlatformId, nodes);
    }

    private static String getDefaultJpaPlatformId(String jpaFacetVersion, String preferenceKey, String defaultDefault, Preferences ... nodes) {
        String defaultPlatformId = Platform.getPreferencesService().get(preferenceKey, defaultDefault, nodes);
        if (JptCorePlugin.jpaPlatformIdIsValid(defaultPlatformId) && JpaPlatformRegistry.instance().platformSupportsJpaFacetVersion(defaultPlatformId, jpaFacetVersion)) {
            return defaultPlatformId;
        }
        if (JptCorePlugin.jpaPlatformIdIsValid(defaultDefault) && JpaPlatformRegistry.instance().platformSupportsJpaFacetVersion(defaultDefault, jpaFacetVersion)) {
            return defaultDefault;
        }
        return null;
    }

    private static boolean jpaPlatformIdIsValid(String platformId) {
        return JpaPlatformRegistry.instance().containsPlatform(platformId);
    }

    public static void setDefaultJpaPlatformId(String jpaFacetVersion, String platformId) {
        IEclipsePreferences prefs = JptCorePlugin.getWorkspacePreferences();
        String preferenceKey = null;
        if (JPA_FACET_VERSION_1_0.equals(jpaFacetVersion)) {
            preferenceKey = DEFAULT_JPA_PLATFORM_1_0_PREF_KEY;
        } else if (JPA_FACET_VERSION_2_0.equals(jpaFacetVersion)) {
            preferenceKey = DEFAULT_JPA_PLATFORM_2_0_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JPA facet version: " + jpaFacetVersion);
        }
        prefs.put(preferenceKey, platformId);
        JptCorePlugin.flush(prefs);
    }

    public static JpaPlatform getJpaPlatform(IProject project) {
        return JpaPlatformRegistry.instance().getJpaPlatform(project);
    }

    public static String getJpaPlatformId(IProject project) {
        return JptCorePlugin.getProjectPreferences(project).get(JPA_PLATFORM_PREF_KEY, "generic");
    }

    public static void setJpaPlatformId(IProject project, String jpaPlatformId) {
        IEclipsePreferences prefs = JptCorePlugin.getProjectPreferences(project);
        prefs.put(JPA_PLATFORM_PREF_KEY, jpaPlatformId);
        JptCorePlugin.flush(prefs);
    }

    public static String getJpaPlatformIdPrefKey() {
        return JPA_PLATFORM_PREF_KEY;
    }

    public static boolean discoverAnnotatedClasses(IProject project) {
        return JptCorePlugin.getProjectPreferences(project).getBoolean(DISCOVER_ANNOTATED_CLASSES, false);
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean discoverAnnotatedClasses) {
        IEclipsePreferences prefs = JptCorePlugin.getProjectPreferences(project);
        prefs.putBoolean(DISCOVER_ANNOTATED_CLASSES, discoverAnnotatedClasses);
        JptCorePlugin.flush(prefs);
    }

    public static String getMetamodelSourceFolderName(IProject project) {
        return JptCorePlugin.getProjectPreferences(project).get(METAMODEL_SOURCE_FOLDER_NAME, null);
    }

    public static void setMetamodelSourceFolderName(IProject project, String metamodelSourceFolderName) {
        IEclipsePreferences prefs = JptCorePlugin.getProjectPreferences(project);
        if (metamodelSourceFolderName == null) {
            prefs.remove(METAMODEL_SOURCE_FOLDER_NAME);
        } else {
            prefs.put(METAMODEL_SOURCE_FOLDER_NAME, metamodelSourceFolderName);
        }
        JptCorePlugin.flush(prefs);
    }

    private static void doNotFlushPreferences() {
        flushPreferences = false;
    }

    private static void flush(IEclipsePreferences prefs) {
        if (flushPreferences) {
            new PreferencesFlushJob(prefs).schedule();
        }
    }

    public static String getConnectionProfileName(IProject project) {
        try {
            String connectionProfileName = project.getPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME);
            return StringTools.stringIsEmpty((String)connectionProfileName) ? null : connectionProfileName;
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static void setConnectionProfileName(IProject project, String connectionProfileName) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, connectionProfileName);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultCatalog(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static void setUserOverrideDefaultCatalog(IProject project, String defaultCatalog) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG, defaultCatalog);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultSchema(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static void setUserOverrideDefaultSchema(IProject project, String defaultSchema) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA, defaultSchema);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static boolean nodeIsJpa2_0Compatible(JpaNode jpaNode) {
        return jpaNode.getJpaProject().getJpaPlatform().getJpaVersion().isCompatibleWithJpaVersion(JPA_FACET_VERSION_2_0);
    }

    public static boolean javaElementChangeListenerIsActive() {
        return JptCorePlugin.getJpaProjectManager().javaElementChangeListenerIsActive();
    }

    public static void setJavaElementChangeListenerIsActive(boolean javaElementChangeListenerIsActive) {
        JptCorePlugin.getJpaProjectManager().setJavaElementChangeListenerIsActive(javaElementChangeListenerIsActive);
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public static void log(String msg) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void log(Throwable throwable) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, throwable.getLocalizedMessage(), throwable));
    }

    public JptCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.jpaProjectManager != null) {
                this.jpaProjectManager.stop();
                this.jpaProjectManager = null;
            }
            if (this.parserTracker != null) {
                this.parserTracker.close();
                this.parserTracker = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    private synchronized GenericJpaProjectManager getJpaProjectManager_() {
        if (this.jpaProjectManager == null) {
            this.jpaProjectManager = this.buildJpaProjectManager();
            this.jpaProjectManager.start();
        }
        return this.jpaProjectManager;
    }

    private GenericJpaProjectManager buildJpaProjectManager() {
        return new GenericJpaProjectManager();
    }

    public synchronized SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = (SAXParserFactory)this.getParserTracker().getService();
        if (factory != null) {
            factory.setNamespaceAware(true);
        }
        return factory;
    }

    private ServiceTracker getParserTracker() {
        if (this.parserTracker == null) {
            this.parserTracker = this.buildParserTracker();
            this.parserTracker.open();
        }
        return this.parserTracker;
    }

    private ServiceTracker buildParserTracker() {
        return new ServiceTracker(this.getBundle().getBundleContext(), "javax.xml.parsers.SAXParserFactory", null);
    }

    private static class PreferencesFlushJob
    extends Job {
        private final IEclipsePreferences prefs;

        PreferencesFlushJob(IEclipsePreferences prefs) {
            super(NLS.bind((String)JptCoreMessages.PREFERENCES_FLUSH_JOB_NAME, (Object)prefs.absolutePath()));
            this.prefs = prefs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                JptCorePlugin.log(ex);
            }
            return Status.OK_STATUS;
        }
    }
}

