/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.Map;

import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.mozilla.javascript.Scriptable;


public class DrillQueryHelper
{
	private ICubeQueryDefinition query;
	private ICube cube;
	private Scriptable scope;
	private DataEngineContext context;
	private DataEngineSession session;
	private IBaseQueryResults outResults;
	private Map appContext;
	private StopSign stopSign;
	
	private BirtCubeView[] viewsOnColumnEdge = null;
	private BirtCubeView[] viewsOnRowEdge = null;
	private BirtCubeView[] viewsOnCross = null;
	private BirtCubeView[] allViews = null;
	
	public DrillQueryHelper( IBaseQueryResults outResults,
			ICubeQueryDefinition query, ICube cube, DataEngineSession session,
			Scriptable scope, DataEngineContext context, Map appContext,
			StopSign stopSign )
	{
		this.query = query;
		this.cube = cube;
		this.scope = scope;
		this.context = context;
		this.session = session;
		this.outResults = outResults;
		this.appContext = appContext;
		this.stopSign = stopSign;
	}
	
	public BirtCubeView[] getCubeViewOnColumnEdge( )
			throws DataException
	{
		if( viewsOnColumnEdge!= null )
			return viewsOnColumnEdge;
		ICubeQueryDefinition[] drillEdgeQuerys = CubeQueryDefinitionUtil.getCubeQueryFromDrills( query,
				cube,
				ICubeQueryDefinition.COLUMN_EDGE );

		viewsOnColumnEdge = new BirtCubeView[drillEdgeQuerys.length];
		if ( drillEdgeQuerys.length > 0 )
		{
			for ( int i = 0; i < drillEdgeQuerys.length; i++ )
			{
				CubeQueryExecutor executor = new CubeQueryExecutor( this.outResults,
						drillEdgeQuerys[i],
						this.session,
						this.scope,
						this.context );
				viewsOnColumnEdge[i] = new BirtCubeView( executor, this.cube, appContext );
				viewsOnColumnEdge[i].getCubeCursor( stopSign, cube, false );
			}
		}
		return viewsOnColumnEdge;
	}

	public BirtCubeView[] getCubeViewOnRowEdge( ) throws DataException
	{
		if ( viewsOnRowEdge != null )
			return viewsOnRowEdge;
		ICubeQueryDefinition[] drillEdgeQuerys = CubeQueryDefinitionUtil.getCubeQueryFromDrills( query,
				cube,
				ICubeQueryDefinition.ROW_EDGE );

		viewsOnRowEdge = new BirtCubeView[drillEdgeQuerys.length];
		if ( drillEdgeQuerys.length > 0 )
		{
			for ( int i = 0; i < drillEdgeQuerys.length; i++ )
			{
				CubeQueryExecutor executor = new CubeQueryExecutor( this.outResults,
						drillEdgeQuerys[i],
						this.session,
						this.scope,
						this.context );
				viewsOnRowEdge[i] = new BirtCubeView( executor, this.cube, appContext );
				viewsOnRowEdge[i].getCubeCursor( stopSign, cube, false );
			}
		}
		return viewsOnRowEdge;
	}
	
	public BirtCubeView[] getCubeViewOnCrossEdge( ) throws DataException
	{
		if( this.viewsOnCross != null )
			return this.viewsOnCross;
		
		ICubeQueryDefinition[] drillEdgeQuerys = CubeQueryDefinitionUtil.getCrossCubeQueryFromDrills( query,
				cube );

		viewsOnCross = new BirtCubeView[drillEdgeQuerys.length];
		if ( drillEdgeQuerys.length > 0 )
		{
			for ( int i = 0; i < drillEdgeQuerys.length; i++ )
			{
				CubeQueryExecutor executor = new CubeQueryExecutor( this.outResults,
						drillEdgeQuerys[i],
						this.session,
						this.scope,
						this.context );
				viewsOnCross[i] = new BirtCubeView( executor, this.cube, appContext );
				viewsOnCross[i].getCubeCursor( stopSign, cube, false );
			}
		}
		return viewsOnCross;
	}
	
	public BirtCubeView[] getAllCubeViews( ) throws DataException
	{
		if( allViews!= null )
			return allViews;
		
		BirtCubeView[] views1 = this.getCubeViewOnColumnEdge( );
		BirtCubeView[] views2 = this.getCubeViewOnRowEdge( );
		BirtCubeView[] views3 = this.getCubeViewOnCrossEdge( );

		allViews = new BirtCubeView[views1.length
				+ views2.length + views3.length];
		
		int count = 0;
		for ( BirtCubeView view : views1 )
		{
			allViews[count] = view;
			count++;
		}
		for ( BirtCubeView view : views2 )
		{
			allViews[count] = view;
			count++;
		}
		for ( BirtCubeView view : views3 )
		{
			allViews[count] = view;
			count++;
		}
		return allViews;
	}
}
