/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;

public class CreateRole
extends DefineCommand {
    private String roleName;
    private boolean ifNotExists;

    public CreateRole(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (database.findUser(this.roleName) != null) {
            throw Message.getSQLException(90033, this.roleName);
        }
        if (database.findRole(this.roleName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90069, this.roleName);
        }
        int n = this.getObjectId(false, true);
        Role role = new Role(database, n, this.roleName, false);
        database.addDatabaseObject(this.session, role);
        return 0;
    }
}

