/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf.interfaces;

import java.util.List;

import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiDomain;

public interface ISbiDomainTransactions {
	
	public  SbiDomain getSbiDomainByCode(String code) throws Exception;
	
	public SbiDomain getDomainById(Integer id) throws Exception;
	
	public boolean createNewAlarm(final SbiAlarm alarm) throws Exception ;
	
	public List getDomainByDomainCd(final String domainCd) throws Exception;

	public SbiDomain getSbiDomainByCodeAndDomainCd(final String code, final String domainCd) throws Exception;


	
}
