/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Giulio Gavardi (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/ 
package org.eclipse.ebam.emf.utilities;

import java.net.URL;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConfigurationReader {
	
	private static BundleContext context = null; 
	
	/**
	 * Returns the configuration reader.
	 * 
	 * @param b - the Bundle Context
	 * @return the instance of configuration reader
	 */
	public static ConfigurationReader getInstance (BundleContext b){
		return new ConfigurationReader(b);
	}
	
	private ConfigurationReader(BundleContext b){
		context = b;
	}
	
	 /**
	  * Returns an URL.
	  * 
	 * @param path - String the path
	 * @return - URL 
	 */
	public static final  URL getFileURL(final String path) {
	        Bundle bundle = context.getBundle();
	        URL url = bundle.getEntry(path);
	        String s = url.getPath();
	        return url;
	    }
	
	 /**
	 * Resets the context.
	 */
	public void removeContext(){ context = null ;}

}
