/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.dialogs;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class PluginSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.pde.ui.dialogs.PluginSelectionDialog";
    private IPluginModelBase[] fModels;

    public PluginSelectionDialog(Shell parentShell, boolean includeFragments, boolean multipleSelection) {
        this(parentShell, PluginSelectionDialog.getElements(includeFragments), multipleSelection);
    }

    public PluginSelectionDialog(Shell parentShell, IPluginModelBase[] models, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        this.fModels = models;
        this.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        this.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setListLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.plugin_selection");
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    private static IPluginModelBase[] getElements(boolean includeFragments) {
        return PluginRegistry.getActiveModels((boolean)includeFragments);
    }

    public static HashSet getExistingImports(IPluginModelBase model, boolean includeImportPkg) {
        IFragment fragment;
        IPluginModelBase host;
        HashSet existingImports = new HashSet();
        PluginSelectionDialog.addSelfAndDirectImports(existingImports, model);
        if (model instanceof IFragmentModel && (host = PluginRegistry.findModel((String)(fragment = ((IFragmentModel)model).getFragment()).getPluginId())) instanceof IPluginModel) {
            PluginSelectionDialog.addSelfAndDirectImports(existingImports, host);
        }
        if (includeImportPkg && model instanceof IBundlePluginModelBase) {
            PluginSelectionDialog.addImportedPackages((IBundlePluginModelBase)model, existingImports);
        }
        return existingImports;
    }

    private static void addSelfAndDirectImports(HashSet set, IPluginModelBase model) {
        set.add(model.getPluginBase().getId());
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            String id = imports[i].getId();
            if (set.add(id)) {
                PluginSelectionDialog.addReexportedImport(set, id);
            }
            ++i;
        }
    }

    private static void addReexportedImport(HashSet set, String id) {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null) {
            IPluginImport[] imports = model.getPluginBase().getImports();
            int i = 0;
            while (i < imports.length) {
                if (imports[i].isReexported() && set.add(imports[i].getId())) {
                    PluginSelectionDialog.addReexportedImport(set, imports[i].getId());
                }
                ++i;
            }
        }
    }

    private static void addImportedPackages(IBundlePluginModelBase base, HashSet existingImports) {
        HashMap map = PluginSelectionDialog.getImportPackages(base);
        if (map == null) {
            return;
        }
        ExportPackageDescription[] exported = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
        int i = 0;
        while (i < exported.length) {
            ImportPackageObject ipo = (ImportPackageObject)map.get(exported[i].getName());
            if (ipo != null) {
                String version = ipo.getVersion();
                if (version != null) {
                    try {
                        if (!new VersionRange(version).isIncluded(exported[i].getVersion())) {
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    existingImports.add(exported[i].getSupplier().getSymbolicName());
                }
            }
            ++i;
        }
    }

    private static HashMap getImportPackages(IBundlePluginModelBase base) {
        ImportPackageHeader header;
        IBundleModel bmodel = base.getBundleModel();
        if (bmodel != null && (header = (ImportPackageHeader)bmodel.getBundle().getManifestHeader("Import-Package")) != null) {
            HashMap<String, ImportPackageObject> map = new HashMap<String, ImportPackageObject>();
            ImportPackageObject[] packages = header.getPackages();
            int i = 0;
            while (i < packages.length) {
                map.put(packages[i].getName(), packages[i]);
                ++i;
            }
            return map;
        }
        return null;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new PluginSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        int i = 0;
        while (i < this.fModels.length) {
            contentProvider.add((Object)this.fModels[i], itemsFilter);
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)item;
            return model.getPluginBase().getId();
        }
        return null;
    }

    protected Comparator getItemsComparator() {
        return new PluginSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    private class PluginSearchComparator
    implements Comparator {
        private PluginSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IPluginModelBase) {
                return 100;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IPluginModelBase && o2 instanceof IPluginModelBase) {
                IPluginModelBase ipmb1 = (IPluginModelBase)o1;
                IPluginModelBase ipmb2 = (IPluginModelBase)o2;
                return this.comparePlugins(ipmb1.getPluginBase(), ipmb2.getPluginBase());
            }
            return 0;
        }

        private int comparePlugins(IPluginBase ipmb1, IPluginBase ipmb2) {
            return ipmb1.getId().compareTo(ipmb2.getId());
        }
    }

    private class PluginSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private PluginSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)PluginSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)item;
                id = model.getPluginBase().getId();
            }
            return this.matches(id);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

