/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEProjectionSourcePage;

public abstract class KeyValueSourcePage
extends PDEProjectionSourcePage {
    public KeyValueSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public ViewerComparator createDefaultOutlineComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IDocumentKey && e2 instanceof IDocumentKey) {
                    IDocumentKey key1 = (IDocumentKey)e1;
                    IDocumentKey key2 = (IDocumentKey)e2;
                    return key1.getOffset() < key2.getOffset() ? -1 : 1;
                }
                return 0;
            }
        };
    }

    public void setHighlightRange(IDocumentKey key) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int offset = key.getOffset();
        int length = key.getLength();
        if (offset == -1 || length == -1) {
            return;
        }
        this.setHighlightRange(offset, length, true);
        int nameLength = PropertiesUtil.createWritableName((String)key.getName()).length();
        sourceViewer.setSelectedRange(offset, Math.min(nameLength, length));
    }

    public ViewerComparator createOutlineComparator() {
        return new ViewerComparator();
    }

    public boolean isQuickOutlineEnabled() {
        return true;
    }
}

