/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;

public class IllegalFieldReferenceDetector
extends AbstractProblemDetector {
    private Map fIllegalFields = new HashMap();
    private Map fFieldComponents = new HashMap();

    void addIllegalField(IFieldDescriptor field, String componentId) {
        this.fIllegalFields.put(new MethodKey(field.getEnclosingType().getQualifiedName(), field.getName(), null, true), field);
        this.fFieldComponents.put(field, componentId);
    }

    public boolean considerReference(IReference reference) {
        if (super.considerReference(reference) && this.fIllegalFields.containsKey(new MethodKey(reference.getReferencedTypeName(), reference.getReferencedMemberName(), reference.getReferencedSignature(), true))) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    public int getReferenceKinds() {
        return 30720;
    }

    protected int getProblemKind() {
        return 3;
    }

    protected String getSeverityKey() {
        return "ILLEGAL_REFERENCE";
    }

    protected int getProblemFlags(IReference reference) {
        return 9;
    }

    protected int getElementType(IReference reference) {
        return 5;
    }

    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiField field = (IApiField)reference.getResolvedReference();
        return new String[]{this.getSimpleTypeName(field), this.getSimpleTypeName(reference.getMember()), field.getName()};
    }

    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiField field = (IApiField)reference.getResolvedReference();
        return new String[]{this.getQualifiedTypeName(field), this.getQualifiedTypeName(reference.getMember()), field.getName()};
    }

    protected Position getSourceRange(IType type, IDocument document, IReference reference) throws CoreException, BadLocationException {
        return this.getFieldNameRange((IApiField)reference.getResolvedReference(), document, reference);
    }

    protected boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) {
            return false;
        }
        Object componentId = this.fFieldComponents.get(reference.getResolvedReference().getHandle());
        return this.isReferenceFromComponent(reference, componentId);
    }
}

