/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyCompositeHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2Delegate;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.eclipse.e4.ui.css.core.impl.dom.CSSRuleListImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleSheetImpl;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.core.impl.engine.CSSElementContextImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.core.util.impl.resources.ResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class AbstractCSSEngine
implements CSSEngine {
    private static final IResourcesLocatorManager defaultResourcesLocatorManager = ResourcesLocatorManager.INSTANCE;
    private ExtendedDocumentCSS documentCSS;
    private ViewCSS viewCSS;
    private IElementProvider elementProvider;
    protected boolean computeDefaultStyle = false;
    private Map elementsContext = null;
    private CSSErrorHandler errorHandler;
    private IResourcesLocatorManager resourcesLocatorManager;
    private IResourcesRegistry resourcesRegistry;
    private List propertyHandlerProviders = new ArrayList();
    private Map currentCSSPropertiesApplyed = new HashMap();
    private boolean throwError;
    private Map valueConverters = null;
    protected HashMap widgetsMap = new HashMap();
    private boolean parseImport;
    public HashMap propertyHandlerMap = new HashMap();

    public AbstractCSSEngine() {
        this(new DocumentCSSImpl());
    }

    public AbstractCSSEngine(ExtendedDocumentCSS documentCSS) {
        this.documentCSS = documentCSS;
        this.viewCSS = new ViewCSSImpl(documentCSS);
    }

    public StyleSheet parseStyleSheet(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseStyleSheet(source);
    }

    public StyleSheet parseStyleSheet(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseStyleSheet(source);
    }

    public StyleSheet parseStyleSheet(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        CSSStyleSheet styleSheet = parser.parseStyleSheet(source);
        CSSRuleList rules = styleSheet.getCssRules();
        int length = rules.getLength();
        CSSRuleListImpl masterList = new CSSRuleListImpl();
        int counter = 0;
        while (counter < length) {
            CSSRule rule = rules.item(counter);
            if (rule.getType() != 3) break;
            Path p = new Path(source.getURI());
            IPath trim = p.removeLastSegments(1);
            URL url = FileLocator.resolve((URL)new URL(String.valueOf(trim.addTrailingSeparator().toString()) + ((CSSImportRule)rule).getHref()));
            InputStream stream = url.openStream();
            InputSource tempStream = new InputSource();
            tempStream.setURI(url.toString());
            tempStream.setByteStream(stream);
            this.parseImport = true;
            styleSheet = (CSSStyleSheet)this.parseStyleSheet(tempStream);
            this.parseImport = false;
            CSSRuleList tempRules = styleSheet.getCssRules();
            int j = 0;
            while (j < tempRules.getLength()) {
                masterList.add(tempRules.item(j));
                ++j;
            }
            ++counter;
        }
        int i = counter;
        while (i < length) {
            masterList.add(rules.item(i));
            ++i;
        }
        CSSStyleSheetImpl s = new CSSStyleSheetImpl();
        s.setRuleList(masterList);
        if (this.documentCSS instanceof ExtendedDocumentCSS && !this.parseImport) {
            this.documentCSS.addStyleSheet(s);
        }
        return s;
    }

    private void checkInputSource(InputSource source) throws IOException {
        Reader reader = source.getCharacterStream();
        InputStream stream = source.getByteStream();
        if (reader == null && stream == null) {
            throw new IOException("CharacterStream or ByteStream cannot be null for the InputSource.");
        }
    }

    public CSSStyleDeclaration parseStyleDeclaration(String style) throws IOException {
        StringReader reader = new StringReader(style);
        return this.parseStyleDeclaration(reader);
    }

    public CSSStyleDeclaration parseStyleDeclaration(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseStyleDeclaration(source);
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseStyleDeclaration(source);
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        CSSStyleDeclaration styleDeclaration = parser.parseStyleDeclaration(source);
        return styleDeclaration;
    }

    public CSSValue parsePropertyValue(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parsePropertyValue(source);
    }

    public CSSValue parsePropertyValue(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parsePropertyValue(source);
    }

    public CSSValue parsePropertyValue(String value) throws IOException {
        StringReader reader = new StringReader(value);
        return this.parsePropertyValue(reader);
    }

    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        return parser.parsePropertyValue(source);
    }

    public void applyStyles(Object element, boolean applyStylesToChildNodes) {
        this.applyStyles(element, applyStylesToChildNodes, this.computeDefaultStyle);
    }

    public void applyStyles(Object element, boolean applyStylesToChildNodes, boolean computeDefaultStyle) {
        Element elt = this.getElement(element);
        if (elt != null) {
            NodeList nodes;
            String[] pseudoInstances;
            CSSStyleDeclaration style = this.viewCSS.getComputedStyle(elt, null);
            if (computeDefaultStyle) {
                if (applyStylesToChildNodes) {
                    this.computeDefaultStyle = computeDefaultStyle;
                }
                this.applyDefaultStyleDeclaration(element, false, style, null);
            }
            if ((pseudoInstances = this.getStaticPseudoInstances(elt)) != null) {
                int i = 0;
                while (i < pseudoInstances.length) {
                    String pseudoInstance = pseudoInstances[i];
                    CSSStyleDeclaration styleWithPseudoInstance = this.viewCSS.getComputedStyle(elt, pseudoInstance);
                    if (computeDefaultStyle) {
                        this.applyDefaultStyleDeclaration(element, false, styleWithPseudoInstance, pseudoInstance);
                    }
                    if (styleWithPseudoInstance != null) {
                        CSSRule parentRule = styleWithPseudoInstance.getParentRule();
                        if (parentRule instanceof ExtendedCSSRule) {
                            this.applyConditionalPseudoStyle((ExtendedCSSRule)parentRule, pseudoInstance, element, styleWithPseudoInstance);
                        } else {
                            this.applyStyleDeclaration(elt, styleWithPseudoInstance, pseudoInstance);
                        }
                    }
                    ++i;
                }
            }
            if (style != null) {
                this.applyStyleDeclaration(elt, style, null);
            }
            try {
                this.applyInlineStyle(elt, false);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.applyStyles(nodes.item(k), applyStylesToChildNodes);
                    ++k;
                }
                this.onStylesAppliedToChildNodes(elt, nodes);
            }
        }
    }

    private void applyConditionalPseudoStyle(ExtendedCSSRule parentRule, String pseudoInstance, Object element, CSSStyleDeclaration styleWithPseudoInstance) {
        SelectorList selectorList = parentRule.getSelectorList();
        int j = 0;
        while (j < selectorList.getLength()) {
            String value;
            Condition condition;
            Selector item = selectorList.item(j);
            if (item instanceof ConditionalSelector && (condition = ((ConditionalSelector)item).getCondition()) instanceof AttributeCondition && (value = ((AttributeCondition)condition).getValue()).equals(pseudoInstance)) {
                this.applyStyleDeclaration(element, styleWithPseudoInstance, pseudoInstance);
                return;
            }
            ++j;
        }
    }

    protected String[] getStaticPseudoInstances(Element element) {
        if (element instanceof CSSStylableElement) {
            CSSStylableElement stylableElement = (CSSStylableElement)element;
            return stylableElement.getStaticPseudoInstances();
        }
        return null;
    }

    protected void onStylesAppliedToChildNodes(Element element, NodeList nodes) {
        if (element instanceof CSSStylableElement) {
            ((CSSStylableElement)element).onStylesApplied(nodes);
        }
    }

    public void applyStyleDeclaration(Object element, CSSStyleDeclaration style, String pseudo) {
        this.currentCSSPropertiesApplyed.clear();
        ArrayList<ICSSPropertyHandler2> handlers2 = null;
        int i = 0;
        while (i < style.getLength()) {
            block13: {
                String property = style.item(i);
                CSSValue value = style.getPropertyCSSValue(property);
                try {
                    ICSSPropertyHandler handler = this.applyCSSProperty(element, property, value, pseudo);
                    ICSSPropertyHandler2 propertyHandler2 = null;
                    if (handler instanceof ICSSPropertyHandler2) {
                        propertyHandler2 = (ICSSPropertyHandler2)((Object)handler);
                    } else if (handler instanceof ICSSPropertyHandler2Delegate) {
                        propertyHandler2 = ((ICSSPropertyHandler2Delegate)((Object)handler)).getCSSPropertyHandler2();
                    }
                    if (propertyHandler2 != null) {
                        if (handlers2 == null) {
                            handlers2 = new ArrayList<ICSSPropertyHandler2>();
                        }
                        if (!handlers2.contains(propertyHandler2)) {
                            handlers2.add(propertyHandler2);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.throwError && (this.throwError || e instanceof UnsupportedPropertyException)) break block13;
                    this.handleExceptions(e);
                }
            }
            ++i;
        }
        if (handlers2 != null) {
            for (ICSSPropertyHandler2 handler2 : handlers2) {
                try {
                    handler2.onAllCSSPropertiesApplyed(element, this);
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                }
            }
        }
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, Reader reader) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(reader);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, InputStream stream) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(stream);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, InputSource source) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(source);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, String style) throws IOException {
        CSSStyleDeclaration styleDeclaration = this.parseStyleDeclaration(style);
        this.applyStyleDeclaration(node, styleDeclaration, null);
        return styleDeclaration;
    }

    public void applyInlineStyle(Object node, boolean applyStylesToChildNodes) throws IOException {
        Element elt = this.getElement(node);
        if (elt != null) {
            NodeList nodes;
            CSSStylableElement stylableElement;
            String style;
            if (elt instanceof CSSStylableElement && (style = (stylableElement = (CSSStylableElement)elt).getCSSStyle()) != null && style.length() > 0) {
                this.parseAndApplyStyleDeclaration(stylableElement.getNativeWidget(), style);
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.applyInlineStyle(nodes.item(k), applyStylesToChildNodes);
                    ++k;
                }
            }
        }
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object element, String pseudoE) {
        return this.getDefaultStyleDeclaration(element, null, pseudoE);
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object widget, CSSStyleDeclaration newStyle, String pseudoE) {
        CSSStyleDeclaration style = null;
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            try {
                style = provider.getDefaultCSSStyleDeclaration(this, widget, newStyle, pseudoE);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return style;
    }

    public void applyDefaultStyleDeclaration(Object element, boolean applyStylesToChildNodes) {
        this.applyDefaultStyleDeclaration(element, applyStylesToChildNodes, null, null);
    }

    public void applyDefaultStyleDeclaration(Object element, boolean applyStylesToChildNodes, CSSStyleDeclaration newStyle, String pseudoE) {
        Element elt = this.getElement(element);
        if (elt != null) {
            NodeList nodes;
            if (elt instanceof CSSStylableElement) {
                CSSStylableElement stylableElement = (CSSStylableElement)elt;
                CSSStyleDeclaration oldDefaultStyleDeclaration = stylableElement.getDefaultStyleDeclaration(pseudoE);
                CSSStyleDeclaration defaultStyleDeclaration = this.getDefaultStyleDeclaration(element, newStyle, pseudoE);
                if (oldDefaultStyleDeclaration != null) {
                    try {
                        this.throwError = false;
                        this.applyStyleDeclaration(element, defaultStyleDeclaration, pseudoE);
                    }
                    finally {
                        this.throwError = true;
                    }
                }
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.applyDefaultStyleDeclaration(nodes.item(k), applyStylesToChildNodes);
                    ++k;
                }
                this.onStylesAppliedToChildNodes(elt, nodes);
            }
        }
    }

    public ICSSPropertyHandler applyCSSProperty(Object widget, String property, CSSValue value, String pseudo) throws Exception {
        ICSSPropertyHandler handler;
        block9: {
            if (this.currentCSSPropertiesApplyed.containsKey(property)) {
                return null;
            }
            boolean found = false;
            handler = null;
            Object tmpMap = this.propertyHandlerMap.get(widget.getClass().getName());
            if (tmpMap != null && (handler = (ICSSPropertyHandler)((HashMap)tmpMap).get(property)) != null) {
                found = true;
            }
            if (!found) {
                Class<?> parentClass = widget.getClass().getSuperclass();
                do {
                    if ((tmpMap = this.propertyHandlerMap.get(parentClass.getName())) != null && (handler = (ICSSPropertyHandler)((HashMap)tmpMap).get(property)) != null) {
                        found = true;
                    }
                    parentClass = parentClass.getSuperclass();
                } while (!found && parentClass != ElementAdapter.class);
            }
            if (handler != null) {
                try {
                    boolean result = handler.applyCSSProperty(widget, property, value, pseudo, this);
                    if (result) {
                        this.currentCSSPropertiesApplyed.put(property, property);
                        return handler;
                    }
                }
                catch (Exception e) {
                    if (!this.throwError && (this.throwError || e instanceof UnsupportedPropertyException)) break block9;
                    this.handleExceptions(e);
                }
            }
        }
        return handler;
    }

    public String retrieveCSSProperty(Object widget, String property, String pseudo) {
        Collection handlers;
        block4: {
            handlers = this.getCSSPropertyHandlers(property);
            if (handlers != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler handler : handlers) {
                String value = handler.retrieveCSSProperty(widget, property, pseudo, this);
                if (StringUtils.isEmpty(value)) continue;
                return value;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        return null;
    }

    public String[] getCSSCompositePropertiesNames(String property) {
        Collection handlers;
        block4: {
            handlers = this.getCSSPropertyHandlers(property);
            if (handlers != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler handler : handlers) {
                ICSSPropertyCompositeHandler compositeHandler;
                if (!(handler instanceof ICSSPropertyCompositeHandler) || !(compositeHandler = (ICSSPropertyCompositeHandler)handler).isCSSPropertyComposite(property)) continue;
                return compositeHandler.getCSSPropertiesNames(property);
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        return null;
    }

    protected Collection getCSSPropertyHandlers(String property) throws Exception {
        Collection handlers = new ArrayList();
        for (HashMap tmp : this.propertyHandlerMap.values()) {
            Object o = tmp.get(property);
            if (o == null) continue;
            handlers.add(o);
        }
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            Collection h = provider.getCSSPropertyHandlers(property);
            if (handlers == null) {
                handlers = h;
                continue;
            }
            handlers = new ArrayList(handlers);
            handlers.addAll(h);
        }
        return handlers;
    }

    public IElementProvider getElementProvider() {
        return this.elementProvider;
    }

    public void setElementProvider(IElementProvider elementProvider) {
        this.elementProvider = elementProvider;
    }

    public Element getElement(Object element) {
        Element elt = null;
        CSSElementContext elementContext = this.getCSSElementContext(element);
        if (elementContext != null && !elementContext.elementMustBeRefreshed(this.elementProvider)) {
            return elementContext.getElement();
        }
        if (element instanceof Element) {
            elt = (Element)element;
        } else if (this.elementProvider != null) {
            elt = this.elementProvider.getElement(element, this);
        } else if (this.elementProvider == null) {
            Object tmp = this.widgetsMap.get(element.getClass().getName());
            if (tmp == null) {
                Class<?> parent = element.getClass();
                while ((tmp = this.widgetsMap.get((parent = parent.getSuperclass()).getName())) == null && parent != Object.class) {
                }
            }
            this.elementProvider = (IElementProvider)tmp;
            if (this.elementProvider != null) {
                elt = this.elementProvider.getElement(element, this);
            }
        }
        if (elt != null) {
            if (elementContext == null) {
                elementContext = new CSSElementContextImpl();
                Object nativeWidget = this.getNativeWidget(element);
                this.hookNativeWidget(nativeWidget);
                this.getElementsContext().put(nativeWidget, elementContext);
            }
            elementContext.setElementProvider(this.elementProvider);
            elementContext.setElement(elt);
            if (elt instanceof CSSStylableElement) {
                ((CSSStylableElement)elt).initialize();
            }
        }
        return elt;
    }

    protected void hookNativeWidget(Object widget) {
    }

    protected void handleWidgetDisposed(Object widget) {
        if (this.widgetsMap != null) {
            this.widgetsMap.remove(widget);
        }
        if (this.elementsContext != null) {
            this.elementsContext.remove(widget);
        }
    }

    public Object getDocument() {
        return null;
    }

    public CSSElementContext getCSSElementContext(Object element) {
        Object o = this.getNativeWidget(element);
        return (CSSElementContext)this.getElementsContext().get(o);
    }

    public Object getNativeWidget(Object element) {
        Object o = element;
        if (element instanceof CSSStylableElement) {
            o = ((CSSStylableElement)o).getNativeWidget();
        }
        return o;
    }

    protected Map getElementsContext() {
        if (this.elementsContext == null) {
            this.elementsContext = new HashMap();
        }
        return this.elementsContext;
    }

    public void handleExceptions(Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }

    public CSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CSSErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public IResourcesLocatorManager getResourcesLocatorManager() {
        if (this.resourcesLocatorManager == null) {
            return defaultResourcesLocatorManager;
        }
        return this.resourcesLocatorManager;
    }

    public void setResourcesLocatorManager(IResourcesLocatorManager resourcesLocatorManager) {
        this.resourcesLocatorManager = resourcesLocatorManager;
    }

    public DocumentCSS getDocumentCSS() {
        return this.documentCSS;
    }

    public ViewCSS getViewCSS() {
        return this.viewCSS;
    }

    public void dispose() {
        this.reset();
        Collection contexts = this.elementsContext.values();
        for (CSSElementContext context : contexts) {
            Element element = context.getElement();
            if (!(element instanceof CSSStylableElement)) continue;
            ((CSSStylableElement)element).dispose();
        }
        this.elementsContext = null;
        this.widgetsMap = null;
        if (this.resourcesRegistry != null) {
            this.resourcesRegistry.dispose();
        }
    }

    public void reset() {
        this.documentCSS.removeAllStyleSheets();
    }

    public IResourcesRegistry getResourcesRegistry() {
        return this.resourcesRegistry;
    }

    public void setResourcesRegistry(IResourcesRegistry resourcesRegistry) {
        this.resourcesRegistry = resourcesRegistry;
    }

    public void registerCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider handlerProvider) {
        this.propertyHandlerProviders.add(handlerProvider);
    }

    public void unregisterCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider handlerProvider) {
        this.propertyHandlerProviders.remove(handlerProvider);
    }

    public void registerCSSValueConverter(ICSSValueConverter converter) {
        if (this.valueConverters == null) {
            this.valueConverters = new HashMap();
        }
        this.valueConverters.put(converter.getToType(), converter);
    }

    public void unregisterCSSValueConverter(ICSSValueConverter converter) {
        if (this.valueConverters == null) {
            return;
        }
        this.valueConverters.remove(converter);
    }

    public ICSSValueConverter getCSSValueConverter(Object toType) {
        if (this.valueConverters != null) {
            return (ICSSValueConverter)this.valueConverters.get(toType);
        }
        return null;
    }

    public Object convert(CSSValue value, Object toType, Object context) throws Exception {
        ICSSValueConverter converter;
        Object newValue = null;
        String key = CSSResourcesHelpers.getCSSValueKey(value);
        IResourcesRegistry resourcesRegistry = this.getResourcesRegistry();
        if (resourcesRegistry != null && key != null) {
            newValue = resourcesRegistry.getResource(toType, key);
        }
        if (newValue == null && (converter = this.getCSSValueConverter(toType)) != null && (newValue = converter.convert(value, (CSSEngine)this, context)) != null && resourcesRegistry != null && key != null) {
            resourcesRegistry.registerResource(toType, key, newValue);
        }
        return newValue;
    }

    public String convert(Object value, Object toType, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        ICSSValueConverter converter = this.getCSSValueConverter(toType);
        if (converter != null) {
            return converter.convert(value, (CSSEngine)this, context);
        }
        return null;
    }

    public abstract CSSParser makeCSSParser();
}

