/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static Set getClassDependencies(String string, Set set) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ClassFileUtilities.computeClassDependencies(fileInputStream, set, hashSet2, hashSet);
        return hashSet;
    }

    private static void computeClassDependencies(InputStream inputStream, Set set, Set set2, Set set3) throws IOException {
        Iterator iterator = ClassFileUtilities.getClassDependencies(inputStream).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set2.contains(string)) continue;
            set2.add(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append('/').append(string).append(".class");
                String string3 = stringBuffer.toString();
                File file = new File(string3);
                if (!file.isFile()) continue;
                set3.add(string3);
                ClassFileUtilities.computeClassDependencies(new FileInputStream(file), set, set2, set3);
            }
        }
    }

    public static Set getClassDependencies(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dataInputStream.readInt();
        int n = dataInputStream.readShort();
        String[] stringArray = new String[n];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        int n2 = 1;
        while (n2 < n) {
            switch (dataInputStream.readByte() & 0xFF) {
                case 5: 
                case 6: {
                    dataInputStream.readLong();
                    ++n2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.readInt();
                    break;
                }
                case 7: {
                    hashSet.add(new Integer(dataInputStream.readShort() & 0xFFFF));
                    break;
                }
                case 8: {
                    dataInputStream.readShort();
                    break;
                }
                case 12: {
                    dataInputStream.readShort();
                    hashSet2.add(new Integer(dataInputStream.readShort() & 0xFFFF));
                    break;
                }
                case 1: {
                    stringArray[n2] = dataInputStream.readUTF();
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++n2;
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet3.add(stringArray[(Integer)iterator.next()]);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet3.addAll(ClassFileUtilities.getDescriptorClasses(stringArray[(Integer)iterator.next()]));
        }
        return hashSet3;
    }

    protected static Set getDescriptorClasses(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        char c = string.charAt(n);
        block0 : switch (c) {
            case '(': {
                StringBuffer stringBuffer;
                block14: while (true) {
                    c = string.charAt(++n);
                    switch (c) {
                        case '[': {
                            while ((c = string.charAt(++n)) == '[') {
                            }
                            if (c != 'L') continue block14;
                        }
                        case 'L': {
                            c = string.charAt(++n);
                            stringBuffer = new StringBuffer();
                            while (c != ';') {
                                stringBuffer.append(c);
                                c = string.charAt(++n);
                            }
                            hashSet.add(stringBuffer.toString());
                            continue block14;
                        }
                        default: {
                            continue block14;
                        }
                        case ')': 
                    }
                    break;
                }
                c = string.charAt(++n);
                switch (c) {
                    case '[': {
                        while ((c = string.charAt(++n)) == '[') {
                        }
                        if (c != 'L') break block0;
                    }
                    case 'L': {
                        c = string.charAt(++n);
                        stringBuffer = new StringBuffer();
                        while (c != ';') {
                            stringBuffer.append(c);
                            c = string.charAt(++n);
                        }
                        hashSet.add(stringBuffer.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c = string.charAt(++n)) == '[') {
                }
                if (c != 'L') break;
            }
            case 'L': {
                c = string.charAt(++n);
                StringBuffer stringBuffer = new StringBuffer();
                while (c != ';') {
                    stringBuffer.append(c);
                    c = string.charAt(++n);
                }
                hashSet.add(stringBuffer.toString());
                break;
            }
        }
        return hashSet;
    }
}

