/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.ContributedCleanUpTabPage;
import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.cleanup.ICleanUpConfigurationUI;
import org.eclipse.jdt.ui.cleanup.ICleanUpOptionsInitializer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpRegistry {
    private static final String EXTENSION_POINT_NAME = "cleanUps";
    private static final String CLEAN_UP_CONFIGURATION_ELEMENT_NAME = "cleanUp";
    private static final String TABPAGE_CONFIGURATION_ELEMENT_NAME = "cleanUpConfigurationUI";
    private static final String CLEAN_UP_INITIALIZER_CONFIGURATION_ELEMENT_NAME = "cleanUpOptionsInitializer";
    private static final String ATTRIBUTE_KIND_TYPE_SAVE_ACTION = "saveAction";
    private static final String ATTRIBUTE_KIND_TYPE_CLEAN_UP = "cleanUp";
    private CleanUpDescriptor[] fCleanUpDescriptors;
    private CleanUpTabPageDescriptor[] fPageDescriptors;
    private CleanUpInitializerDescriptor[] fCleanUpInitializerDescriptors;

    public synchronized ICleanUp[] createCleanUps() {
        return this.createCleanUps(null);
    }

    public synchronized ICleanUp[] createCleanUps(Set<String> ids) {
        this.ensureCleanUpsRegistered();
        ArrayList<ICleanUp> result = new ArrayList<ICleanUp>(this.fCleanUpDescriptors.length);
        int i = 0;
        while (i < this.fCleanUpDescriptors.length) {
            ICleanUp cleanUp;
            if ((ids == null || ids.contains(this.fCleanUpDescriptors[i].getId())) && (cleanUp = this.fCleanUpDescriptors[i].createCleanUp()) != null) {
                result.add(cleanUp);
            }
            ++i;
        }
        return result.toArray(new ICleanUp[result.size()]);
    }

    public synchronized CleanUpTabPageDescriptor[] getCleanUpTabPageDescriptors(int kind) {
        this.ensurePagesRegistered();
        ArrayList<CleanUpTabPageDescriptor> result = new ArrayList<CleanUpTabPageDescriptor>();
        int i = 0;
        while (i < this.fPageDescriptors.length) {
            if (this.fPageDescriptors[i].getKind() == kind) {
                result.add(this.fPageDescriptors[i]);
            }
            ++i;
        }
        return result.toArray(new CleanUpTabPageDescriptor[result.size()]);
    }

    public MapCleanUpOptions getDefaultOptions(int kind) {
        this.ensureCleanUpInitializersRegistered();
        CleanUpOptions options = new CleanUpOptions();
        int i = 0;
        while (i < this.fCleanUpInitializerDescriptors.length) {
            CleanUpInitializerDescriptor descriptor = this.fCleanUpInitializerDescriptors[i];
            if (descriptor.getKind() == kind) {
                descriptor.getOptionsInitializer().setDefaultOptions(options);
            }
            ++i;
        }
        MapCleanUpOptions mapCleanUpOptions = new MapCleanUpOptions();
        mapCleanUpOptions.addAll(options);
        return mapCleanUpOptions;
    }

    private synchronized void ensureCleanUpsRegistered() {
        if (this.fCleanUpDescriptors != null) {
            return;
        }
        ArrayList<CleanUpDescriptor> descriptors = new ArrayList<CleanUpDescriptor>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(JavaPlugin.getPluginId(), EXTENSION_POINT_NAME);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("cleanUp".equals(element.getName())) {
                descriptors.add(new CleanUpDescriptor(element));
            }
            ++i;
        }
        i = 0;
        while (i < descriptors.size()) {
            final CleanUpDescriptor cleanUpDescriptor = (CleanUpDescriptor)descriptors.get(i);
            final boolean[] disable = new boolean[1];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    ICleanUp cleanUp = cleanUpDescriptor.createCleanUp();
                    if (cleanUp == null) {
                        disable[0] = true;
                    } else {
                        cleanUp.setOptions(new CleanUpOptions());
                        String[] enbledSteps = cleanUp.getStepDescriptions();
                        if (enbledSteps != null && enbledSteps.length > 0) {
                            JavaPlugin.logErrorMessage(Messages.format(FixMessages.CleanUpRegistry_cleanUpAlwaysEnabled_error, new String[]{cleanUpDescriptor.getId(), cleanUpDescriptor.fElement.getContributor().getName()}));
                            disable[0] = true;
                        }
                    }
                }

                public void handleException(Throwable t) {
                    disable[0] = true;
                    String message = Messages.format(FixMessages.CleanUpRegistry_cleanUpCreation_error, new String[]{cleanUpDescriptor.getId(), cleanUpDescriptor.fElement.getContributor().getName()});
                    Status status = new Status(4, JavaPlugin.getPluginId(), 10001, message, t);
                    JavaPlugin.log((IStatus)status);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            if (disable[0]) {
                descriptors.remove(i--);
            }
            ++i;
        }
        this.fCleanUpDescriptors = descriptors.toArray(new CleanUpDescriptor[descriptors.size()]);
        CleanUpRegistry.sort(this.fCleanUpDescriptors);
    }

    private static void sort(CleanUpDescriptor[] data) {
        int lastSwapI = -1;
        int lastSwapJ = -1;
        int i = 0;
        while (i < data.length) {
            block8: {
                String runAfter = data[i].getRunAfter();
                if (runAfter != null) {
                    String jID;
                    int jStart;
                    int j = jStart = i + 1;
                    while (j < data.length) {
                        jID = data[j].getId();
                        if (runAfter.equals(jID)) {
                            if (lastSwapI == i && j >= lastSwapJ) {
                                JavaPlugin.logErrorMessage("Problem reading cleanUps extensions: cannot satisfy rule for '" + data[i].getId() + "' to runAfter '" + runAfter + "'");
                            } else {
                                lastSwapI = i;
                                lastSwapJ = j;
                                CleanUpRegistry.swap(data, i, j);
                                --i;
                            }
                            break block8;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < jStart) {
                        jID = data[j].getId();
                        if (!runAfter.equals(jID)) {
                            ++j;
                            continue;
                        }
                        break block8;
                    }
                    JavaPlugin.logErrorMessage("Problem reading cleanUps extensions: cannot satisfy rule for '" + data[i].getId() + "' to runAfter '" + runAfter + "' because the runAfter clean up does not exist.");
                }
            }
            ++i;
        }
    }

    private static void swap(CleanUpDescriptor[] data, int i, int j) {
        CleanUpDescriptor o = data[i];
        data[i] = data[j];
        data[j] = o;
    }

    private synchronized void ensurePagesRegistered() {
        if (this.fPageDescriptors != null) {
            return;
        }
        ArrayList<CleanUpTabPageDescriptor> result = new ArrayList<CleanUpTabPageDescriptor>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(JavaPlugin.getPluginId(), EXTENSION_POINT_NAME);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (TABPAGE_CONFIGURATION_ELEMENT_NAME.equals(element.getName())) {
                result.add(new CleanUpTabPageDescriptor(element));
            }
            ++i;
        }
        this.fPageDescriptors = result.toArray(new CleanUpTabPageDescriptor[result.size()]);
        Arrays.sort(this.fPageDescriptors, new Comparator<CleanUpTabPageDescriptor>(){

            @Override
            public int compare(CleanUpTabPageDescriptor o1, CleanUpTabPageDescriptor o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return Collator.getInstance().compare(name1.replaceAll("&", ""), name2.replaceAll("&", ""));
            }
        });
    }

    private synchronized void ensureCleanUpInitializersRegistered() {
        if (this.fCleanUpInitializerDescriptors != null) {
            return;
        }
        ArrayList<CleanUpInitializerDescriptor> result = new ArrayList<CleanUpInitializerDescriptor>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(JavaPlugin.getPluginId(), EXTENSION_POINT_NAME);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CLEAN_UP_INITIALIZER_CONFIGURATION_ELEMENT_NAME.equals(element.getName())) {
                result.add(new CleanUpInitializerDescriptor(element));
            }
            ++i;
        }
        this.fCleanUpInitializerDescriptors = result.toArray(new CleanUpInitializerDescriptor[result.size()]);
    }

    private static int getCleanUpKind(String kind) {
        if (kind.equals("cleanUp")) {
            return 1;
        }
        if (kind.equals(ATTRIBUTE_KIND_TYPE_SAVE_ACTION)) {
            return 2;
        }
        return -1;
    }

    private static class CleanUpDescriptor {
        private static final String ATTRIBUTE_ID_CLASS = "class";
        private static final String ATTRIBURE_ID_RUNAFTER = "runAfter";
        private static final String ATTRIBUTE_ID_ID = "id";
        private final IConfigurationElement fElement;
        private final String fId;
        private final String fRunAfter;

        public CleanUpDescriptor(IConfigurationElement element) {
            this.fElement = element;
            this.fId = element.getAttribute(ATTRIBUTE_ID_ID);
            this.fRunAfter = element.getAttribute(ATTRIBURE_ID_RUNAFTER);
        }

        public String getId() {
            return this.fId;
        }

        public String getRunAfter() {
            return this.fRunAfter;
        }

        public ICleanUp createCleanUp() {
            try {
                return (ICleanUp)this.fElement.createExecutableExtension(ATTRIBUTE_ID_CLASS);
            }
            catch (CoreException e) {
                String msg = Messages.format(FixMessages.CleanUpRegistry_cleanUpCreation_error, new String[]{this.fElement.getAttribute(ATTRIBUTE_ID_ID), this.fElement.getContributor().getName()});
                JavaPlugin.logErrorStatus(msg, e.getStatus());
                return null;
            }
        }
    }

    private static final class CleanUpInitializerDescriptor {
        private static final String ATTRIBUTE_NAME_CLASS = "class";
        private static final String ATTRIBUTE_NAME_KIND = "cleanUpKind";
        private final IConfigurationElement fElement;
        private final int fKind;
        private ICleanUpOptionsInitializer fOptionsProvider;

        public CleanUpInitializerDescriptor(IConfigurationElement element) {
            this.fElement = element;
            String kind = this.fElement.getAttribute(ATTRIBUTE_NAME_KIND);
            this.fKind = CleanUpRegistry.getCleanUpKind(kind);
            if (this.fKind == -1) {
                JavaPlugin.logErrorMessage(Messages.format(FixMessages.CleanUpRegistry_UnknownInitializerKind_errorMessage, new String[]{element.getContributor().getName(), kind}));
            }
        }

        public int getKind() {
            return this.fKind;
        }

        public ICleanUpOptionsInitializer getOptionsInitializer() {
            if (this.fOptionsProvider == null) {
                try {
                    this.fOptionsProvider = (ICleanUpOptionsInitializer)this.fElement.createExecutableExtension(ATTRIBUTE_NAME_CLASS);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    this.fOptionsProvider = new ICleanUpOptionsInitializer(){

                        public void setDefaultOptions(CleanUpOptions options) {
                        }
                    };
                }
            }
            return this.fOptionsProvider;
        }
    }

    public static class CleanUpTabPageDescriptor {
        private static final String ATTRIBUTE_ID_CLASS = "class";
        private static final String ATTRIBUTE_ID_NAME = "name";
        private static final String ATTRIBUTE_NAME_KIND = "cleanUpKind";
        private final String fName;
        private final IConfigurationElement fElement;
        private int fKind;

        public CleanUpTabPageDescriptor(IConfigurationElement element) {
            this.fElement = element;
            this.fName = element.getAttribute(ATTRIBUTE_ID_NAME);
            String kind = this.fElement.getAttribute(ATTRIBUTE_NAME_KIND);
            this.fKind = CleanUpRegistry.getCleanUpKind(kind);
            if (this.fKind == -1) {
                JavaPlugin.logErrorMessage(Messages.format(FixMessages.CleanUpRegistry_WrongKindForConfigurationUI_error, new String[]{this.fName, element.getContributor().getName(), kind}));
            }
        }

        public String getName() {
            return this.fName;
        }

        public int getKind() {
            return this.fKind;
        }

        public CleanUpTabPage createTabPage() {
            try {
                ICleanUpConfigurationUI page = (ICleanUpConfigurationUI)this.fElement.createExecutableExtension(ATTRIBUTE_ID_CLASS);
                if (page instanceof CleanUpTabPage) {
                    return (CleanUpTabPage)page;
                }
                return new ContributedCleanUpTabPage(page);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return new ContributedCleanUpTabPage(new ErrorPage((Exception)((Object)e)));
            }
        }
    }

    private static final class ErrorPage
    implements ICleanUpConfigurationUI {
        private final Exception fException;

        private ErrorPage(Exception e) {
            this.fException = e;
        }

        public Composite createContents(Composite parent) {
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)new GridData(4, 4, true, true));
            result.setLayout((Layout)new GridLayout(1, false));
            Text text = new Text(result, 2058);
            text.setLayoutData((Object)new GridData(4, 128, true, false));
            text.setText(Messages.format(FixMessages.CleanUpRegistry_ErrorTabPage_description, this.fException.getLocalizedMessage()));
            return result;
        }

        public int getCleanUpCount() {
            return 0;
        }

        public String getPreview() {
            return FixMessages.CleanUpRegistry_ErrorTabPage_preview;
        }

        public int getSelectedCleanUpCount() {
            return 0;
        }

        public void setOptions(CleanUpOptions options) {
        }
    }
}

