/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class JavaElementTransfer
extends ByteArrayTransfer {
    private static final JavaElementTransfer fInstance = new JavaElementTransfer();
    private static final String TYPE_NAME = "java-element-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)fInstance)).hashCode();
    private static final int TYPEID = JavaElementTransfer.registerType((String)TYPE_NAME);

    private JavaElementTransfer() {
    }

    public static JavaElementTransfer getInstance() {
        return fInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IJavaElement[])) {
            return;
        }
        IJavaElement[] javaElements = (IJavaElement[])data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(javaElements.length);
            int i = 0;
            while (i < javaElements.length) {
                JavaElementTransfer.writeJavaElement(dataOut, javaElements[i]);
                ++i;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IJavaElement[] results = new IJavaElement[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readJavaElement(in);
                ++i;
            }
            return results;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IJavaElement readJavaElement(DataInputStream dataIn) throws IOException {
        String handleIdentifier = dataIn.readUTF();
        return JavaCore.create((String)handleIdentifier);
    }

    private static void writeJavaElement(DataOutputStream dataOut, IJavaElement element) throws IOException {
        dataOut.writeUTF(element.getHandleIdentifier());
    }
}

