/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.CopyQualifiedNameAction;
import org.eclipse.jdt.internal.ui.actions.FoldingActionGroup;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.ClipboardOperationAction;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.GotoMatchingBracketAction;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorBreadcrumb;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSelectMarkerRulerAction2;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.OverrideIndicatorManager;
import org.eclipse.jdt.internal.ui.javaeditor.RemoveOccurrenceAnnotations;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.jdt.internal.ui.javaeditor.ShowInBreadcrumbAction;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.EditorBreadcrumb;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.IBreadcrumb;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.GoToNextPreviousMemberAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectEnclosingAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectHistoryAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectNextAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectPreviousAction;
import org.eclipse.jdt.internal.ui.search.BreakContinueTargetFinder;
import org.eclipse.jdt.internal.ui.search.ExceptionOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.ImplementOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.MethodExitsFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.jdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.jdt.internal.ui.text.JavaChangeHover;
import org.eclipse.jdt.internal.ui.text.JavaPairMatcher;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.JavaWordIterator;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaExpandHover;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProviderExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.service.prefs.BackingStoreException;

public abstract class JavaEditor
extends AbstractDecoratedTextEditor
implements IViewPartInputProvider {
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String EDITOR_SHOW_BREADCRUMB = "breadcrumb";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected JavaOutlinePage fOutlinePage;
    protected String fOutlinerContextMenuId;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    protected AbstractSelectionChangedListener fOutlineSelectionChangedListener = new AbstractSelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
        }

        public void install(ISelectionProvider selectionProvider) {
        }
    };
    protected JavaPairMatcher fBracketMatcher = new JavaPairMatcher(BRACKETS);
    private DefaultEncodingSupport fEncodingSupport;
    private SelectionHistory fSelectionHistory;
    protected CompositeActionGroup fActionGroups;
    private FoldingActionGroup fFoldingGroup;
    private CompositeActionGroup fContextMenuGroup;
    private Annotation[] fOccurrenceAnnotations = null;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fIsBreadcrumbVisible;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkTypeOccurrences;
    private boolean fMarkMethodOccurrences;
    private boolean fMarkConstantOccurrences;
    private boolean fMarkFieldOccurrences;
    private boolean fMarkLocalVariableypeOccurrences;
    private boolean fMarkExceptions;
    private boolean fMarkMethodExitPoints;
    private boolean fMarkBreakContinueTargets;
    private boolean fMarkImplementors;
    private ISelection fForcedMarkOccurrencesSelection;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private ActivationListener fActivationListener = new ActivationListener();
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ProjectionSupport fProjectionSupport;
    private IJavaFoldingStructureProvider fProjectionModelUpdater;
    protected OverrideIndicatorManager fOverrideIndicatorManager;
    protected SemanticHighlightingManager fSemanticManager;
    private ToggleFoldingRunner fFoldingRunner;
    private boolean fSelectionChangedViaGotoAnnotation;
    private Point fCachedSelectedRange;
    private IBreadcrumb fBreadcrumb;
    private Composite fBreadcrumbComposite;
    private AbstractTextEditor.SelectionProvider fSelectionProvider = new JdtSelectionProvider();
    private long fErrorMessageTime;
    private static final long ERROR_MESSAGE_TIMEOUT = 1000L;

    protected abstract IJavaElement getElementAt(int var1);

    protected abstract IJavaElement getCorrespondingElement(IJavaElement var1);

    protected void setOutlinePageInput(JavaOutlinePage page, IEditorInput input) {
        if (page == null) {
            return;
        }
        ITypeRoot je = this.getInputJavaElement();
        if (je != null && je.exists()) {
            page.setInput((IJavaElement)je);
        } else {
            page.setInput(null);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.jdt.ui.javaEditorScope"});
    }

    protected void initializeEditor() {
    }

    protected JavaSourceViewerConfiguration createJavaSourceViewerConfiguration() {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return new JavaSourceViewerConfiguration(textTools.getColorManager(), this.getPreferenceStore(), (ITextEditor)this, "___java_partitioning");
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.fBreadcrumbComposite = new Composite(composite, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        this.fBreadcrumbComposite.setLayoutData((Object)layoutData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layoutData.exclude = true;
        this.fBreadcrumbComposite.setLayout((Layout)layout);
        Composite editorComposite = new Composite(composite, 0);
        editorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 0;
        editorComposite.setLayout((Layout)fillLayout);
        IPreferenceStore store = this.getPreferenceStore();
        ISourceViewer sourceViewer = this.createJavaSourceViewer(editorComposite, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
        JavaUIHelp.setHelp(this, sourceViewer.getTextWidget(), "org.eclipse.jdt.ui.java_editor_context");
        if (sourceViewer instanceof JavaSourceViewer && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.jdt.ui.editor.showSegments"))) {
            ((JavaSourceViewer)sourceViewer).prepareDelayedProjection();
        }
        if (sourceViewer instanceof ProjectionViewer) {
            this.fProjectionSupport = new ProjectionSupport((ProjectionViewer)sourceViewer, this.getAnnotationAccess(), this.getSharedColors());
            MarkerAnnotationPreferences markerAnnotationPreferences = (MarkerAnnotationPreferences)this.getAdapter(MarkerAnnotationPreferences.class);
            if (markerAnnotationPreferences != null) {
                for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
                    Object annotationType = annotationPreference.getAnnotationType();
                    if (!(annotationType instanceof String)) continue;
                    this.fProjectionSupport.addSummarizableAnnotationType((String)annotationType);
                }
            } else {
                this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
                this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
            }
            this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new SourceViewerInformationControl(shell, false, JavaEditor.this.getOrientation(), EditorsUI.getTooltipAffordanceString());
                }
            });
            this.fProjectionSupport.setInformationPresenterControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new SourceViewerInformationControl(shell, true, JavaEditor.this.getOrientation(), null);
                }
            });
            this.fProjectionSupport.install();
            this.fProjectionModelUpdater = JavaPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
            if (this.fProjectionModelUpdater != null) {
                this.fProjectionModelUpdater.install((ITextEditor)this, (ProjectionViewer)sourceViewer);
            }
        }
        this.getSourceViewerDecorationSupport(sourceViewer);
        return sourceViewer;
    }

    protected IBreadcrumb createBreadcrumb() {
        return new JavaEditorBreadcrumb(this);
    }

    public IBreadcrumb getBreadcrumb() {
        return this.fBreadcrumb;
    }

    String getBreadcrumbPreferenceKey() {
        IPerspectiveDescriptor perspective = this.getSite().getPage().getPerspective();
        if (perspective == null) {
            return null;
        }
        return "breadcrumb." + perspective.getId();
    }

    public boolean isBreadcrumbActive() {
        return this.fBreadcrumb != null && this.fBreadcrumb.isActive();
    }

    private void showBreadcrumb() {
        if (this.fBreadcrumb == null) {
            return;
        }
        if (this.fBreadcrumbComposite.getChildren().length == 0) {
            this.fBreadcrumb.createContent(this.fBreadcrumbComposite);
        }
        ((GridData)this.fBreadcrumbComposite.getLayoutData()).exclude = false;
        this.fBreadcrumbComposite.setVisible(true);
        ISourceReference selection = this.computeHighlightRangeSourceReference();
        if (selection == null) {
            selection = this.getInputJavaElement();
        }
        this.setBreadcrumbInput(selection);
        this.fBreadcrumbComposite.getParent().layout(true, true);
    }

    private void hideBreadcrumb() {
        if (this.fBreadcrumb == null) {
            return;
        }
        ((GridData)this.fBreadcrumbComposite.getLayoutData()).exclude = true;
        this.fBreadcrumbComposite.setVisible(false);
        this.fBreadcrumbComposite.getParent().layout(true, true);
    }

    private void setBreadcrumbInput(ISourceReference element) {
        if (this.fBreadcrumb == null) {
            return;
        }
        this.fBreadcrumb.setInput(element);
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new JavaSourceViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((JavaSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        IJavaProject project = EditorUtility.getJavaProject(input);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.jdt.core"));
        }
        stores.add(JavaPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(JavaPlugin.getJavaCorePluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        stores.add(PlatformUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
        IAction action = this.getAction("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb");
        menu.appendToGroup("group.open", action);
        action = this.getAction("org.eclipse.jdt.ui.edit.text.java.show.outline");
        menu.appendToGroup("group.open", action);
        action = this.getAction("org.eclipse.jdt.ui.edit.text.java.open.hierarchy");
        menu.appendToGroup("group.open", action);
        action = this.getAction("copyQualifiedName");
        if (menu.find(ITextEditorActionConstants.COPY) != null) {
            menu.insertAfter(ITextEditorActionConstants.COPY, action);
        } else {
            this.addAction(menu, "group.copy", "copyQualifiedName");
        }
    }

    protected JavaOutlinePage createOutlinePage() {
        JavaOutlinePage page = new JavaOutlinePage(this.fOutlinerContextMenuId, this);
        this.setOutlinePageInput(page, this.getEditorInput());
        return page;
    }

    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void synchronizeOutlinePage(ISourceReference element) {
        this.synchronizeOutlinePage(element, true);
    }

    protected void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || element == null || checkIfOutlinePageActive && this.isJavaOutlinePageActive())) {
            this.fOutlinePage.select(element);
        }
    }

    public void synchronizeOutlinePageSelection() {
        this.synchronizeOutlinePage(this.computeHighlightRangeSourceReference());
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createOutlinePage();
            }
            return this.fOutlinePage;
        }
        if (IEncodingSupport.class.equals((Object)required)) {
            return this.fEncodingSupport;
        }
        if (required == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (required == IShowInSource.class) {
            ITypeRoot inputJE = this.getInputJavaElement();
            if (inputJE instanceof ICompilationUnit && !JavaModelUtil.isPrimary((ICompilationUnit)inputJE)) {
                return null;
            }
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, null){

                        public Object getInput() {
                            if (JavaEditor.this.isBreadcrumbActive()) {
                                return null;
                            }
                            return JavaEditor.this.getEditorInput();
                        }

                        public ISelection getSelection() {
                            if (JavaEditor.this.isBreadcrumbActive()) {
                                return JavaEditor.this.getBreadcrumb().getSelectionProvider().getSelection();
                            }
                            try {
                                IJavaElement je = SelectionConverter.getElementAtOffset(JavaEditor.this);
                                if (je != null) {
                                    return new StructuredSelection((Object)je);
                                }
                                return null;
                            }
                            catch (JavaModelException javaModelException) {
                                return null;
                            }
                        }
                    };
                }
            };
        }
        if (required == IJavaFoldingStructureProvider.class) {
            return this.fProjectionModelUpdater;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        if (required == IContextProvider.class) {
            if (this.isBreadcrumbActive()) {
                return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.jdt.ui.java_editor_breadcrumb_context");
            }
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.jdt.ui.java_editor_context");
        }
        return super.getAdapter(required);
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        ISourceReference element = this.computeHighlightRangeSourceReference();
        if (this.getPreferenceStore().getBoolean("JavaEditor.SyncOutlineOnCursorMove")) {
            this.synchronizeOutlinePage(element);
        }
        if (this.fIsBreadcrumbVisible && this.fBreadcrumb != null && !this.fBreadcrumb.isActive()) {
            this.setBreadcrumbInput(element);
        }
        this.setSelection(element, false);
        if (!this.fSelectionChangedViaGotoAnnotation) {
            this.updateStatusLine();
        }
        this.fSelectionChangedViaGotoAnnotation = false;
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block21: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    ISourceRange range = null;
                    if (reference instanceof ILocalVariable || reference instanceof ITypeParameter || reference instanceof IAnnotation) {
                        IJavaElement je = ((IJavaElement)reference).getParent();
                        if (je instanceof ISourceReference) {
                            range = ((ISourceReference)je).getSourceRange();
                        }
                    } else {
                        range = reference.getSourceRange();
                    }
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    range = reference.getNameRange();
                    if (range != null) {
                        offset = range.getOffset();
                        length = range.getLength();
                    }
                    if (offset <= -1 || length <= 0) break block21;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (JavaModelException javaModelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    public void setFocus() {
        if (this.fBreadcrumb != null && this.fBreadcrumb.isActive()) {
            this.fBreadcrumb.activate();
            return;
        }
        super.setFocus();
    }

    public void setSelection(IJavaElement element) {
        if (element == null || element instanceof ICompilationUnit || element instanceof IClassFile) {
            return;
        }
        IJavaElement corresponding = this.getCorrespondingElement(element);
        if (corresponding instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)corresponding;
            this.setSelection(reference, true);
            if (this.fOutlinePage != null) {
                this.fOutlinePage.select(reference);
            }
        }
    }

    protected void doSelectionChanged(ISelection selection) {
        ISourceReference reference = null;
        for (Object o : (IStructuredSelection)selection) {
            if (!(o instanceof ISourceReference)) continue;
            reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && JavaPlugin.getActivePage() != null) {
            JavaPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(reference, !this.isActivePart());
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection textSelection = selectionProvider.getSelection();
        if (!(textSelection instanceof ITextSelection)) {
            return;
        }
        ITypeRoot inputJavaElement = this.getInputJavaElement();
        if (inputJavaElement == null) {
            return;
        }
        CompilationUnit ast = SharedASTProvider.getAST(inputJavaElement, SharedASTProvider.WAIT_NO, this.getProgressMonitor());
        if (ast != null) {
            this.fForcedMarkOccurrencesSelection = textSelection;
            this.updateOccurrenceAnnotations((ITextSelection)textSelection, ast);
        }
    }

    protected void adjustHighlightRange(int offset, int length) {
        try {
            IJavaElement element = this.getElementAt(offset, false);
            while (element instanceof ISourceReference) {
                ISourceRange range = ((ISourceReference)element).getSourceRange();
                if (range != null && offset < range.getOffset() + range.getLength() && range.getOffset() < offset + length) {
                    ISourceViewer viewer = this.getSourceViewer();
                    if (viewer instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                        extension.exposeModelRange((IRegion)new Region(range.getOffset(), range.getLength()));
                    }
                    this.setHighlightRange(range.getOffset(), range.getLength(), true);
                    if (this.fOutlinePage != null) {
                        this.fOutlinePage.select((ISourceReference)element);
                    }
                    return;
                }
                element = element.getParent();
            }
        }
        catch (JavaModelException x) {
            JavaPlugin.log(x.getStatus());
        }
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else {
            this.resetHighlightRange();
        }
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    private boolean isJavaOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (!(sourceViewer instanceof ISourceViewerExtension2)) {
            this.setPreferenceStore(this.createCombinedPreferenceStore(input));
            this.internalDoSetInput(input);
            return;
        }
        this.getSourceViewerDecorationSupport(sourceViewer).uninstall();
        ((ISourceViewerExtension2)sourceViewer).unconfigure();
        this.setPreferenceStore(this.createCombinedPreferenceStore(input));
        sourceViewer.configure(this.getSourceViewerConfiguration());
        this.getSourceViewerDecorationSupport(sourceViewer).install(this.getPreferenceStore());
        this.internalDoSetInput(input);
    }

    private void internalDoSetInput(IEditorInput input) throws CoreException {
        IReconciler reconciler;
        ISourceViewer sourceViewer = this.getSourceViewer();
        JavaSourceViewer javaSourceViewer = null;
        if (sourceViewer instanceof JavaSourceViewer) {
            javaSourceViewer = (JavaSourceViewer)sourceViewer;
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (javaSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.jdt.ui.editor.showSegments"))) {
            javaSourceViewer.prepareDelayedProjection();
        }
        super.doSetInput(input);
        if (javaSourceViewer != null && javaSourceViewer.getReconciler() == null && (reconciler = this.getSourceViewerConfiguration().getReconciler((ISourceViewer)javaSourceViewer)) != null) {
            reconciler.install((ITextViewer)javaSourceViewer);
            javaSourceViewer.setReconciler(reconciler);
        }
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
        this.setOutlinePageInput(this.fOutlinePage, input);
        if (this.isShowingOverrideIndicators()) {
            this.installOverrideIndicator(false);
        }
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration == null || sourceViewerConfiguration instanceof JavaSourceViewerConfiguration) {
            JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new JavaSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___java_partitioning"));
        }
        if (this.getSourceViewer() instanceof JavaSourceViewer) {
            ((JavaSourceViewer)this.getSourceViewer()).setPreferenceStore(store);
        }
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.fMarkTypeOccurrences = store.getBoolean("markTypeOccurrences");
        this.fMarkMethodOccurrences = store.getBoolean("markMethodOccurrences");
        this.fMarkConstantOccurrences = store.getBoolean("markConstantOccurrences");
        this.fMarkFieldOccurrences = store.getBoolean("markFieldOccurrences");
        this.fMarkLocalVariableypeOccurrences = store.getBoolean("markLocalVariableOccurrences");
        this.fMarkExceptions = store.getBoolean("markExceptionOccurrences");
        this.fMarkImplementors = store.getBoolean("markImplementors");
        this.fMarkMethodExitPoints = store.getBoolean("markMethodExitPoints");
        this.fMarkBreakContinueTargets = store.getBoolean("markBreakContinueTargets");
    }

    public void dispose() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        this.uninstallOverrideIndicator();
        this.uninstallSemanticHighlighting();
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fSelectionHistory != null) {
            this.fSelectionHistory.dispose();
            this.fSelectionHistory = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        if (this.fBreadcrumb != null) {
            this.fBreadcrumb.dispose();
            this.fBreadcrumb = null;
        }
        super.dispose();
        this.fSelectionProvider = null;
    }

    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
        ActionGroup[] actionGroupArray = new ActionGroup[3];
        OpenEditorActionGroup oeg = new OpenEditorActionGroup(this);
        actionGroupArray[0] = oeg;
        OpenViewActionGroup ovg = new OpenViewActionGroup(this);
        actionGroupArray[1] = ovg;
        JavaSearchActionGroup jsg = new JavaSearchActionGroup(this);
        actionGroupArray[2] = jsg;
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{oeg, ovg, jsg});
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer());
        Object action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new ShowInBreadcrumbAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb", (IAction)action);
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "ShowOutline.", (ITextEditor)this, 51, true);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.outline");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.show.outline", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.jdt.ui.show_outline_action");
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "OpenStructure.", (ITextEditor)this, 52, true);
        action.setActionDefinitionId("org.eclipse.jdt.ui.navigate.java.open.structure");
        this.setAction("org.eclipse.jdt.ui.navigate.java.open.structure", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.jdt.ui.open_structure_action");
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "OpenHierarchy.", (ITextEditor)this, 53, true);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.hierarchy");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.open.hierarchy", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.jdt.ui.open_hierarchy_action");
        this.fSelectionHistory = new SelectionHistory(this);
        action = new StructureSelectEnclosingAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        this.setAction("SelectEnclosingElement", (IAction)action);
        action = new StructureSelectNextAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.next");
        this.setAction("SelectNextElement", (IAction)action);
        action = new StructureSelectPreviousAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.previous");
        this.setAction("SelectPreviousElement", (IAction)action);
        StructureSelectHistoryAction historyAction = new StructureSelectHistoryAction(this, this.fSelectionHistory);
        historyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.last");
        this.setAction("RestoreLastSelection", (IAction)historyAction);
        this.fSelectionHistory.setHistoryAction(historyAction);
        action = GoToNextPreviousMemberAction.newGoToNextMemberAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.next.member");
        this.setAction("GoToNextMember", (IAction)action);
        action = GoToNextPreviousMemberAction.newGoToPreviousMemberAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.previous.member");
        this.setAction("GoToPreviousMember", (IAction)action);
        action = new FormatElementAction();
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.quick.format");
        this.setAction("QuickFormat", (IAction)action);
        this.markAsStateDependentAction("QuickFormat", true);
        action = new RemoveOccurrenceAnnotations(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.remove.occurrence.annotations");
        this.setAction("RemoveOccurrenceAnnotations", (IAction)action);
        action = new JavaSelectMarkerRulerAction2(JavaEditorMessages.getBundleForConstructedKeys(), "Editor.RulerAnnotationSelection.", (ITextEditor)this);
        this.setAction("AnnotationAction", (IAction)action);
        this.createDeprecatedShowInPackageExplorerAction();
        action = new ClipboardOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "Editor.Cut.", (ITextEditor)this, 3);
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        action = new ClipboardOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "Editor.Copy.", (ITextEditor)this, 4);
        this.setAction(ITextEditorActionConstants.COPY, (IAction)action);
        action = new ClipboardOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "Editor.Paste.", (ITextEditor)this, 5);
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new CopyQualifiedNameAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.copy.qualified.name");
        action.setImageDescriptor(null);
        this.setAction("copyQualifiedName", (IAction)action);
    }

    private void createDeprecatedShowInPackageExplorerAction() {
        ShowInPackageViewAction action = new ShowInPackageViewAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.in.package.view");
        this.setAction("ShowInPackageView", (IAction)action);
    }

    protected void setActionsActivated(boolean state) {
        Method method = null;
        try {
            method = AbstractTextEditor.class.getDeclaredMethod("setActionActivation", Boolean.TYPE);
        }
        catch (SecurityException ex) {
            JavaPlugin.log(ex);
        }
        catch (NoSuchMethodException ex) {
            JavaPlugin.log(ex);
        }
        Assert.isNotNull(method);
        method.setAccessible(true);
        try {
            method.invoke((Object)this, new Boolean(state));
        }
        catch (IllegalArgumentException ex) {
            JavaPlugin.log(ex);
        }
        catch (InvocationTargetException ex) {
            JavaPlugin.log(ex);
        }
        catch (IllegalAccessException ex) {
            JavaPlugin.log(ex);
        }
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize((StatusTextEditor)this);
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            return;
        }
        try {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            if (this.isJavaEditorHoverProperty(property)) {
                this.updateHoverBehavior();
            }
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if ("JavaEditor.SyncOutlineOnCursorMove".equals(property)) {
                if (newBooleanValue) {
                    this.selectionChanged();
                }
                return;
            }
            if ("markOccurrences".equals(property)) {
                if (newBooleanValue != this.fMarkOccurrenceAnnotations) {
                    this.fMarkOccurrenceAnnotations = newBooleanValue;
                    if (!this.fMarkOccurrenceAnnotations) {
                        this.uninstallOccurrencesFinder();
                    } else {
                        this.installOccurrencesFinder(true);
                    }
                }
                return;
            }
            if (property.equals(this.getBreadcrumbPreferenceKey())) {
                if (newBooleanValue != this.fIsBreadcrumbVisible) {
                    this.fIsBreadcrumbVisible = newBooleanValue;
                    if (this.fIsBreadcrumbVisible) {
                        this.showBreadcrumb();
                    } else {
                        this.hideBreadcrumb();
                    }
                }
                return;
            }
            if ("markTypeOccurrences".equals(property)) {
                this.fMarkTypeOccurrences = newBooleanValue;
                return;
            }
            if ("markMethodOccurrences".equals(property)) {
                this.fMarkMethodOccurrences = newBooleanValue;
                return;
            }
            if ("markConstantOccurrences".equals(property)) {
                this.fMarkConstantOccurrences = newBooleanValue;
                return;
            }
            if ("markFieldOccurrences".equals(property)) {
                this.fMarkFieldOccurrences = newBooleanValue;
                return;
            }
            if ("markLocalVariableOccurrences".equals(property)) {
                this.fMarkLocalVariableypeOccurrences = newBooleanValue;
                return;
            }
            if ("markExceptionOccurrences".equals(property)) {
                this.fMarkExceptions = newBooleanValue;
                return;
            }
            if ("markMethodExitPoints".equals(property)) {
                this.fMarkMethodExitPoints = newBooleanValue;
                return;
            }
            if ("markBreakContinueTargets".equals(property)) {
                this.fMarkBreakContinueTargets = newBooleanValue;
                return;
            }
            if ("markImplementors".equals(property)) {
                this.fMarkImplementors = newBooleanValue;
                return;
            }
            if ("stickyOccurrences".equals(property)) {
                this.fStickyOccurrenceAnnotations = newBooleanValue;
                return;
            }
            if (SemanticHighlightings.affectsEnablement(this.getPreferenceStore(), event)) {
                if (this.isSemanticHighlightingEnabled()) {
                    this.installSemanticHighlighting();
                } else {
                    this.uninstallSemanticHighlighting();
                }
                return;
            }
            if ("org.eclipse.jdt.core.compiler.source".equals(property) && event.getNewValue() instanceof String) {
                this.fBracketMatcher.setSourceVersion((String)event.getNewValue());
            }
            ((JavaSourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePropertyChangeEvent(event);
            if (this.affectsOverrideIndicatorAnnotations(event)) {
                if (this.isShowingOverrideIndicators()) {
                    if (this.fOverrideIndicatorManager == null) {
                        this.installOverrideIndicator(true);
                    }
                } else if (this.fOverrideIndicatorManager != null) {
                    this.uninstallOverrideIndicator();
                }
                return;
            }
            if ("editor_folding_provider".equals(property)) {
                if (sourceViewer instanceof ProjectionViewer) {
                    ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                    if (this.fProjectionModelUpdater != null) {
                        this.fProjectionModelUpdater.uninstall();
                    }
                    this.fProjectionModelUpdater = JavaPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                    if (this.fProjectionModelUpdater != null) {
                        this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                    }
                }
                return;
            }
            if ("org.eclipse.jdt.core.formatter.tabulation.size".equals(property) || "org.eclipse.jdt.core.formatter.indentation.size".equals(property) || "org.eclipse.jdt.core.formatter.tabulation.char".equals(property)) {
                StyledText textWidget = sourceViewer.getTextWidget();
                int tabWidth = this.getSourceViewerConfiguration().getTabWidth(sourceViewer);
                if (textWidget.getTabs() != tabWidth) {
                    textWidget.setTabs(tabWidth);
                }
                return;
            }
            if ("editor_folding_enabled".equals(property)) {
                if (sourceViewer instanceof ProjectionViewer) {
                    new ToggleFoldingRunner().runWhenNextVisible();
                }
                return;
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
        if ("show_range_indicator".equals(property)) {
            Object newValue = event.getNewValue();
            ISourceViewer viewer = this.getSourceViewer();
            if (newValue != null && viewer != null && Boolean.valueOf(newValue.toString()).booleanValue()) {
                Point selection = viewer.getSelectedRange();
                this.adjustHighlightRange(selection.x, selection.y);
            }
        }
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
    }

    private boolean isJavaEditorHoverProperty(String property) {
        return "hoverModifiers".equals(property);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    public Object getViewPartInput() {
        return this.getEditorInput().getAdapter(IJavaElement.class);
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    boolean isFoldingEnabled() {
        return JavaPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        if (this.isSemanticHighlightingEnabled()) {
            this.installSemanticHighlighting();
        }
        this.fBreadcrumb = this.createBreadcrumb();
        this.fIsBreadcrumbVisible = this.isBreadcrumbShown();
        if (this.fIsBreadcrumbVisible) {
            this.showBreadcrumb();
        }
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.fBracketMatcher.setSourceVersion(this.getPreferenceStore().getString("org.eclipse.jdt.core.compiler.source"));
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected void updateMarkerViews(Annotation annotation) {
        if (annotation instanceof IJavaAnnotation) {
            Iterator<IJavaAnnotation> e = ((IJavaAnnotation)annotation).getOverlaidIterator();
            if (e != null) {
                while (e.hasNext()) {
                    IJavaAnnotation o = e.next();
                    if (!(o instanceof MarkerAnnotation)) continue;
                    super.updateMarkerViews((Annotation)((MarkerAnnotation)o));
                    return;
                }
            }
            return;
        }
        super.updateMarkerViews(annotation);
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, CompilationUnit astRoot) {
        OccurrencesFinder finder;
        IBinding binding;
        IOccurrencesFinder finder2;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = JavaWordFinder.findWord(document, offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)selection.getOffset(), (int)selection.getLength());
        if (this.fMarkExceptions && ((ExceptionOccurrencesFinder)(finder2 = new ExceptionOccurrencesFinder())).initialize(astRoot, selectedNode) == null) {
            locations = ((ExceptionOccurrencesFinder)finder2).getOccurrences();
        }
        if (locations == null && this.fMarkMethodExitPoints && ((MethodExitsFinder)(finder2 = new MethodExitsFinder())).initialize(astRoot, selectedNode) == null) {
            locations = ((MethodExitsFinder)finder2).getOccurrences();
        }
        if (locations == null && this.fMarkBreakContinueTargets && ((BreakContinueTargetFinder)(finder2 = new BreakContinueTargetFinder())).initialize(astRoot, selectedNode) == null) {
            locations = ((BreakContinueTargetFinder)finder2).getOccurrences();
        }
        if (locations == null && this.fMarkImplementors && ((ImplementOccurrencesFinder)(finder2 = new ImplementOccurrencesFinder())).initialize(astRoot, selectedNode) == null) {
            locations = ((ImplementOccurrencesFinder)finder2).getOccurrences();
        }
        if (locations == null && selectedNode instanceof Name && (binding = ((Name)selectedNode).resolveBinding()) != null && this.markOccurrencesOfType(binding) && (finder = new OccurrencesFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        if (locations == null) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            } else if (hasChanged) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, CompilationUnit astRoot) {
                JavaEditor.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            ITypeRoot inputJavaElement = this.getInputJavaElement();
            if (inputJavaElement != null) {
                this.updateOccurrenceAnnotations((ITextSelection)this.fForcedMarkOccurrencesSelection, SharedASTProvider.getAST(inputJavaElement, SharedASTProvider.WAIT_NO, this.getProgressMonitor()));
            }
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected boolean isMarkingOccurrences() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null && store.getBoolean("markOccurrences");
    }

    protected boolean isBreadcrumbShown() {
        IPreferenceStore store = this.getPreferenceStore();
        String key = this.getBreadcrumbPreferenceKey();
        return store != null && key != null && store.getBoolean(key);
    }

    boolean markOccurrencesOfType(IBinding binding) {
        if (binding == null) {
            return false;
        }
        int kind = binding.getKind();
        if (this.fMarkTypeOccurrences && kind == 2) {
            return true;
        }
        if (this.fMarkMethodOccurrences && kind == 4) {
            return true;
        }
        if (kind == 3) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            if (variableBinding.isField()) {
                boolean isConstant;
                int constantModifier = 24;
                boolean bl = isConstant = (variableBinding.getModifiers() & constantModifier) == constantModifier;
                if (isConstant) {
                    return this.fMarkConstantOccurrences;
                }
                return this.fMarkFieldOccurrences;
            }
            return this.fMarkLocalVariableypeOccurrences;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    protected void uninstallOverrideIndicator() {
        if (this.fOverrideIndicatorManager != null) {
            this.fOverrideIndicatorManager.removeAnnotations();
            this.fOverrideIndicatorManager = null;
        }
    }

    protected void installOverrideIndicator(boolean provideAST) {
        this.uninstallOverrideIndicator();
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        ITypeRoot inputElement = this.getInputJavaElement();
        if (model == null || inputElement == null) {
            return;
        }
        this.fOverrideIndicatorManager = new OverrideIndicatorManager(model, inputElement, null);
        if (provideAST) {
            CompilationUnit ast = SharedASTProvider.getAST(inputElement, SharedASTProvider.WAIT_ACTIVE_ONLY, this.getProgressMonitor());
            this.fOverrideIndicatorManager.reconciled(ast, true, this.getProgressMonitor());
        }
    }

    protected boolean isShowingOverrideIndicators() {
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.jdt.ui.overrideIndicator");
        IPreferenceStore store = this.getPreferenceStore();
        return this.getBoolean(store, preference.getHighlightPreferenceKey()) || this.getBoolean(store, preference.getVerticalRulerPreferenceKey()) || this.getBoolean(store, preference.getOverviewRulerPreferenceKey()) || this.getBoolean(store, preference.getTextPreferenceKey());
    }

    private boolean getBoolean(IPreferenceStore store, String key) {
        return key != null && store.getBoolean(key);
    }

    protected boolean affectsOverrideIndicatorAnnotations(PropertyChangeEvent event) {
        String key = event.getProperty();
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.jdt.ui.overrideIndicator");
        if (key == null || preference == null) {
            return false;
        }
        return key.equals(preference.getHighlightPreferenceKey()) || key.equals(preference.getVerticalRulerPreferenceKey()) || key.equals(preference.getOverviewRulerPreferenceKey()) || key.equals(preference.getTextPreferenceKey());
    }

    private boolean isSemanticHighlightingEnabled() {
        return SemanticHighlightings.isEnabled(this.getPreferenceStore());
    }

    protected void installSemanticHighlighting() {
        if (this.fSemanticManager == null) {
            this.fSemanticManager = new SemanticHighlightingManager();
            this.fSemanticManager.install(this, (JavaSourceViewer)this.getSourceViewer(), JavaPlugin.getDefault().getJavaTextTools().getColorManager(), this.getPreferenceStore());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticManager != null) {
            this.fSemanticManager.uninstall();
            this.fSemanticManager = null;
        }
    }

    protected ITypeRoot getInputJavaElement() {
        return EditorUtility.getEditorInputJavaElement((IEditorPart)this, false);
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        String message = null;
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (annotation instanceof IJavaAnnotation && ((IJavaAnnotation)annotation).isProblem() || JavaEditor.isProblemMarkerAnnotation(annotation)) {
                message = annotation.getText();
            }
        }
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(message);
    }

    public void setStatusLineErrorMessage(String message) {
        long now = System.currentTimeMillis();
        if (message != null || now - this.fErrorMessageTime > 1000L) {
            super.setStatusLineErrorMessage(message);
            this.fErrorMessageTime = message != null ? now : 0L;
        }
    }

    protected void setStatusLineMessage(String message) {
        if (System.currentTimeMillis() - this.fErrorMessageTime > 1000L) {
            super.setStatusLineMessage(message);
        }
    }

    private static boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(JavaEditorMessages.GotoMatchingBracket_error_invalidSelection);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (JavaEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(JavaEditorMessages.GotoMatchingBracket_error_noMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(JavaEditorMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = JavaEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public Point getCachedSelectedRange() {
        return this.fCachedSelectedRange;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.fCachedSelectedRange = this.getViewer().getSelectedRange();
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return JavaEditor.isBracket(document.getChar(offset - 1)) && JavaEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected Annotation findAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        JavaAnnotationIterator e = new JavaAnnotationIterator(model.getAnnotationIterator(), true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (a instanceof IJavaAnnotation && ((IJavaAnnotation)a).hasOverlay() || !this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator parent = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        JavaAnnotationIterator e = new JavaAnnotationIterator(parent, false);
        while (e.hasNext()) {
            Annotation a = (Annotation)e.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    public Annotation gotoAnnotation(boolean forward) {
        this.fSelectionChangedViaGotoAnnotation = true;
        return super.gotoAnnotation(forward);
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = this.getElementAt(caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    protected IJavaElement getElementAt(int offset, boolean reconcile) {
        return this.getElementAt(offset);
    }

    protected LineChangeHover createChangeHover() {
        return new JavaChangeHover("___java_partitioning", this.getOrientation());
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        Object action = new SmartLineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new SmartLineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        if (!this.getPreferenceStore().getBoolean("editor_annotation_roll_over")) {
            return super.createAnnotationRulerColumn(ruler);
        }
        AnnotationRulerColumn column = new AnnotationRulerColumn(12, this.getAnnotationAccess());
        column.setHover((IAnnotationHover)new JavaExpandHover(ruler, this.getAnnotationAccess(), new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                this.triggerAction("RulerDoubleClick");
            }

            private void triggerAction(String actionID) {
                IAction action = JavaEditor.this.getAction(actionID);
                if (action != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (action instanceof ISelectionListener) {
                        ((ISelectionListener)action).selectionChanged(null, null);
                    }
                    if (action.isEnabled()) {
                        action.run();
                    }
                }
            }
        }));
        return column;
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(JavaEditorMessages.Editor_FoldingMenu_name, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseMembers");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseComments");
        foldingMenu.add(action);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] inheritedPages = super.collectContextMenuPreferencePages();
        int length = 10;
        String[] result = new String[inheritedPages.length + length];
        result[0] = "org.eclipse.jdt.ui.preferences.JavaEditorPreferencePage";
        result[1] = "org.eclipse.jdt.ui.preferences.JavaTemplatePreferencePage";
        result[2] = "org.eclipse.jdt.ui.preferences.CodeAssistPreferencePage";
        result[3] = "org.eclipse.jdt.ui.preferences.CodeAssistPreferenceAdvanced";
        result[4] = "org.eclipse.jdt.ui.preferences.JavaEditorHoverPreferencePage";
        result[5] = "org.eclipse.jdt.ui.preferences.JavaEditorColoringPreferencePage";
        result[6] = "org.eclipse.jdt.ui.preferences.FoldingPreferencePage";
        result[7] = "org.eclipse.jdt.ui.preferences.MarkOccurrencesPreferencePage";
        result[8] = "org.eclipse.jdt.ui.preferences.SmartTypingPreferencePage";
        result[9] = "org.eclipse.jdt.ui.preferences.SaveParticipantPreferencePage";
        System.arraycopy(inheritedPages, 0, result, length, inheritedPages.length);
        return result;
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext undoContext) {
        return new NonLocalUndoUserApprover(undoContext, (IEditorPart)this, new Object[]{this.getInputJavaElement()}, IResource.class);
    }

    public void resetProjection() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    public void collapseMembers() {
        if (this.fProjectionModelUpdater instanceof IJavaFoldingStructureProviderExtension) {
            IJavaFoldingStructureProviderExtension extension = (IJavaFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseMembers();
        }
    }

    public void collapseComments() {
        if (this.fProjectionModelUpdater instanceof IJavaFoldingStructureProviderExtension) {
            IJavaFoldingStructureProviderExtension extension = (IJavaFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseComments();
        }
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == JavaEditor.this.getEditorSite().getWorkbenchWindow() && JavaEditor.this.fMarkOccurrenceAnnotations && JavaEditor.this.isActivePart()) {
                JavaEditor.this.fForcedMarkOccurrencesSelection = JavaEditor.this.getSelectionProvider().getSelection();
                ITypeRoot inputJavaElement = JavaEditor.this.getInputJavaElement();
                if (inputJavaElement != null) {
                    JavaEditor.this.updateOccurrenceAnnotations((ITextSelection)JavaEditor.this.fForcedMarkOccurrencesSelection, SharedASTProvider.getAST(inputJavaElement, SharedASTProvider.WAIT_NO, JavaEditor.this.getProgressMonitor()));
                }
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == JavaEditor.this.getEditorSite().getWorkbenchWindow() && JavaEditor.this.fMarkOccurrenceAnnotations && JavaEditor.this.isActivePart()) {
                JavaEditor.this.removeOccurrenceAnnotations();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        protected void setCaretPosition(int position) {
            if (!JavaEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (JavaEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = JavaEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(127);
            } else {
                int length;
                int caret;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    caret = selection.x;
                    length = selection.y;
                } else {
                    caret = JavaEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset());
                    length = position - caret;
                }
                try {
                    viewer.getDocument().replace(caret, length, "");
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void update() {
            this.setEnabled(JavaEditor.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        protected void setCaretPosition(int position) {
            if (!JavaEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (JavaEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = JavaEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(8);
            } else {
                int length;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    position = selection.x;
                    length = selection.y;
                } else {
                    length = JavaEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset()) - position;
                }
                try {
                    viewer.getDocument().replace(position, length, "");
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void update() {
            this.setEnabled(JavaEditor.this.isEditorInputModifiable());
        }
    }

    private static class EclipsePreferencesAdapter
    implements IPreferenceStore {
        private ListenerList fListeners = new ListenerList(1);
        private IEclipsePreferences.IPreferenceChangeListener fListener = new PreferenceChangeListener();
        private final IScopeContext fContext;
        private final String fQualifier;

        public EclipsePreferencesAdapter(IScopeContext context, String qualifier) {
            this.fContext = context;
            this.fQualifier = qualifier;
        }

        private IEclipsePreferences getNode() {
            return this.fContext.getNode(this.fQualifier);
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            if (this.fListeners.size() == 0) {
                this.getNode().addPreferenceChangeListener(this.fListener);
            }
            this.fListeners.add((Object)listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.size() == 0) {
                this.getNode().removePreferenceChangeListener(this.fListener);
            }
        }

        public boolean contains(String name) {
            return this.getNode().get(name, null) != null;
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }

        public boolean getBoolean(String name) {
            return this.getNode().getBoolean(name, false);
        }

        public boolean getDefaultBoolean(String name) {
            return false;
        }

        public double getDefaultDouble(String name) {
            return 0.0;
        }

        public float getDefaultFloat(String name) {
            return 0.0f;
        }

        public int getDefaultInt(String name) {
            return 0;
        }

        public long getDefaultLong(String name) {
            return 0L;
        }

        public String getDefaultString(String name) {
            return "";
        }

        public double getDouble(String name) {
            return this.getNode().getDouble(name, 0.0);
        }

        public float getFloat(String name) {
            return this.getNode().getFloat(name, 0.0f);
        }

        public int getInt(String name) {
            return this.getNode().getInt(name, 0);
        }

        public long getLong(String name) {
            return this.getNode().getLong(name, 0L);
        }

        public String getString(String name) {
            return this.getNode().get(name, "");
        }

        public boolean isDefault(String name) {
            return false;
        }

        public boolean needsSaving() {
            try {
                return this.getNode().keys().length > 0;
            }
            catch (BackingStoreException backingStoreException) {
                return true;
            }
        }

        public void putValue(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, double value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, float value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, int value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, String defaultObject) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        public void setToDefault(String name) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, double value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, float value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, int value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        private class PreferenceChangeListener
        implements IEclipsePreferences.IPreferenceChangeListener {
            private PreferenceChangeListener() {
            }

            public void preferenceChange(final IEclipsePreferences.PreferenceChangeEvent event) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                        }
                    });
                } else {
                    EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                }
            }
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JavaEditor.this.selectionChanged();
        }
    }

    protected class FormatElementAction
    extends Action
    implements IUpdate {
        FormatElementAction() {
            this.setText(JavaEditorMessages.JavaEditor_FormatElementAction_label);
            this.setDescription(JavaEditorMessages.JavaEditor_FormatElementAction_description);
            this.setEnabled(JavaEditor.this.isEditorInputModifiable());
        }

        public void run() {
            JavaSourceViewer viewer = (JavaSourceViewer)JavaEditor.this.getSourceViewer();
            if (viewer.isEditable() && ElementValidator.check((IJavaElement)JavaEditor.this.getInputJavaElement(), JavaEditor.this.getSite().getShell(), JavaEditorMessages.JavaEditor_FormatElementDialog_label, true)) {
                Point selection = viewer.rememberSelection();
                try {
                    ITypedRegion partition;
                    String type;
                    boolean emptySelection;
                    viewer.setRedraw(false);
                    boolean bl = emptySelection = selection.y == 0;
                    if (emptySelection && ("__java_javadoc".equals(type = (partition = TextUtilities.getPartition((IDocument)viewer.getDocument(), (String)"___java_partitioning", (int)selection.x, (boolean)true)).getType()) || "__java_multiline_comment".equals(type) || "__java_singleline_comment".equals(type))) {
                        viewer.setSelectedRange(partition.getOffset(), partition.getLength());
                        viewer.doOperation(15);
                        return;
                    }
                    try {
                        IJavaElement element = JavaEditor.this.getElementAt(selection.x, true);
                        if (element != null && element.exists()) {
                            try {
                                int kind = element.getElementType();
                                if (kind == 7 || kind == 9 || kind == 10) {
                                    boolean seletionInNameRange;
                                    ISourceReference reference = (ISourceReference)element;
                                    ISourceRange range = reference.getSourceRange();
                                    ISourceRange nameRange = reference.getNameRange();
                                    boolean bl2 = seletionInNameRange = nameRange != null && selection.x >= nameRange.getOffset() && selection.x + selection.y <= nameRange.getOffset() + nameRange.getLength();
                                    if (range != null && (emptySelection || seletionInNameRange)) {
                                        viewer.setSelectedRange(range.getOffset(), range.getLength());
                                    }
                                }
                            }
                            catch (JavaModelException javaModelException) {}
                        }
                        viewer.doOperation(15);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    viewer.setRedraw(true);
                    viewer.restoreSelection();
                }
            }
        }

        public void update() {
            this.setEnabled(JavaEditor.this.isEditorInputModifiable());
        }
    }

    class JdtSelectionProvider
    extends AbstractTextEditor.SelectionProvider {
        private ListenerList fSelectionListeners;
        private ListenerList fPostSelectionListeners;
        private ITextSelection fInvalidSelection;
        private ISelection fValidSelection;

        JdtSelectionProvider() {
            super((AbstractTextEditor)JavaEditor.this);
            this.fSelectionListeners = new ListenerList();
            this.fPostSelectionListeners = new ListenerList();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            super.addSelectionChangedListener(listener);
            if (JavaEditor.this.getSourceViewer() != null) {
                this.fSelectionListeners.add((Object)listener);
            }
        }

        public ISelection getSelection() {
            if (this.fInvalidSelection != null) {
                return this.fInvalidSelection;
            }
            return super.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            super.removeSelectionChangedListener(listener);
            if (JavaEditor.this.getSourceViewer() != null) {
                this.fSelectionListeners.remove((Object)listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof ITextSelection) {
                if (this.fInvalidSelection != null) {
                    this.fInvalidSelection = null;
                    ITextSelection newSelection = (ITextSelection)selection;
                    ITextSelection oldSelection = (ITextSelection)this.getSelection();
                    if (newSelection.getOffset() == oldSelection.getOffset() && newSelection.getLength() == oldSelection.getLength()) {
                        this.markValid();
                    } else {
                        super.setSelection(selection);
                    }
                } else {
                    super.setSelection(selection);
                }
            } else if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EditorBreadcrumb) {
                this.markInvalid();
            }
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            super.addPostSelectionChangedListener(listener);
            if (JavaEditor.this.getSourceViewer() != null && JavaEditor.this.getSourceViewer().getSelectionProvider() instanceof IPostSelectionProvider) {
                this.fPostSelectionListeners.add((Object)listener);
            }
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            super.removePostSelectionChangedListener(listener);
            if (JavaEditor.this.getSourceViewer() != null) {
                this.fPostSelectionListeners.remove((Object)listener);
            }
        }

        public boolean isValid(ISelection postSelection) {
            return this.fInvalidSelection == null && super.isValid(postSelection);
        }

        private void markInvalid() {
            this.fValidSelection = this.getSelection();
            this.fInvalidSelection = new TextSelection(0, 0);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.fInvalidSelection);
            Object[] listeners = this.fSelectionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
                ++i;
            }
            listeners = this.fPostSelectionListeners.getListeners();
            i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
                ++i;
            }
        }

        private void markValid() {
            this.fInvalidSelection = null;
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.fValidSelection);
            Object[] listeners = this.fSelectionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
                ++i;
            }
            listeners = this.fPostSelectionListeners.getListeners();
            i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
                ++i;
            }
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(JavaEditor.modelOffset2WidgetOffset((ISourceViewer)JavaEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(JavaEditor.modelOffset2WidgetOffset((ISourceViewer)JavaEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected JavaWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(JavaEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new JavaWordIterator();
        }

        public void run() {
            IPreferenceStore store = JavaEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = JavaEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int next = this.findNextPosition(position);
                if (JavaEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            int widget = -1;
            int next = position;
            while (next != -1 && widget == -1) {
                if ((next = this.fIterator.following(next)) == -1) continue;
                widget = JavaEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)next);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                    if (position != linkedPositionEnd && linkedPositionEnd < next) {
                        next = linkedPositionEnd;
                    }
                } else {
                    int nextLinkedPositionOffset;
                    LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                    if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                        next = nextLinkedPositionOffset;
                    }
                }
            }
            return next;
        }

        protected abstract void setCaretPosition(int var1);
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super(JavaEditorMessages.JavaEditor_markOccurrences_job_name);
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = JavaEditor.this.getSelectionProvider() instanceof ISelectionValidator ? (ISelectionValidator)JavaEditor.this.getSelectionProvider() : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && JavaEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = JavaEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = JavaEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)JavaEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.jdt.ui.occurrences.write" : "org.eclipse.jdt.ui.occurrences";
                annotationMap.put(new Annotation(annotationType, false, description), position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = JavaEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(JavaEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    JavaEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                JavaEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = JavaEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = JavaEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = JavaEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)JavaEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (JavaEditor.this.fOccurrencesFinderJob != null) {
                JavaEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected JavaWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(JavaEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new JavaWordIterator();
        }

        public void run() {
            IPreferenceStore store = JavaEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = JavaEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int previous = this.findPreviousPosition(position);
                if (JavaEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            int widget = -1;
            int previous = position;
            while (previous != -1 && widget == -1) {
                if ((previous = this.fIterator.preceding(previous)) == -1) continue;
                widget = JavaEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)previous);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionOffset = linkedPosition.getOffset();
                    if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                        previous = linkedPositionOffset;
                    }
                } else {
                    int previousLinkedPositionEnd;
                    LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                    if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                        previous = previousLinkedPositionEnd;
                    }
                }
            }
            return previous;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = JavaEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = JavaEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        public SmartLineStartAction(StyledText textWidget, boolean doSelect) {
            super((AbstractTextEditor)JavaEditor.this, textWidget, doSelect);
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            String type = "__dftl_partition_content_type";
            try {
                type = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
            }
            catch (BadLocationException badLocationException) {}
            int index = super.getLineStartPosition(document, line, length, offset);
            if (type.equals("__java_javadoc") || type.equals("__java_multiline_comment")) {
                if (index < length - 1 && line.charAt(index) == '*' && line.charAt(index + 1) != '/') {
                    while (++index < length && Character.isWhitespace(line.charAt(index))) {
                    }
                }
            } else if (index < length - 1 && line.charAt(index) == '/' && line.charAt(index + 1) == '/') {
                ++index;
                while (++index < length && Character.isWhitespace(line.charAt(index))) {
                }
            }
            return index;
        }
    }

    private final class ToggleFoldingRunner
    implements IPartListener2 {
        private IWorkbenchPage fPage;

        private ToggleFoldingRunner() {
        }

        private void toggleFolding() {
            ProjectionViewer pv;
            ISourceViewer sourceViewer = JavaEditor.this.getSourceViewer();
            if (sourceViewer instanceof ProjectionViewer && (pv = (ProjectionViewer)sourceViewer).isProjectionMode() != JavaEditor.this.isFoldingEnabled() && pv.canDoOperation(19)) {
                pv.doOperation(19);
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage page;
            if (JavaEditor.this.fFoldingRunner != null) {
                JavaEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite site = JavaEditor.this.getSite();
            if (site != null && !(page = site.getPage()).isPartVisible((IWorkbenchPart)JavaEditor.this)) {
                this.fPage = page;
                JavaEditor.this.fFoldingRunner = this;
                page.addPartListener((IPartListener2)this);
                return;
            }
            this.toggleFolding();
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (JavaEditor.this.fFoldingRunner == this) {
                JavaEditor.this.fFoldingRunner = null;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (JavaEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
                this.toggleFolding();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (JavaEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

