/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.PlainReplacementFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class PlainReplacementCleanUpCore
extends AbstractCleanUp {
    public PlainReplacementCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PlainReplacementCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.plain_replacement");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.plain_replacement")) {
            return null;
        }
        return PlainReplacementFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.plain_replacement")) {
            result.add(MultiFixMessages.PlainReplacementCleanUp_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.plain_replacement")) {
            return "String result = text.replace(\"foo\", \"bar\");\nString result2 = text.replace(\"$0.02\", \"$0.50\");\nString result3 = text.replace('.', '/');\nString result4 = text.replace(placeholder, value);\n";
        }
        return "String result = text.replaceAll(\"foo\", \"bar\");\nString result2 = text.replaceAll(\"\\\\$0\\\\.02\", \"\\\\$0.50\");\nString result3 = text.replaceAll(\"\\\\.\", \"/\");\nString result4 = text.replaceAll(Pattern.quote(placeholder), Matcher.quoteReplacement(value));\n";
    }
}

