/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ExceptionCollector {
    private final List<IStatus> statuses = new ArrayList<IStatus>();
    private final String message;
    private final String pluginId;
    private final int severity;
    private final ILog log;

    public ExceptionCollector(String message, String pluginId, int severity, ILog log) {
        this.message = message;
        this.pluginId = pluginId;
        this.severity = severity;
        this.log = log;
    }

    public void clear() {
        this.statuses.clear();
    }

    public IStatus getStatus() {
        if (this.statuses.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus multiStatus = new MultiStatus(this.pluginId, this.severity, this.message, null);
        for (IStatus status : this.statuses) {
            multiStatus.merge(status);
        }
        return multiStatus;
    }

    public void handleException(CoreException exception) {
        IStatus[] children;
        if (this.log != null) {
            this.log.log((IStatus)new Status(this.severity, this.pluginId, 0, this.message, (Throwable)exception));
        }
        IStatus exceptionStatus = exception.getStatus();
        Status status = new Status(exceptionStatus.getSeverity(), exceptionStatus.getPlugin(), exceptionStatus.getCode(), exceptionStatus.getMessage(), (Throwable)exception);
        this.recordStatus((IStatus)status);
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status2 = iStatusArray[n2];
            this.recordStatus(status2);
            ++n2;
        }
    }

    private void recordStatus(IStatus status) {
        this.statuses.add(status);
    }
}

