/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.junit.Assert;

public abstract class AbstractLineTrackerTest {
    protected ITextStore fText;
    protected ILineTracker fTracker;

    protected final void checkLines(int[] lines) throws BadLocationException {
        Assert.assertEquals((String)"number of lines", (long)lines.length, (long)this.fTracker.getNumberOfLines());
        int i = 0;
        while (i < lines.length) {
            IRegion line = this.fTracker.getLineInformation(i);
            Assert.assertEquals((String)("line lenght of line " + i), (long)lines[i], (long)line.getLength());
            Assert.assertEquals((String)("line offset of line " + i), (long)this.getLineOffset(i, lines), (long)line.getOffset());
            ++i;
        }
    }

    abstract int getLineOffset(int var1, int[] var2);

    protected final void replace(int offset, int length, String text) throws BadLocationException {
        this.fTracker.replace(offset, length, text);
        this.fText.replace(offset, length, text);
    }

    protected final void set(String string) {
        this.fText.set(string);
        this.fTracker.set(string);
    }
}

